/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.LinearSeq;
import scala.collection.LinearSeqIterator;
import scala.collection.SeqOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public interface LinearSeqOps<A, CC extends LinearSeq<Object>, C extends LinearSeq<A> & LinearSeqOps<A, CC, C>>
extends SeqOps<A, CC, C>,
Object {
    public static void $init$(LinearSeqOps $this) {
    }

    public /* synthetic */ boolean scala$collection$LinearSeqOps$$super$sameElements(IterableOnce var1);

    @Override
    public boolean isEmpty();

    @Override
    public A head();

    @Override
    public C tail();

    public static Option headOption$(LinearSeqOps $this) {
        return $this.headOption();
    }

    @Override
    default public Option<A> headOption() {
        if (this.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.head());
    }

    public static Iterator iterator$(LinearSeqOps $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<A> iterator() {
        if (this.knownSize() == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new LinearSeqIterator(this);
    }

    public static int length$(LinearSeqOps $this) {
        return $this.length();
    }

    @Override
    default public int length() {
        LinearSeq these = (LinearSeq)this.coll();
        int len = 0;
        while (these.nonEmpty()) {
            ++len;
            these = (LinearSeq)these.tail();
        }
        return len;
    }

    public static Object last$(LinearSeqOps $this) {
        return $this.last();
    }

    @Override
    default public A last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("LinearSeq.last");
        }
        LinearSeq<Object> these = (LinearSeq)this.coll();
        Object scout = this.tail();
        while (scout.nonEmpty()) {
            these = scout;
            scout = (LinearSeq)scout.tail();
        }
        return these.head();
    }

    public static int lengthCompare$(LinearSeqOps $this, int len) {
        return $this.lengthCompare(len);
    }

    @Override
    default public int lengthCompare(int len) {
        if (len < 0) {
            return 1;
        }
        return LinearSeqOps.loop$1(len, 0, (LinearSeq)this.coll());
    }

    public static int lengthCompare$(LinearSeqOps $this, Iterable that) {
        return $this.lengthCompare(that);
    }

    @Override
    default public int lengthCompare(Iterable<?> that) {
        int thatKnownSize = that.knownSize();
        if (thatKnownSize >= 0) {
            return this.lengthCompare(thatKnownSize);
        }
        Iterable<?> iterable = that;
        if (iterable instanceof LinearSeq) {
            LinearSeq linearSeq;
            LinearSeq that2 = linearSeq = (LinearSeq)iterable;
            LinearSeqOps<A, CC, C> thisSeq = this;
            LinearSeq thatSeq = that2;
            while (thisSeq.nonEmpty() && thatSeq.nonEmpty()) {
                thisSeq = thisSeq.tail();
                thatSeq = (LinearSeq)thatSeq.tail();
            }
            return Boolean.compare(thisSeq.nonEmpty(), thatSeq.nonEmpty());
        }
        LinearSeqOps<A, CC, C> thisSeq = this;
        Iterator thatIt = that.iterator();
        while (thisSeq.nonEmpty() && thatIt.hasNext()) {
            thisSeq = thisSeq.tail();
            thatIt.next();
        }
        return Boolean.compare(thisSeq.nonEmpty(), thatIt.hasNext());
    }

    public static boolean isDefinedAt$(LinearSeqOps $this, int x) {
        return $this.isDefinedAt(x);
    }

    @Override
    default public boolean isDefinedAt(int x) {
        return x >= 0 && this.lengthCompare(x) > 0;
    }

    public static Object apply$(LinearSeqOps $this, int n) {
        return $this.apply(n);
    }

    @Override
    default public A apply(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        LinearSeq skipped = (LinearSeq)this.drop(n);
        if (skipped.isEmpty()) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        return skipped.head();
    }

    public static void foreach$(LinearSeqOps $this, Function1 f) {
        $this.foreach(f);
    }

    @Override
    default public <U> void foreach(Function1<A, U> f) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            f.apply(these.head());
            these = (LinearSeq)these.tail();
        }
    }

    public static boolean forall$(LinearSeqOps $this, Function1 p) {
        return $this.forall(p);
    }

    @Override
    default public boolean forall(Function1<A, Object> p) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            if (!BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return false;
            }
            these = (LinearSeq)these.tail();
        }
        return true;
    }

    public static boolean exists$(LinearSeqOps $this, Function1 p) {
        return $this.exists(p);
    }

    @Override
    default public boolean exists(Function1<A, Object> p) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return true;
            }
            these = (LinearSeq)these.tail();
        }
        return false;
    }

    public static boolean contains$(LinearSeqOps $this, Object elem) {
        return $this.contains(elem);
    }

    @Override
    default public <A1> boolean contains(A1 elem) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            if (BoxesRunTime.equals(these.head(), elem)) {
                return true;
            }
            these = (LinearSeq)these.tail();
        }
        return false;
    }

    public static Option find$(LinearSeqOps $this, Function1 p) {
        return $this.find(p);
    }

    @Override
    default public Option<A> find(Function1<A, Object> p) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return Some$.MODULE$.apply(these.head());
            }
            these = (LinearSeq)these.tail();
        }
        return None$.MODULE$;
    }

    public static Object foldLeft$(LinearSeqOps $this, Object z, Function2 op) {
        return $this.foldLeft(z, op);
    }

    @Override
    default public <B> B foldLeft(B z, Function2<B, A, B> op) {
        B acc = z;
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            acc = op.apply(acc, these.head());
            these = (LinearSeq)these.tail();
        }
        return acc;
    }

    public static boolean sameElements$(LinearSeqOps $this, IterableOnce that) {
        return $this.sameElements(that);
    }

    @Override
    default public <B> boolean sameElements(IterableOnce<B> that) {
        IterableOnce<B> iterableOnce = that;
        if (iterableOnce instanceof LinearSeq) {
            LinearSeq linearSeq;
            LinearSeq that2 = linearSeq = (LinearSeq)iterableOnce;
            return LinearSeqOps.linearSeqEq$1((LinearSeq)this.coll(), that2);
        }
        return this.scala$collection$LinearSeqOps$$super$sameElements(that);
    }

    public static int segmentLength$(LinearSeqOps $this, Function1 p, int from) {
        return $this.segmentLength(p, from);
    }

    @Override
    default public int segmentLength(Function1<A, Object> p, int from) {
        int i = 0;
        LinearSeq seq = (LinearSeq)this.drop(from);
        while (seq.nonEmpty() && BoxesRunTime.unboxToBoolean(p.apply(seq.head()))) {
            ++i;
            seq = (LinearSeq)seq.tail();
        }
        return i;
    }

    public static int indexWhere$(LinearSeqOps $this, Function1 p, int from) {
        return $this.indexWhere(p, from);
    }

    @Override
    default public int indexWhere(Function1<A, Object> p, int from) {
        int i = package$.MODULE$.max(from, 0);
        LinearSeq these = (LinearSeq)this.drop(from);
        while (these.nonEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return i;
            }
            ++i;
            these = (LinearSeq)these.tail();
        }
        return -1;
    }

    public static int lastIndexWhere$(LinearSeqOps $this, Function1 p, int end) {
        return $this.lastIndexWhere(p, end);
    }

    @Override
    default public int lastIndexWhere(Function1<A, Object> p, int end) {
        LinearSeq these = (LinearSeq)this.coll();
        int last = -1;
        for (int i = 0; !these.isEmpty() && i <= end; ++i) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                last = i;
            }
            these = (LinearSeq)these.tail();
        }
        return last;
    }

    public static Option findLast$(LinearSeqOps $this, Function1 p) {
        return $this.findLast(p);
    }

    @Override
    default public Option<A> findLast(Function1<A, Object> p) {
        LinearSeq these = (LinearSeq)this.coll();
        boolean found = false;
        Object last = null;
        while (these.nonEmpty()) {
            Object elem = these.head();
            if (BoxesRunTime.unboxToBoolean(p.apply(elem))) {
                found = true;
                last = elem;
            }
            these = (LinearSeq)these.tail();
        }
        if (found) {
            return Some$.MODULE$.apply(last);
        }
        return None$.MODULE$;
    }

    public static Iterator tails$(LinearSeqOps $this) {
        return $this.tails();
    }

    @Override
    default public Iterator<C> tails() {
        Iterator end = Iterator$.MODULE$.single(this.empty());
        return Iterator$.MODULE$.iterate(this.coll(), (Function1<LinearSeq, LinearSeq> & Serializable)_$1 -> (LinearSeq)_$1.tail()).takeWhile((Function1<LinearSeq, Boolean> & Serializable)_$2 -> _$2.nonEmpty()).$plus$plus(() -> LinearSeqOps.tails$$anonfun$3(end));
    }

    private static int loop$1(int len$1, int i, LinearSeq xs) {
        while (true) {
            if (i == len$1) {
                if (xs.isEmpty()) {
                    return 0;
                }
                return 1;
            }
            if (xs.isEmpty()) {
                return -1;
            }
            int n = i + 1;
            LinearSeq linearSeq = (LinearSeq)xs.tail();
            i = n;
            xs = linearSeq;
        }
    }

    private static boolean linearSeqEq$1(LinearSeq a, LinearSeq b) {
        boolean bl;
        block3: {
            block2: {
                while (a != b) {
                    if (a.nonEmpty() && b.nonEmpty() && BoxesRunTime.equals(a.head(), b.head())) {
                        LinearSeq linearSeq = (LinearSeq)a.tail();
                        LinearSeq linearSeq2 = (LinearSeq)b.tail();
                        a = linearSeq;
                        b = linearSeq2;
                        continue;
                    }
                    if (!a.isEmpty() || !b.isEmpty()) break block2;
                }
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private static IterableOnce tails$$anonfun$3(Iterator end$1) {
        return end$1;
    }
}

