# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("wlanapi.dll")
prototypes = \
    {
        #
        'WlanOpenHandle': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwClientVersion", "pReserved", "pdwNegotiatedVersion", "phClientHandle"]),
        #
        'WlanCloseHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pReserved"]),
        #
        'WlanEnumInterfaces': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "InterfaceInfo": SimTypePointer(SimStruct({"InterfaceGuid": SimTypeBottom(label="Guid"), "strInterfaceDescription": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "isState": SimTypeInt(signed=False, label="WLAN_INTERFACE_STATE")}, name="WLAN_INTERFACE_INFO", pack=False, align=None), offset=0)}, name="WLAN_INTERFACE_INFO_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pReserved", "ppInterfaceList"]),
        #
        'WlanSetAutoConfigParameter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WLAN_AUTOCONF_OPCODE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "OpCode", "dwDataSize", "pData", "pReserved"]),
        #
        'WlanQueryAutoConfigParameter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WLAN_AUTOCONF_OPCODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_OPCODE_VALUE_TYPE"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "OpCode", "pReserved", "pdwDataSize", "ppData", "pWlanOpcodeValueType"]),
        #
        'WlanGetInterfaceCapability': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"interfaceType": SimTypeInt(signed=False, label="WLAN_INTERFACE_TYPE"), "bDot11DSupported": SimTypeInt(signed=True, label="Int32"), "dwMaxDesiredSsidListSize": SimTypeInt(signed=False, label="UInt32"), "dwMaxDesiredBssidListSize": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfSupportedPhys": SimTypeInt(signed=False, label="UInt32"), "dot11PhyTypes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="DOT11_PHY_TYPE"), 64)}, name="WLAN_INTERFACE_CAPABILITY", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "pReserved", "ppCapability"]),
        #
        'WlanSetInterface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="WLAN_INTF_OPCODE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "OpCode", "dwDataSize", "pData", "pReserved"]),
        #
        'WlanQueryInterface': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="WLAN_INTF_OPCODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_OPCODE_VALUE_TYPE"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "OpCode", "pReserved", "pdwDataSize", "ppData", "pWlanOpcodeValueType"]),
        #
        'WlanIhvControl': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="WLAN_IHV_CONTROL_TYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "Type", "dwInBufferSize", "pInBuffer", "dwOutBufferSize", "pOutBuffer", "pdwBytesReturned"]),
        #
        'WlanScan': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"uSSIDLength": SimTypeInt(signed=False, label="UInt32"), "ucSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="DOT11_SSID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwDataSize": SimTypeInt(signed=False, label="UInt32"), "DataBlob": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WLAN_RAW_DATA", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "pDot11Ssid", "pIeData", "pReserved"]),
        #
        'WlanGetAvailableNetworkList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "Network": SimTypePointer(SimStruct({"strProfileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "dot11Ssid": SimStruct({"uSSIDLength": SimTypeInt(signed=False, label="UInt32"), "ucSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="DOT11_SSID", pack=False, align=None), "dot11BssType": SimTypeInt(signed=False, label="DOT11_BSS_TYPE"), "uNumberOfBssids": SimTypeInt(signed=False, label="UInt32"), "bNetworkConnectable": SimTypeInt(signed=True, label="Int32"), "wlanNotConnectableReason": SimTypeInt(signed=False, label="UInt32"), "uNumberOfPhyTypes": SimTypeInt(signed=False, label="UInt32"), "dot11PhyTypes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="DOT11_PHY_TYPE"), 8), "bMorePhyTypes": SimTypeInt(signed=True, label="Int32"), "wlanSignalQuality": SimTypeInt(signed=False, label="UInt32"), "bSecurityEnabled": SimTypeInt(signed=True, label="Int32"), "dot11DefaultAuthAlgorithm": SimTypeInt(signed=False, label="DOT11_AUTH_ALGORITHM"), "dot11DefaultCipherAlgorithm": SimTypeInt(signed=False, label="DOT11_CIPHER_ALGORITHM"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="WLAN_AVAILABLE_NETWORK", pack=False, align=None), offset=0)}, name="WLAN_AVAILABLE_NETWORK_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "dwFlags", "pReserved", "ppAvailableNetworkList"]),
        #
        'WlanGetAvailableNetworkList2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "Network": SimTypePointer(SimStruct({"strProfileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "dot11Ssid": SimStruct({"uSSIDLength": SimTypeInt(signed=False, label="UInt32"), "ucSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="DOT11_SSID", pack=False, align=None), "dot11BssType": SimTypeInt(signed=False, label="DOT11_BSS_TYPE"), "uNumberOfBssids": SimTypeInt(signed=False, label="UInt32"), "bNetworkConnectable": SimTypeInt(signed=True, label="Int32"), "wlanNotConnectableReason": SimTypeInt(signed=False, label="UInt32"), "uNumberOfPhyTypes": SimTypeInt(signed=False, label="UInt32"), "dot11PhyTypes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="DOT11_PHY_TYPE"), 8), "bMorePhyTypes": SimTypeInt(signed=True, label="Int32"), "wlanSignalQuality": SimTypeInt(signed=False, label="UInt32"), "bSecurityEnabled": SimTypeInt(signed=True, label="Int32"), "dot11DefaultAuthAlgorithm": SimTypeInt(signed=False, label="DOT11_AUTH_ALGORITHM"), "dot11DefaultCipherAlgorithm": SimTypeInt(signed=False, label="DOT11_CIPHER_ALGORITHM"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "AccessNetworkOptions": SimStruct({"AccessNetworkType": SimTypeChar(label="Byte"), "Internet": SimTypeChar(label="Byte"), "ASRA": SimTypeChar(label="Byte"), "ESR": SimTypeChar(label="Byte"), "UESA": SimTypeChar(label="Byte")}, name="DOT11_ACCESSNETWORKOPTIONS", pack=False, align=None), "dot11HESSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "VenueInfo": SimStruct({"VenueGroup": SimTypeChar(label="Byte"), "VenueType": SimTypeChar(label="Byte")}, name="DOT11_VENUEINFO", pack=False, align=None), "dwReserved": SimTypeInt(signed=False, label="UInt32")}, name="WLAN_AVAILABLE_NETWORK_V2", pack=False, align=None), offset=0)}, name="WLAN_AVAILABLE_NETWORK_LIST_V2", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "dwFlags", "pReserved", "ppAvailableNetworkList"]),
        #
        'WlanGetNetworkBssList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"uSSIDLength": SimTypeInt(signed=False, label="UInt32"), "ucSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="DOT11_SSID", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="DOT11_BSS_TYPE"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "wlanBssEntries": SimTypePointer(SimStruct({"dot11Ssid": SimStruct({"uSSIDLength": SimTypeInt(signed=False, label="UInt32"), "ucSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="DOT11_SSID", pack=False, align=None), "uPhyId": SimTypeInt(signed=False, label="UInt32"), "dot11Bssid": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "dot11BssType": SimTypeInt(signed=False, label="DOT11_BSS_TYPE"), "dot11BssPhyType": SimTypeInt(signed=False, label="DOT11_PHY_TYPE"), "lRssi": SimTypeInt(signed=True, label="Int32"), "uLinkQuality": SimTypeInt(signed=False, label="UInt32"), "bInRegDomain": SimTypeChar(label="Byte"), "usBeaconPeriod": SimTypeShort(signed=False, label="UInt16"), "ullTimestamp": SimTypeLongLong(signed=False, label="UInt64"), "ullHostTimestamp": SimTypeLongLong(signed=False, label="UInt64"), "usCapabilityInformation": SimTypeShort(signed=False, label="UInt16"), "ulChCenterFrequency": SimTypeInt(signed=False, label="UInt32"), "wlanRateSet": SimStruct({"uRateSetLength": SimTypeInt(signed=False, label="UInt32"), "usRateSet": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 126)}, name="WLAN_RATE_SET", pack=False, align=None), "ulIeOffset": SimTypeInt(signed=False, label="UInt32"), "ulIeSize": SimTypeInt(signed=False, label="UInt32")}, name="WLAN_BSS_ENTRY", pack=False, align=None), offset=0)}, name="WLAN_BSS_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "pDot11Ssid", "dot11BssType", "bSecurityEnabled", "pReserved", "ppWlanBssList"]),
        #
        'WlanConnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"wlanConnectionMode": SimTypeInt(signed=False, label="WLAN_CONNECTION_MODE"), "strProfile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pDot11Ssid": SimTypePointer(SimStruct({"uSSIDLength": SimTypeInt(signed=False, label="UInt32"), "ucSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="DOT11_SSID", pack=False, align=None), offset=0), "pDesiredBssidList": SimTypePointer(SimStruct({"Header": SimStruct({"Type": SimTypeChar(label="Byte"), "Revision": SimTypeChar(label="Byte"), "Size": SimTypeShort(signed=False, label="UInt16")}, name="NDIS_OBJECT_HEADER", pack=False, align=None), "uNumOfEntries": SimTypeInt(signed=False, label="UInt32"), "uTotalNumOfEntries": SimTypeInt(signed=False, label="UInt32"), "BSSIDs": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="DOT11_BSSID_LIST", pack=False, align=None), offset=0), "dot11BssType": SimTypeInt(signed=False, label="DOT11_BSS_TYPE"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="WLAN_CONNECTION_PARAMETERS", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "pConnectionParameters", "pReserved"]),
        #
        'WlanConnect2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"wlanConnectionMode": SimTypeInt(signed=False, label="WLAN_CONNECTION_MODE"), "strProfile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pDot11Ssid": SimTypePointer(SimStruct({"uSSIDLength": SimTypeInt(signed=False, label="UInt32"), "ucSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="DOT11_SSID", pack=False, align=None), offset=0), "pDot11Hessid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pDesiredBssidList": SimTypePointer(SimStruct({"Header": SimStruct({"Type": SimTypeChar(label="Byte"), "Revision": SimTypeChar(label="Byte"), "Size": SimTypeShort(signed=False, label="UInt16")}, name="NDIS_OBJECT_HEADER", pack=False, align=None), "uNumOfEntries": SimTypeInt(signed=False, label="UInt32"), "uTotalNumOfEntries": SimTypeInt(signed=False, label="UInt32"), "BSSIDs": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6)}, name="DOT11_BSSID_LIST", pack=False, align=None), offset=0), "dot11BssType": SimTypeInt(signed=False, label="DOT11_BSS_TYPE"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pDot11AccessNetworkOptions": SimTypePointer(SimStruct({"AccessNetworkType": SimTypeChar(label="Byte"), "Internet": SimTypeChar(label="Byte"), "ASRA": SimTypeChar(label="Byte"), "ESR": SimTypeChar(label="Byte"), "UESA": SimTypeChar(label="Byte")}, name="DOT11_ACCESSNETWORKOPTIONS", pack=False, align=None), offset=0)}, name="WLAN_CONNECTION_PARAMETERS_V2", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "pConnectionParameters", "pReserved"]),
        #
        'WlanDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "pReserved"]),
        #
        'WlanRegisterNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"NotificationSource": SimTypeInt(signed=False, label="UInt32"), "NotificationCode": SimTypeInt(signed=False, label="UInt32"), "InterfaceGuid": SimTypeBottom(label="Guid"), "dwDataSize": SimTypeInt(signed=False, label="UInt32"), "pData": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="L2_NOTIFICATION_DATA", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "dwNotifSource", "bIgnoreDuplicate", "funcCallback", "pCallbackContext", "pReserved", "pdwPrevNotifSource"]),
        #
        'WlanGetProfile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "strProfileName", "pReserved", "pstrProfileXml", "pdwFlags", "pdwGrantedAccess"]),
        #
        'WlanSetProfileEapUserData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"eapType": SimStruct({"type": SimTypeChar(label="Byte"), "dwVendorId": SimTypeInt(signed=False, label="UInt32"), "dwVendorType": SimTypeInt(signed=False, label="UInt32")}, name="EAP_TYPE", pack=False, align=None), "dwAuthorId": SimTypeInt(signed=False, label="UInt32")}, name="EAP_METHOD_TYPE", pack=False, align=None), SimTypeInt(signed=False, label="WLAN_SET_EAPHOST_FLAGS"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "strProfileName", "eapType", "dwFlags", "dwEapUserDataSize", "pbEapUserData", "pReserved"]),
        #
        'WlanSetProfileEapXmlUserData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="WLAN_SET_EAPHOST_FLAGS"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "strProfileName", "dwFlags", "strEapXmlUserData", "pReserved"]),
        #
        'WlanSetProfile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "dwFlags", "strProfileXml", "strAllUserProfileSecurity", "bOverwrite", "pReserved", "pdwReasonCode"]),
        #
        'WlanDeleteProfile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "strProfileName", "pReserved"]),
        #
        'WlanRenameProfile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "strOldProfileName", "strNewProfileName", "pReserved"]),
        #
        'WlanGetProfileList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "ProfileInfo": SimTypePointer(SimStruct({"strProfileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="WLAN_PROFILE_INFO", pack=False, align=None), offset=0)}, name="WLAN_PROFILE_INFO_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "pReserved", "ppProfileList"]),
        #
        'WlanSetProfileList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "dwItems", "strProfileNames", "pReserved"]),
        #
        'WlanSetProfilePosition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "strProfileName", "dwPosition", "pReserved"]),
        #
        'WlanSetProfileCustomUserData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "strProfileName", "dwDataSize", "pData", "pReserved"]),
        #
        'WlanGetProfileCustomUserData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "strProfileName", "pReserved", "pdwDataSize", "ppData"]),
        #
        'WlanSetFilterList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WLAN_FILTER_LIST_TYPE"), SimTypePointer(SimStruct({"dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "Network": SimTypePointer(SimStruct({"dot11Ssid": SimStruct({"uSSIDLength": SimTypeInt(signed=False, label="UInt32"), "ucSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="DOT11_SSID", pack=False, align=None), "dot11BssType": SimTypeInt(signed=False, label="DOT11_BSS_TYPE")}, name="DOT11_NETWORK", pack=False, align=None), offset=0)}, name="DOT11_NETWORK_LIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "wlanFilterListType", "pNetworkList", "pReserved"]),
        #
        'WlanGetFilterList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WLAN_FILTER_LIST_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "Network": SimTypePointer(SimStruct({"dot11Ssid": SimStruct({"uSSIDLength": SimTypeInt(signed=False, label="UInt32"), "ucSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="DOT11_SSID", pack=False, align=None), "dot11BssType": SimTypeInt(signed=False, label="DOT11_BSS_TYPE")}, name="DOT11_NETWORK", pack=False, align=None), offset=0)}, name="DOT11_NETWORK_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "wlanFilterListType", "pReserved", "ppNetworkList"]),
        #
        'WlanSetPsdIEDataList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "DataList": SimTypePointer(SimStruct({"dwDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwDataSize": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="WLAN_RAW_DATA_LIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "strFormat", "pPsdIEDataList", "pReserved"]),
        #
        'WlanSaveTemporaryProfile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "strProfileName", "strAllUserProfileSecurity", "dwFlags", "bOverWrite", "pReserved"]),
        #
        'WlanDeviceServiceCommand': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "pDeviceServiceGuid", "dwOpCode", "dwInBufferSize", "pInBuffer", "dwOutBufferSize", "pOutBuffer", "pdwBytesReturned"]),
        #
        'WlanGetSupportedDeviceServices': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "DeviceService": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="WLAN_DEVICE_SERVICE_GUID_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pInterfaceGuid", "ppDevSvcGuidList"]),
        #
        'WlanRegisterDeviceServiceNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "dwIndex": SimTypeInt(signed=False, label="UInt32"), "DeviceService": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="WLAN_DEVICE_SERVICE_GUID_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pDevSvcGuidList"]),
        #
        'WlanExtractPsdIEDataList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwTotalSize": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfItems": SimTypeInt(signed=False, label="UInt32"), "DataList": SimTypePointer(SimStruct({"dwDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwDataSize": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), offset=0)}, name="WLAN_RAW_DATA_LIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "dwIeDataSize", "pRawIeData", "strFormat", "pReserved", "ppPsdIEDataList"]),
        #
        'WlanReasonCodeToString': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwReasonCode", "dwBufferSize", "pStringBuffer", "pReserved"]),
        #
        'WlanAllocateMemory': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["dwMemorySize"]),
        #
        'WlanFreeMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pMemory"]),
        #
        'WlanSetSecuritySettings': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WLAN_SECURABLE_OBJECT"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "SecurableObject", "strModifiedSDDL"]),
        #
        'WlanGetSecuritySettings': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WLAN_SECURABLE_OBJECT"), SimTypePointer(SimTypeInt(signed=False, label="WLAN_OPCODE_VALUE_TYPE"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "SecurableObject", "pValueType", "pstrCurrentSDDL", "pdwGrantedAccess"]),
        #
        'WlanHostedNetworkStartUsing': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_REASON"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pFailReason", "pvReserved"]),
        #
        'WlanHostedNetworkStopUsing': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_REASON"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pFailReason", "pvReserved"]),
        #
        'WlanHostedNetworkForceStart': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_REASON"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pFailReason", "pvReserved"]),
        #
        'WlanHostedNetworkForceStop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_REASON"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pFailReason", "pvReserved"]),
        #
        'WlanHostedNetworkQueryProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_OPCODE"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_OPCODE_VALUE_TYPE"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "OpCode", "pdwDataSize", "ppvData", "pWlanOpcodeValueType", "pvReserved"]),
        #
        'WlanHostedNetworkSetProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_OPCODE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_REASON"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "OpCode", "dwDataSize", "pvData", "pFailReason", "pvReserved"]),
        #
        'WlanHostedNetworkInitSettings': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_REASON"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pFailReason", "pvReserved"]),
        #
        'WlanHostedNetworkRefreshSecuritySettings': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_REASON"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pFailReason", "pvReserved"]),
        #
        'WlanHostedNetworkQueryStatus': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"HostedNetworkState": SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_STATE"), "IPDeviceID": SimTypeBottom(label="Guid"), "wlanHostedNetworkBSSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "dot11PhyType": SimTypeInt(signed=False, label="DOT11_PHY_TYPE"), "ulChannelFrequency": SimTypeInt(signed=False, label="UInt32"), "dwNumberOfPeers": SimTypeInt(signed=False, label="UInt32"), "PeerList": SimTypePointer(SimStruct({"PeerMacAddress": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "PeerAuthState": SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_PEER_AUTH_STATE")}, name="WLAN_HOSTED_NETWORK_PEER_STATE", pack=False, align=None), offset=0)}, name="WLAN_HOSTED_NETWORK_STATUS", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "ppWlanHostedNetworkStatus", "pvReserved"]),
        #
        'WlanHostedNetworkSetSecondaryKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_REASON"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "dwKeyLength", "pucKeyData", "bIsPassPhrase", "bPersistent", "pFailReason", "pvReserved"]),
        #
        'WlanHostedNetworkQuerySecondaryKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="WLAN_HOSTED_NETWORK_REASON"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pdwKeyLength", "ppucKeyData", "pbIsPassPhrase", "pbPersistent", "pFailReason", "pvReserved"]),
        #
        'WlanRegisterVirtualStationNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "bRegister", "pReserved"]),
        #
        'WFDOpenHandle': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwClientVersion", "pdwNegotiatedVersion", "phClientHandle"]),
        #
        'WFDCloseHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle"]),
        #
        'WFDStartOpenSession': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="Guid"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hSessionHandle", "pvContext", "guidSessionInterface", "dwError", "dwReasonCode"]), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pDeviceAddress", "pvContext", "pfnCallback", "phSessionHandle"]),
        #
        'WFDCancelOpenSession': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hSessionHandle"]),
        #
        'WFDOpenLegacySession': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClientHandle", "pLegacyMacAddress", "phSessionHandle", "pGuidSessionInterface"]),
        #
        'WFDCloseSession': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hSessionHandle"]),
        #
        'WFDUpdateDeviceVisibility': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pDeviceAddress"]),
    }

lib.set_prototypes(prototypes)
