/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.mpp.AbstractCalendarFactory;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.VarMeta;
import net.sf.mpxj.mpp.VarMeta9;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

class MPP9CalendarFactory
extends AbstractCalendarFactory {
    private static final Integer CALENDAR_NAME = 1;
    private static final Integer CALENDAR_DATA = 3;

    public MPP9CalendarFactory(ProjectFile projectFile) {
        super(projectFile);
    }

    @Override
    protected int getCalendarIDOffset() {
        return 0;
    }

    @Override
    protected int getBaseIDOffset() {
        return 4;
    }

    @Override
    protected int getResourceIDOffset() {
        return 8;
    }

    @Override
    protected int getCalendarHoursOffset() {
        return 4;
    }

    @Override
    protected Integer getCalendarNameVarDataType() {
        return CALENDAR_NAME;
    }

    @Override
    protected Integer getCalendarDataVarDataType() {
        return CALENDAR_DATA;
    }

    @Override
    protected VarMeta getCalendarVarMeta(DirectoryEntry directoryEntry) throws IOException {
        return new VarMeta9(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
    }

    @Override
    protected void processCalendarExceptions(byte[] byArray, ProjectCalendar projectCalendar) {
        int n = MPPUtility.getShort(byArray, 0);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                int n2 = 424 + i * 64;
                Date date = MPPUtility.getDate(byArray, n2);
                Date date2 = MPPUtility.getDate(byArray, n2 + 2);
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
                int n3 = MPPUtility.getShort(byArray, n2 + 6);
                if (n3 == 0) continue;
                for (int j = 0; j < n3; ++j) {
                    Date date3 = MPPUtility.getTime(byArray, n2 + 12 + j * 2);
                    long l = MPPUtility.getDuration(byArray, n2 + 24 + j * 4);
                    projectCalendarException.addRange(new DateRange(date3, new Date(date3.getTime() + l)));
                }
            }
        }
    }
}

