/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.protobufs.DateRangeQuery;
import org.opensearch.protobufs.DateRangeQueryAllOfFrom;
import org.opensearch.protobufs.DateRangeQueryAllOfTo;
import org.opensearch.protobufs.NumberRangeQuery;
import org.opensearch.protobufs.NumberRangeQueryAllOfFrom;
import org.opensearch.protobufs.NumberRangeQueryAllOfTo;
import org.opensearch.protobufs.RangeQuery;
import org.opensearch.protobufs.RangeRelation;

class RangeQueryBuilderProtoUtils {
    private RangeQueryBuilderProtoUtils() {
    }

    static RangeQueryBuilder fromProto(RangeQuery rangeQueryProto) {
        if (rangeQueryProto == null) {
            throw new IllegalArgumentException("RangeQuery cannot be null");
        }
        if (rangeQueryProto.hasDateRangeQuery()) {
            return RangeQueryBuilderProtoUtils.fromDateRangeQuery(rangeQueryProto.getDateRangeQuery());
        }
        if (rangeQueryProto.hasNumberRangeQuery()) {
            return RangeQueryBuilderProtoUtils.fromNumberRangeQuery(rangeQueryProto.getNumberRangeQuery());
        }
        throw new IllegalArgumentException("RangeQuery must contain either DateRangeQuery or NumberRangeQuery");
    }

    private static RangeQueryBuilder fromDateRangeQuery(DateRangeQuery dateRangeQuery) {
        String fieldName = dateRangeQuery.getField();
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty for range query");
        }
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(fieldName);
        String queryName = dateRangeQuery.hasXName() ? dateRangeQuery.getXName() : null;
        float boost = dateRangeQuery.hasBoost() ? dateRangeQuery.getBoost() : 1.0f;
        String format = dateRangeQuery.hasFormat() ? dateRangeQuery.getFormat() : null;
        String timeZone = dateRangeQuery.getTimeZone().isEmpty() ? null : dateRangeQuery.getTimeZone();
        String relation = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        String from = null;
        String to = null;
        if (dateRangeQuery.hasFrom()) {
            DateRangeQueryAllOfFrom fromObj = dateRangeQuery.getFrom();
            if (fromObj.hasString()) {
                from = fromObj.getString();
            } else if (fromObj.hasNullValue()) {
                from = null;
            }
        }
        if (dateRangeQuery.hasTo()) {
            DateRangeQueryAllOfTo toObj = dateRangeQuery.getTo();
            if (toObj.hasString()) {
                to = toObj.getString();
            } else if (toObj.hasNullValue()) {
                to = null;
            }
        }
        if (dateRangeQuery.hasIncludeLower()) {
            includeLower = dateRangeQuery.getIncludeLower();
        }
        if (dateRangeQuery.hasIncludeUpper()) {
            includeUpper = dateRangeQuery.getIncludeUpper();
        }
        if (dateRangeQuery.hasGt()) {
            from = dateRangeQuery.getGt();
            includeLower = false;
        }
        if (dateRangeQuery.hasGte()) {
            from = dateRangeQuery.getGte();
            includeLower = true;
        }
        if (dateRangeQuery.hasLt()) {
            to = dateRangeQuery.getLt();
            includeUpper = false;
        }
        if (dateRangeQuery.hasLte()) {
            to = dateRangeQuery.getLte();
            includeUpper = true;
        }
        if (from != null) {
            rangeQuery.from((Object)from);
        }
        if (to != null) {
            rangeQuery.to((Object)to);
        }
        rangeQuery.includeLower(includeLower);
        rangeQuery.includeUpper(includeUpper);
        if (dateRangeQuery.hasRelation()) {
            relation = RangeQueryBuilderProtoUtils.parseRangeRelation(dateRangeQuery.getRelation());
        }
        if (format != null) {
            rangeQuery.format(format);
        }
        if (timeZone != null) {
            rangeQuery.timeZone(timeZone);
        }
        if (relation != null) {
            rangeQuery.relation(relation);
        }
        rangeQuery.boost(boost);
        if (queryName != null) {
            rangeQuery.queryName(queryName);
        }
        return rangeQuery;
    }

    private static RangeQueryBuilder fromNumberRangeQuery(NumberRangeQuery numberRangeQuery) {
        String fieldName = numberRangeQuery.getField();
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty for range query");
        }
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(fieldName);
        String queryName = numberRangeQuery.hasXName() ? numberRangeQuery.getXName() : null;
        float boost = numberRangeQuery.hasBoost() ? numberRangeQuery.getBoost() : 1.0f;
        String relation = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        Object from = null;
        Object to = null;
        if (numberRangeQuery.hasFrom()) {
            NumberRangeQueryAllOfFrom fromObj = numberRangeQuery.getFrom();
            if (fromObj.hasDouble()) {
                from = fromObj.getDouble();
            } else if (fromObj.hasString()) {
                from = fromObj.getString();
            } else if (fromObj.hasNullValue()) {
                from = null;
            }
        }
        if (numberRangeQuery.hasTo()) {
            NumberRangeQueryAllOfTo toObj = numberRangeQuery.getTo();
            if (toObj.hasDouble()) {
                to = toObj.getDouble();
            } else if (toObj.hasString()) {
                to = toObj.getString();
            } else if (toObj.hasNullValue()) {
                to = null;
            }
        }
        if (numberRangeQuery.hasIncludeLower()) {
            includeLower = numberRangeQuery.getIncludeLower();
        }
        if (numberRangeQuery.hasIncludeUpper()) {
            includeUpper = numberRangeQuery.getIncludeUpper();
        }
        if (numberRangeQuery.hasGt()) {
            from = numberRangeQuery.getGt();
            includeLower = false;
        }
        if (numberRangeQuery.hasGte()) {
            from = numberRangeQuery.getGte();
            includeLower = true;
        }
        if (numberRangeQuery.hasLt()) {
            to = numberRangeQuery.getLt();
            includeUpper = false;
        }
        if (numberRangeQuery.hasLte()) {
            to = numberRangeQuery.getLte();
            includeUpper = true;
        }
        if (from != null) {
            rangeQuery.from(from);
        }
        if (to != null) {
            rangeQuery.to(to);
        }
        rangeQuery.includeLower(includeLower);
        rangeQuery.includeUpper(includeUpper);
        if (numberRangeQuery.hasRelation()) {
            relation = RangeQueryBuilderProtoUtils.parseRangeRelation(numberRangeQuery.getRelation());
        }
        if (relation != null) {
            rangeQuery.relation(relation);
        }
        rangeQuery.boost(boost);
        if (queryName != null) {
            rangeQuery.queryName(queryName);
        }
        return rangeQuery;
    }

    private static String parseRangeRelation(RangeRelation rangeRelation) {
        if (rangeRelation == null) {
            return null;
        }
        switch (rangeRelation) {
            case RANGE_RELATION_CONTAINS: {
                return "CONTAINS";
            }
            case RANGE_RELATION_INTERSECTS: {
                return "INTERSECTS";
            }
            case RANGE_RELATION_WITHIN: {
                return "WITHIN";
            }
        }
        return null;
    }
}

