/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.util;

import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;

public final class DownloadUtils {
    private DownloadUtils() {
    }

    public static void download(String url, String output) throws IOException {
        DownloadUtils.download(url, output, null);
    }

    public static void download(String url, String output, Progress progress) throws IOException {
        DownloadUtils.download(new URL(url.trim()), Paths.get(output.trim(), new String[0]), progress);
    }

    public static void download(URL url, Path output, Progress progress) throws IOException {
        long contentLength;
        if (Files.exists(output, new LinkOption[0])) {
            return;
        }
        Path dir = output.toAbsolutePath().getParent();
        if (dir != null) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        URLConnection conn = url.openConnection();
        if (progress != null && (contentLength = conn.getContentLengthLong()) > 0L) {
            progress.reset("Downloading", contentLength, output.toFile().getName());
        }
        try (InputStream is = conn.getInputStream();){
            ProgressInputStream pis = new ProgressInputStream(is, progress);
            String fileName = url.getFile();
            if (fileName.endsWith(".gz")) {
                Files.copy(new GZIPInputStream(pis), output, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(pis, output, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static final class ProgressInputStream
    extends InputStream {
        private InputStream is;
        private Progress progress;

        public ProgressInputStream(InputStream is, Progress progress) {
            this.is = is;
            this.progress = progress;
        }

        @Override
        public int read() throws IOException {
            int ret = this.is.read();
            if (this.progress != null) {
                if (ret >= 0) {
                    this.progress.increment(1L);
                } else {
                    this.progress.end();
                }
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int size = this.is.read(b, off, len);
            if (this.progress != null) {
                this.progress.increment(size);
            }
            return size;
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }
    }
}

