/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.explore;

import com.o19s.es.explore.PostingsExplorerQuery;
import com.o19s.es.explore.StatisticsHelper;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class ExplorerScorer
extends Scorer {
    private final Scorer subScorer;
    private final String type;

    protected ExplorerScorer(Weight weight, String type, Scorer subScorer) {
        this.type = type;
        this.subScorer = subScorer;
    }

    public float score() throws IOException {
        StatisticsHelper tf_stats = new StatisticsHelper();
        if (this.subScorer.getChildren().size() > 0) {
            for (Scorable.ChildScorable child : this.subScorer.getChildren()) {
                assert (child.child() instanceof PostingsExplorerQuery.PostingsExplorerScorer);
                if (((PostingsExplorerQuery.PostingsExplorerScorer)child.child()).docID() != this.docID()) continue;
                ((PostingsExplorerQuery.PostingsExplorerScorer)child.child()).setType(this.type);
                tf_stats.add(child.child().score());
            }
        } else {
            assert (this.subScorer instanceof PostingsExplorerQuery.PostingsExplorerScorer);
            assert (this.subScorer.docID() == this.docID());
            ((PostingsExplorerQuery.PostingsExplorerScorer)this.subScorer).setType(this.type);
            tf_stats.add(this.subScorer.score());
        }
        return switch (this.type) {
            case "sum_raw_tf" -> tf_stats.getSum();
            case "mean_raw_tf" -> tf_stats.getMean();
            case "max_raw_tf", "max_raw_tp" -> tf_stats.getMax();
            case "min_raw_tf", "min_raw_tp" -> tf_stats.getMin();
            case "stddev_raw_tf" -> tf_stats.getStdDev();
            case "avg_raw_tp" -> tf_stats.getMean();
            default -> throw new RuntimeException("Invalid stat type specified.");
        };
    }

    public int docID() {
        return this.subScorer.docID();
    }

    public DocIdSetIterator iterator() {
        return this.subScorer.iterator();
    }

    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }
}

