/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.geospatial;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.geospatial.PutIp2geoDatasourceResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PutIp2geoDatasourceRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PutIp2geoDatasourceRequest> {
    @Nullable
    private final String endpoint;
    @Nonnull
    private final String name;
    @Nullable
    private final Integer updateIntervalInDays;
    public static final JsonpDeserializer<PutIp2geoDatasourceRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutIp2geoDatasourceRequest::setupPutIp2geoDatasourceRequestDeserializer);
    public static final Endpoint<PutIp2geoDatasourceRequest, PutIp2geoDatasourceResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutIp2geoDatasourceRequest, PutIp2geoDatasourceResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/geospatial/ip2geo/datasource/");
        SimpleEndpoint.pathEncode(request.name, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutIp2geoDatasourceResponse._DESERIALIZER);

    private PutIp2geoDatasourceRequest(Builder builder) {
        super(builder);
        this.endpoint = builder.endpoint;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.updateIntervalInDays = builder.updateIntervalInDays;
    }

    public static PutIp2geoDatasourceRequest of(Function<Builder, ObjectBuilder<PutIp2geoDatasourceRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String endpoint() {
        return this.endpoint;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Integer updateIntervalInDays() {
        return this.updateIntervalInDays;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.endpoint != null) {
            generator.writeKey("endpoint");
            generator.write(this.endpoint);
        }
        if (this.updateIntervalInDays != null) {
            generator.writeKey("update_interval_in_days");
            generator.write(this.updateIntervalInDays.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPutIp2geoDatasourceRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::endpoint, JsonpDeserializer.stringDeserializer(), "endpoint");
        op.add(Builder::updateIntervalInDays, JsonpDeserializer.integerDeserializer(), "update_interval_in_days");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.endpoint);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.updateIntervalInDays);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutIp2geoDatasourceRequest other = (PutIp2geoDatasourceRequest)o;
        return Objects.equals(this.endpoint, other.endpoint) && this.name.equals(other.name) && Objects.equals(this.updateIntervalInDays, other.updateIntervalInDays);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PutIp2geoDatasourceRequest> {
        @Nullable
        private String endpoint;
        private String name;
        @Nullable
        private Integer updateIntervalInDays;

        public Builder() {
        }

        private Builder(PutIp2geoDatasourceRequest o) {
            super(o);
            this.endpoint = o.endpoint;
            this.name = o.name;
            this.updateIntervalInDays = o.updateIntervalInDays;
        }

        private Builder(Builder o) {
            super(o);
            this.endpoint = o.endpoint;
            this.name = o.name;
            this.updateIntervalInDays = o.updateIntervalInDays;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder endpoint(@Nullable String value) {
            this.endpoint = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder updateIntervalInDays(@Nullable Integer value) {
            this.updateIntervalInDays = value;
            return this;
        }

        @Override
        @Nonnull
        public PutIp2geoDatasourceRequest build() {
            this._checkSingleUse();
            return new PutIp2geoDatasourceRequest(this);
        }
    }
}

