/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.lsp.internal;

import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class MappingUriExtensions
extends UriExtensions {
    private final Logger logger = LoggerFactory.getLogger(MappingUriExtensions.class);
    private final String rawConfigFolder;
    private final String serverLocation;
    private @Nullable String clientLocation;

    public MappingUriExtensions(String configFolder) {
        this.rawConfigFolder = configFolder;
        this.serverLocation = this.calcServerLocation(configFolder);
        this.logger.debug("The language server is using '{}' as its workspace", (Object)this.serverLocation);
    }

    protected String calcServerLocation(String configFolder) {
        Path configPath = Paths.get(configFolder, new String[0]);
        Path absoluteConfigPath = configPath.toAbsolutePath();
        java.net.URI configPathURI = absoluteConfigPath.toUri();
        return this.removeTrailingSlash(configPathURI.toString());
    }

    public URI toUri(@NonNullByDefault(value={}) String pathWithScheme) {
        String decodedPathWithScheme = URLDecoder.decode(pathWithScheme, StandardCharsets.UTF_8);
        String localClientLocation = this.clientLocation;
        if (localClientLocation != null && decodedPathWithScheme.startsWith(localClientLocation)) {
            return this.map(decodedPathWithScheme);
        }
        this.clientLocation = this.guessClientPath(decodedPathWithScheme);
        localClientLocation = this.clientLocation;
        if (localClientLocation != null) {
            this.logger.debug("Identified client workspace as '{}'", (Object)localClientLocation);
            return this.map(decodedPathWithScheme);
        }
        this.clientLocation = pathWithScheme;
        this.logger.debug("Path mapping could not be done for '{}', leaving it untouched", (Object)pathWithScheme);
        java.net.URI javaNetUri = java.net.URI.create(pathWithScheme);
        return URI.createURI((String)this.toPathAsInXtext212(javaNetUri));
    }

    public String toUriString(@NonNullByDefault(value={}) URI uri) {
        if (this.clientLocation == null) {
            return uri.toString();
        }
        return this.mapToClientPath(uri.toString());
    }

    public String toUriString(@NonNullByDefault(value={}) java.net.URI uri) {
        return this.toUriString(URI.createURI((String)uri.toString()));
    }

    private String mapToClientPath(String pathWithScheme) {
        String clientLocation = this.clientLocation;
        String uriString = clientLocation == null ? this.serverLocation : pathWithScheme.replace(this.serverLocation, clientLocation);
        String clientPath = this.toPathAsInXtext212(java.net.URI.create(uriString));
        this.logger.trace("Mapping server path {} to client path {}", (Object)pathWithScheme, (Object)clientPath);
        return clientPath;
    }

    protected final String removeTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected @Nullable String guessClientPath(String pathWithScheme) {
        if (this.isPointingToConfigFolder(pathWithScheme)) {
            return this.removeTrailingSlash(pathWithScheme);
        }
        if (this.isFolder(pathWithScheme)) {
            return this.removeTrailingSlash(pathWithScheme);
        }
        String currentPath = pathWithScheme;
        int nextIndex = this.getLastPathSegmentIndex(currentPath);
        while (nextIndex > -1) {
            java.net.URI uri = this.toURI(pathWithScheme, currentPath = currentPath.substring(0, nextIndex));
            File realFile = new File(uri);
            if (realFile.exists()) {
                return currentPath;
            }
            nextIndex = this.getLastPathSegmentIndex(currentPath);
        }
        return null;
    }

    private boolean isFolder(String currentPath) {
        return !currentPath.substring(this.getLastPathSegmentIndex(currentPath)).contains(".");
    }

    private boolean isPointingToConfigFolder(String currentPath) {
        return currentPath.endsWith("/" + this.rawConfigFolder);
    }

    private int getLastPathSegmentIndex(String currentPath) {
        return this.removeTrailingSlash(currentPath).lastIndexOf("/");
    }

    private URI map(String pathWithScheme) {
        java.net.URI javaNetUri = this.toURI(pathWithScheme, this.clientLocation);
        this.logger.trace("Going to map path {}", (Object)javaNetUri);
        URI ret = URI.createURI((String)this.toPathAsInXtext212(javaNetUri));
        this.logger.trace("Mapped path {} to {}", (Object)pathWithScheme, (Object)ret);
        return ret;
    }

    private java.net.URI toURI(String pathWithScheme, @Nullable String currentPath) {
        String path = currentPath == null ? pathWithScheme : pathWithScheme.replace(currentPath, this.serverLocation);
        return java.net.URI.create(path);
    }

    private String toPathAsInXtext212(java.net.URI uri) {
        return Paths.get(uri).toUri().toString();
    }
}

