/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import javax.measure.Quantity;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.UnitProvider;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemStateConverter;
import org.openhab.core.library.items.NumberItem;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.types.State;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.UnDefType;
import org.openhab.core.types.util.UnitUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@NonNullByDefault
public class ItemStateConverterImpl
implements ItemStateConverter {
    private final Logger logger = LoggerFactory.getLogger(ItemStateConverterImpl.class);
    private final UnitProvider unitProvider;

    @Activate
    public ItemStateConverterImpl(@Reference UnitProvider unitProvider) {
        this.unitProvider = unitProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public State convertToAcceptedState(@Nullable State state, @Nullable Item item) {
        Item item2;
        if (state == null) {
            this.logger.error("A conversion of null was requested:", (Throwable)new IllegalArgumentException("State must not be null."));
            return UnDefType.NULL;
        }
        if (item != null && !this.isAccepted(item, state)) {
            for (Class<? extends State> acceptedType : item.getAcceptedDataTypes()) {
                Object convertedState = state.as(acceptedType);
                if (convertedState == null) continue;
                this.logger.debug("Converting {} '{}' to {} '{}' for item '{}'", new Object[]{state.getClass().getSimpleName(), state, convertedState.getClass().getSimpleName(), convertedState, item.getName()});
                return convertedState;
            }
        }
        if ((item2 = item) instanceof NumberItem) {
            Class<? extends State> acceptedType;
            acceptedType = (NumberItem)item2;
            NumberItem cfr_ignored_0 = (NumberItem)item2;
            State state2 = state;
            if (state2 instanceof QuantityType) {
                void numberItem;
                QuantityType quantityType = (QuantityType)state2;
                QuantityType cfr_ignored_1 = (QuantityType)state2;
                if (numberItem.getDimension() != null) {
                    Unit<? extends Quantity<?>> conversionUnit;
                    void quantityState;
                    Unit<?> itemUnit = this.parseItemUnit((NumberItem)numberItem);
                    if (itemUnit != null) {
                        if (!itemUnit.equals(quantityState.getUnit())) {
                            return this.convertOrUndef((QuantityType<?>)quantityState, itemUnit);
                        }
                        return quantityState;
                    }
                    Class<? extends Quantity<?>> dimension = numberItem.getDimension();
                    Unit<? extends Quantity<?>> unit = conversionUnit = dimension == null ? null : this.unitProvider.getUnit(dimension);
                    if (conversionUnit != null && UnitUtils.isDifferentMeasurementSystem(conversionUnit, quantityState.getUnit())) {
                        return this.convertOrUndef((QuantityType<?>)quantityState, conversionUnit);
                    }
                } else {
                    DecimalType convertedState = state.as(DecimalType.class);
                    if (convertedState != null) {
                        return convertedState;
                    }
                }
            }
        }
        return state;
    }

    private State convertOrUndef(QuantityType<?> quantityState, Unit<?> targetUnit) {
        QuantityType<?> converted = quantityState.toInvertibleUnit(targetUnit);
        if (converted != null) {
            return converted;
        }
        return UnDefType.UNDEF;
    }

    private @Nullable Unit<?> parseItemUnit(NumberItem numberItem) {
        StateDescription stateDescription = numberItem.getStateDescription();
        if (stateDescription == null) {
            return null;
        }
        String pattern = stateDescription.getPattern();
        if (pattern == null) {
            return null;
        }
        return UnitUtils.parseUnit(pattern);
    }

    private boolean isAccepted(Item item, State state) {
        return item.getAcceptedDataTypes().contains(state.getClass());
    }
}

