/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.refactoring;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationChange;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ResourceRelocationContext {
    private final ChangeType changeType;
    private final List<ResourceRelocationChange> changes;
    private final RefactoringIssueAcceptor issueAcceptor;
    private final IChangeSerializer changeSerializer;
    private final ResourceSet resourceSet;

    public void addModification(ResourceRelocationChange change, IChangeSerializer.IModification<Resource> modification) {
        this.changeSerializer.addModification(this.loadAndWatchResource(change), modification);
    }

    protected Resource loadAndWatchResource(ResourceRelocationChange change) {
        if (this.changeType != null) {
            switch (this.changeType) {
                case MOVE: 
                case RENAME: {
                    Resource original = this.resourceSet.getResource(change.getFromURI(), true);
                    this.changeSerializer.addModification(original, (T it) -> original.setURI(change.getToURI()));
                    return original;
                }
                case COPY: {
                    Resource copy = this.resourceSet.createResource(change.getFromURI());
                    try {
                        copy.load(this.resourceSet.getURIConverter().createInputStream(change.getFromURI()), null);
                    }
                    catch (IOException e) {
                        Exceptions.sneakyThrow((Throwable)e);
                    }
                    copy.setURI(change.getToURI());
                    return copy;
                }
            }
            return null;
        }
        return null;
    }

    public ResourceRelocationContext(ChangeType changeType, List<ResourceRelocationChange> changes, RefactoringIssueAcceptor issueAcceptor, IChangeSerializer changeSerializer, ResourceSet resourceSet) {
        this.changeType = changeType;
        this.changes = changes;
        this.issueAcceptor = issueAcceptor;
        this.changeSerializer = changeSerializer;
        this.resourceSet = resourceSet;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public List<ResourceRelocationChange> getChanges() {
        return this.changes;
    }

    public RefactoringIssueAcceptor getIssueAcceptor() {
        return this.issueAcceptor;
    }

    public IChangeSerializer getChangeSerializer() {
        return this.changeSerializer;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public static enum ChangeType {
        COPY,
        MOVE,
        RENAME;

    }
}

