/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.xtext.util.DisposableRegistry;
import org.eclipse.xtext.util.IDisposable;

@Singleton
public class ExecutorServiceProvider
implements Provider<ExecutorService>,
IDisposable {
    private final Map<String, ExecutorService> instanceCache = Collections.synchronizedMap(new HashMap());

    @Inject
    public void registerTo(DisposableRegistry disposableRegistry) {
        disposableRegistry.register((IDisposable)this);
    }

    public ExecutorService get() {
        return this.get(null);
    }

    public ExecutorService get(String key) {
        return this.instanceCache.computeIfAbsent(key, this::createInstance);
    }

    protected ExecutorService createInstance(String key) {
        return Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<String, ExecutorService> map = this.instanceCache;
        synchronized (map) {
            for (ExecutorService executorService : this.instanceCache.values()) {
                executorService.shutdown();
            }
            this.instanceCache.clear();
        }
    }
}

