/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher.hashing;

import io.methvin.watcher.hashing.ByteArrayFileHash;
import io.methvin.watcher.hashing.FileHash;
import io.methvin.watcher.hashing.Murmur3F;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;

@FunctionalInterface
public interface FileHasher {
    public static final FileHasher DEFAULT_FILE_HASHER = path -> {
        Murmur3F murmur3F = new Murmur3F();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int n;
            while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                murmur3F.update(n);
            }
        }
        return new ByteArrayFileHash(murmur3F.getValueBytesBigEndian());
    };
    public static final FileHasher LAST_MODIFIED_TIME = path -> {
        Instant instant = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(instant.getEpochSecond());
        byteBuffer.putLong(instant.getNano());
        return new ByteArrayFileHash(byteBuffer.array());
    };

    public FileHash hash(Path var1) throws IOException;
}

