/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.WriteSingleRegisterResponse;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.Register;

public final class WriteSingleRegisterRequest
extends ModbusRequest {
    private int m_Reference;
    private Register m_Register;

    public WriteSingleRegisterRequest() {
        this.setFunctionCode(6);
        this.setDataLength(4);
    }

    public WriteSingleRegisterRequest(int ref, Register reg) {
        this.setFunctionCode(6);
        this.m_Reference = ref;
        this.m_Register = reg;
        this.setDataLength(4);
    }

    @Override
    public ModbusResponse createResponse() {
        WriteSingleRegisterResponse response = null;
        Register reg = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            reg = procimg.getRegister(this.m_Reference);
            reg.setValue(this.m_Register.toBytes());
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = new WriteSingleRegisterResponse(this.getReference(), reg.getValue());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setRegister(Register reg) {
        this.m_Register = reg;
    }

    public Register getRegister() {
        return this.m_Register;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.write(this.m_Register.toBytes(), 0, 2);
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_Register = ModbusCoupler.getReference().getProcessImageFactory().createRegister(din.readByte(), din.readByte());
    }
}

