/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVmClusterPatchRequest
extends BmcRequest<Void> {
    private String vmClusterId;
    private String patchId;

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public Builder toBuilder() {
        return new Builder().vmClusterId(this.vmClusterId).patchId(this.patchId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(",patchId=").append(String.valueOf(this.patchId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVmClusterPatchRequest)) {
            return false;
        }
        GetVmClusterPatchRequest other = (GetVmClusterPatchRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals(this.patchId, other.patchId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.patchId == null ? 43 : this.patchId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVmClusterPatchRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vmClusterId = null;
        private String patchId = null;

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVmClusterPatchRequest o) {
            this.vmClusterId(o.getVmClusterId());
            this.patchId(o.getPatchId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVmClusterPatchRequest build() {
            GetVmClusterPatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVmClusterPatchRequest buildWithoutInvocationCallback() {
            GetVmClusterPatchRequest request = new GetVmClusterPatchRequest();
            request.vmClusterId = this.vmClusterId;
            request.patchId = this.patchId;
            return request;
        }
    }
}

