/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.analysis.Configuration;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ConfigurationsManager {
    private static final String RULE_PREFIX = "rule_config_";
    private static final String KEY_CONFIGURATIONS_VERSION = "configurations.version";
    private static final int CURRENT_CONFIGURATIONS_VERSION = 1;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static ConfigurationsManager instance;
    private ArrayList<Configuration> configs = new ArrayList();

    private ConfigurationsManager() {
        this.init();
    }

    public static synchronized ConfigurationsManager getDefault() {
        if (instance == null) {
            instance = new ConfigurationsManager();
        }
        return instance;
    }

    public Configuration getDefaultConfiguration() {
        return this.getConfiguration(0);
    }

    public List<Configuration> getConfigurations() {
        return Collections.unmodifiableList(this.configs);
    }

    public Configuration getConfiguration(int i) {
        return this.configs.get(i);
    }

    public int size() {
        return this.configs.size();
    }

    private void init() {
        Preferences prefs = ConfigurationsManager.getConfigurationsRoot();
        try {
            for (String kid : prefs.childrenNames()) {
                if (!kid.startsWith(RULE_PREFIX)) continue;
                Preferences p = prefs.node(kid);
                String displayName = p.get("display.name", "unknown");
                this.create(kid.substring(RULE_PREFIX.length()), displayName);
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.configs.isEmpty()) {
            this.create("default", NbBundle.getMessage(ConfigurationsManager.class, (String)"DN_Default"));
        }
        prefs.putInt(KEY_CONFIGURATIONS_VERSION, 1);
    }

    public Configuration create(String id, String displayName) {
        assert (!id.startsWith(RULE_PREFIX));
        Configuration config = new Configuration(RULE_PREFIX + id, displayName, null);
        this.configs.add(config);
        this.changeSupport.fireChange();
        return config;
    }

    public Configuration duplicate(Configuration orig, String id, String displayName) {
        assert (!id.startsWith(RULE_PREFIX));
        Configuration config = new Configuration(RULE_PREFIX + id, displayName, null);
        this.configs.add(config);
        Preferences oldOne = orig.getPreferences();
        Preferences newOne = config.getPreferences();
        try {
            LinkedList<AbstractMap.SimpleEntry<Preferences, Preferences>> todo = new LinkedList<AbstractMap.SimpleEntry<Preferences, Preferences>>();
            boolean first = true;
            todo.add(new AbstractMap.SimpleEntry<Preferences, Preferences>(oldOne, newOne));
            while (!todo.isEmpty()) {
                AbstractMap.SimpleEntry e = (AbstractMap.SimpleEntry)todo.remove(0);
                for (String name : ((Preferences)e.getKey()).childrenNames()) {
                    todo.add(new AbstractMap.SimpleEntry<Preferences, Preferences>(((Preferences)e.getKey()).node(name), ((Preferences)e.getValue()).node(name)));
                }
                if (first) {
                    first = false;
                    continue;
                }
                for (String key : ((Preferences)e.getKey()).keys()) {
                    String old = ((Preferences)e.getKey()).get(key, null);
                    ((Preferences)e.getValue()).put(key, old);
                }
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.changeSupport.fireChange();
        return config;
    }

    public void remove(Configuration config) {
        this.configs.remove(config);
        Preferences prefs = NbPreferences.forModule(this.getClass()).node(config.id());
        try {
            prefs.removeNode();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public static Preferences getConfigurationsRoot() {
        return NbPreferences.forModule(ConfigurationsManager.class).node("configurations");
    }

    public Configuration getTemporaryConfiguration() {
        return new Configuration("internal-temporary", "internal-temporary", NbPreferences.forModule(ConfigurationsManager.class).node("internal-temporary"));
    }
}

