/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.packets.DbgpCommand;

public abstract class PropertyCommand
extends DbgpCommand {
    private static final String NAME_ARG = "-n ";
    private static final String MAX_SIZE_ARG = "-m ";
    private static final String CONTEXT_ARG = "-c ";
    private static final String DEPTH_ARG = "-d ";
    private static final String PAGE_ARG = "-p ";
    private int myPage = -1;
    private int myContext = -1;
    private int myDepth = -1;
    private String myName;
    private int mySize = -1;

    PropertyCommand(String command, String transactionId) {
        super(command, transactionId);
    }

    public void setStackDepth(int depth) {
        this.myDepth = depth;
    }

    public void setContext(int id) {
        this.myContext = id;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setMaxDataSize(int size) {
        this.mySize = size;
    }

    public void setDataPage(int page) {
        this.myPage = page;
    }

    protected String getName() {
        return this.myName;
    }

    protected int getContext() {
        return this.myContext;
    }

    @Override
    protected String getArguments() {
        StringBuilder builder = new StringBuilder(NAME_ARG);
        builder.append(this.myName);
        this.setDepth(builder);
        this.setContext(builder);
        this.setMaxSize(builder);
        this.setPage(builder);
        return builder.toString();
    }

    private void setPage(StringBuilder builder) {
        if (this.myPage == -1) {
            return;
        }
        builder.append(" ");
        builder.append(PAGE_ARG);
        builder.append(this.myPage);
    }

    private void setMaxSize(StringBuilder builder) {
        if (this.mySize == -1) {
            return;
        }
        builder.append(" ");
        builder.append(MAX_SIZE_ARG);
        builder.append(this.mySize);
    }

    private void setContext(StringBuilder builder) {
        if (this.myContext == -1) {
            return;
        }
        builder.append(" ");
        builder.append(CONTEXT_ARG);
        builder.append(this.myContext);
    }

    private void setDepth(StringBuilder builder) {
        if (this.myDepth == -1) {
            return;
        }
        builder.append(" ");
        builder.append(DEPTH_ARG);
        builder.append(this.myDepth);
    }
}

