/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportKeyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="algorithm")
    private final Algorithm algorithm;
    @JsonProperty(value="publicKey")
    private final String publicKey;
    @JsonProperty(value="loggingContext")
    private final Map<String, String> loggingContext;

    @Deprecated
    @ConstructorProperties(value={"keyId", "keyVersionId", "algorithm", "publicKey", "loggingContext"})
    public ExportKeyDetails(String keyId, String keyVersionId, Algorithm algorithm, String publicKey, Map<String, String> loggingContext) {
        this.keyId = keyId;
        this.keyVersionId = keyVersionId;
        this.algorithm = algorithm;
        this.publicKey = publicKey;
        this.loggingContext = loggingContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public Map<String, String> getLoggingContext() {
        return this.loggingContext;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportKeyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("keyId=").append(String.valueOf(this.keyId));
        sb.append(", keyVersionId=").append(String.valueOf(this.keyVersionId));
        sb.append(", algorithm=").append(String.valueOf((Object)this.algorithm));
        sb.append(", publicKey=").append(String.valueOf(this.publicKey));
        sb.append(", loggingContext=").append(String.valueOf(this.loggingContext));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportKeyDetails)) {
            return false;
        }
        ExportKeyDetails other = (ExportKeyDetails)((Object)o);
        return Objects.equals(this.keyId, other.keyId) && Objects.equals(this.keyVersionId, other.keyVersionId) && Objects.equals((Object)this.algorithm, (Object)other.algorithm) && Objects.equals(this.publicKey, other.publicKey) && Objects.equals(this.loggingContext, other.loggingContext) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.keyVersionId == null ? 43 : this.keyVersionId.hashCode());
        result = result * 59 + (this.algorithm == null ? 43 : this.algorithm.hashCode());
        result = result * 59 + (this.publicKey == null ? 43 : this.publicKey.hashCode());
        result = result * 59 + (this.loggingContext == null ? 43 : this.loggingContext.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Algorithm implements BmcEnum
    {
        RsaOaepAesSha256("RSA_OAEP_AES_SHA256"),
        RsaOaepSha256("RSA_OAEP_SHA256");

        private final String value;
        private static Map<String, Algorithm> map;

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Algorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Algorithm: " + key);
        }

        static {
            map = new HashMap<String, Algorithm>();
            for (Algorithm v : Algorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="algorithm")
        private Algorithm algorithm;
        @JsonProperty(value="publicKey")
        private String publicKey;
        @JsonProperty(value="loggingContext")
        private Map<String, String> loggingContext;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            this.__explicitlySet__.add("algorithm");
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            this.__explicitlySet__.add("publicKey");
            return this;
        }

        public Builder loggingContext(Map<String, String> loggingContext) {
            this.loggingContext = loggingContext;
            this.__explicitlySet__.add("loggingContext");
            return this;
        }

        public ExportKeyDetails build() {
            ExportKeyDetails model = new ExportKeyDetails(this.keyId, this.keyVersionId, this.algorithm, this.publicKey, this.loggingContext);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportKeyDetails model) {
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("keyVersionId")) {
                this.keyVersionId(model.getKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("algorithm")) {
                this.algorithm(model.getAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("publicKey")) {
                this.publicKey(model.getPublicKey());
            }
            if (model.wasPropertyExplicitlySet("loggingContext")) {
                this.loggingContext(model.getLoggingContext());
            }
            return this;
        }
    }
}

