/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.InsertStatement;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.TablesClause;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

class InsertStatementAnalyzer
extends SQLStatementAnalyzer {
    private final List<String> columns = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();
    private QualIdent table = null;

    public static InsertStatement analyze(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        seq.moveStart();
        if (!seq.moveNext()) {
            return null;
        }
        InsertStatementAnalyzer sa = new InsertStatementAnalyzer(seq, quoter);
        sa.parse();
        SQLStatementAnalyzer.TableIdent ti = new SQLStatementAnalyzer.TableIdent(sa.table, null);
        TablesClause tablesClause = sa.context.isAfter(SQLStatement.Context.FROM) ? sa.createTablesClause(Collections.singletonList(ti)) : null;
        return new InsertStatement(sa.startOffset, seq.offset() + seq.token().length(), sa.getTable(), Collections.unmodifiableList(sa.columns), Collections.unmodifiableList(sa.values), sa.offset2Context, tablesClause, Collections.unmodifiableList(sa.subqueries));
    }

    private InsertStatementAnalyzer(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        super(seq, quoter);
    }

    private void parse() {
        this.startOffset = this.seq.offset();
        block20: do {
            switch (this.context) {
                case START: {
                    if (!SQLStatementAnalyzer.isKeyword("INSERT", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.INSERT);
                    break;
                }
                case INSERT: {
                    if (!SQLStatementAnalyzer.isKeyword("INTO", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.INSERT_INTO);
                    break;
                }
                case INSERT_INTO: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            this.table = this.parseIdentifier();
                            break;
                        }
                        case LPAREN: {
                            this.moveToContext(SQLStatement.Context.COLUMNS);
                            break;
                        }
                        case KEYWORD: {
                            if (SQLStatementAnalyzer.isKeyword("VALUES", (TokenSequence<SQLTokenId>)this.seq)) {
                                this.moveToContext(SQLStatement.Context.VALUES);
                                break;
                            }
                            if (!SQLStatementAnalyzer.isKeyword("SET", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.SET);
                        }
                    }
                    continue block20;
                }
                case COLUMNS: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            List<String> chosenColumns = this.analyzeChosenColumns();
                            if (chosenColumns.isEmpty()) break;
                            this.columns.addAll(chosenColumns);
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("VALUES", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.VALUES);
                            break;
                        }
                        case RPAREN: {
                            this.moveToContext(SQLStatement.Context.VALUES);
                        }
                    }
                    continue block20;
                }
                case VALUES: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            List<String> newValues = this.analyzeChosenColumns();
                            if (newValues.isEmpty()) break;
                            this.values.addAll(newValues);
                        }
                    }
                    break;
                }
            }
        } while (this.nextToken());
    }

    private List<String> analyzeChosenColumns() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getUnquotedIdentifier());
        block5: while (this.seq.moveNext()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case WHITESPACE: {
                    continue block5;
                }
                case COMMA: {
                    continue block5;
                }
                case RPAREN: {
                    return parts;
                }
            }
            parts.add(this.getUnquotedIdentifier());
        }
        return parts;
    }

    private QualIdent getTable() {
        return this.table;
    }
}

