/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.java.ui.PullUpRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.PushDownPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PushDownRefactoringUI
implements RefactoringUI,
JavaRefactoringUIFactory {
    private PushDownRefactoring refactoring;
    private Set initialMembers;
    private PushDownPanel panel;
    private String description;

    private PushDownRefactoringUI(TreePathHandle selectedElements, CompilationInfo info) {
        this.initialMembers = new HashSet();
        TreePathHandle selectedPath = PushDownRefactoringUI.resolveSelection(selectedElements, info);
        if (selectedPath != null) {
            TreePath tp;
            Element selected = selectedPath.resolveElement(info);
            this.initialMembers.add(MemberInfo.create(selected, info));
            if (!(selected instanceof TypeElement)) {
                selected = info.getElementUtilities().enclosingTypeElement(selected);
            }
            if ((tp = info.getTrees().getPath(selected)) != null) {
                TreePathHandle sourceType = TreePathHandle.create((TreePath)tp, (CompilationInfo)info);
                this.description = ElementHeaders.getHeader((TreePath)tp, (CompilationInfo)info, (String)"%name%");
                this.refactoring = new PushDownRefactoring(sourceType);
                this.refactoring.getContext().add((Object)RefactoringUtils.getClasspathInfoFor(sourceType));
            } else {
                this.refactoring = new PushDownRefactoring(selectedElements);
            }
        } else {
            this.refactoring = new PushDownRefactoring(selectedElements);
        }
    }

    private PushDownRefactoringUI() {
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new PushDownPanel(this.refactoring, this.initialMembers, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(PushDownRefactoringUI.class, (String)"DSC_PushDown", (Object)this.description);
    }

    public String getName() {
        return NbBundle.getMessage(PushDownRefactoringUI.class, (String)"LBL_PushDown");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.PushDownRefactoringUI");
    }

    private void captureParameters() {
        this.refactoring.setMembers(this.panel.getMembers());
    }

    static TreePathHandle resolveSelection(TreePathHandle source, CompilationInfo javac) {
        TreePath resolvedPath;
        TreePath path = resolvedPath = source.resolve(javac);
        Element resolvedElement = source.resolveElement(javac);
        while (path != null && resolvedElement == null) {
            if ((path = path.getParentPath()) == null) {
                return null;
            }
            resolvedElement = javac.getTrees().getElement(path);
        }
        return path == resolvedPath ? source : TreePathHandle.create((TreePath)path, (CompilationInfo)javac);
    }

    @Override
    public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
        assert (handles.length == 1);
        TreePathHandle selectedElement = PullUpRefactoringUI.findSelectedClassMemberDeclaration(handles[0], info);
        return selectedElement != null ? new PushDownRefactoringUI(selectedElement, info) : null;
    }

    public static JavaRefactoringUIFactory factory() {
        return new PushDownRefactoringUI();
    }
}

