/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

class LayoutOperations
implements LayoutConstants {
    private LayoutModel layoutModel;
    private VisualMapper visualMapper;
    private static final boolean PREFER_ZERO_GAPS = true;
    private static final boolean SYMETRIC_ZERO_GAPS = true;
    private static final boolean allUnalignedGapsRequired = false;

    LayoutOperations(LayoutModel model, VisualMapper mapper) {
        this.layoutModel = model;
        this.visualMapper = mapper;
    }

    LayoutModel getModel() {
        return this.layoutModel;
    }

    VisualMapper getMapper() {
        return this.visualMapper;
    }

    int extract(LayoutInterval interval, int alignment, boolean closed, List<List> restLeading, List<List> restTrailing) {
        return this.extract(interval, interval, alignment, closed, restLeading, restTrailing);
    }

    int extract(LayoutInterval leading, LayoutInterval trailing, int alignment, boolean closed, List<List> restLeading, List<List> restTrailing) {
        int extractCount;
        LayoutInterval seq = leading.getParent();
        assert (seq.isSequential());
        int leadingIndex = seq.indexOf(leading);
        int trailingIndex = seq.indexOf(trailing);
        int count = seq.getSubIntervalCount();
        if (closed) {
            extractCount = trailingIndex - leadingIndex + 1;
        } else if (alignment != 0 && alignment != 1) {
            extractCount = 1;
        } else {
            int n = extractCount = alignment == 0 ? count - leadingIndex : leadingIndex + 1;
        }
        if (extractCount < seq.getSubIntervalCount()) {
            LinkedList<LayoutInterval> toRemainL = null;
            LinkedList<LayoutInterval> toRemainT = null;
            int startIndex = alignment == 0 ? leadingIndex : leadingIndex - extractCount + 1;
            int endIndex = alignment == 0 ? trailingIndex + extractCount - 1 : trailingIndex;
            Iterator<LayoutInterval> it = seq.getSubIntervals();
            int idx = 0;
            while (it.hasNext()) {
                LayoutInterval li = it.next();
                if (idx < startIndex) {
                    if (toRemainL == null) {
                        toRemainL = new LinkedList<LayoutInterval>();
                        toRemainL.add((LayoutInterval)((Object)Integer.valueOf(LayoutInterval.getEffectiveAlignment(li))));
                    }
                    toRemainL.add(li);
                } else if (idx > endIndex) {
                    if (toRemainT == null) {
                        toRemainT = new LinkedList<LayoutInterval>();
                        toRemainT.add((LayoutInterval)((Object)Integer.valueOf(LayoutInterval.getEffectiveAlignment(li))));
                    }
                    toRemainT.add(li);
                }
                ++idx;
            }
            if (toRemainL != null) {
                it = toRemainL.iterator();
                it.next();
                do {
                    this.layoutModel.removeInterval(it.next());
                } while (it.hasNext());
                restLeading.add(toRemainL);
            }
            if (toRemainT != null) {
                it = toRemainT.iterator();
                it.next();
                do {
                    this.layoutModel.removeInterval(it.next());
                } while (it.hasNext());
                restTrailing.add(toRemainT);
            }
        }
        return extractCount;
    }

    LayoutInterval addGroupContent(List<List> list, LayoutInterval seq, int index, int dimension, int position) {
        assert (seq.isSequential() && (position == 0 || position == 1));
        boolean resizingFillGap = false;
        LayoutInterval commonGap = null;
        boolean onlyGaps = true;
        for (int i = list.size() - 1; i >= 0; --i) {
            List subList = list.get(i);
            assert (subList.size() >= 2);
            if (subList.size() == 2) {
                LayoutInterval li = (LayoutInterval)subList.get(1);
                if (li.isEmptySpace()) {
                    if (commonGap == null || li.getPreferredSize() > commonGap.getPreferredSize()) {
                        commonGap = li;
                    }
                    if (LayoutInterval.canResize(li)) {
                        resizingFillGap = true;
                    }
                    list.remove(i);
                    continue;
                }
                onlyGaps = false;
                continue;
            }
            onlyGaps = false;
        }
        if (onlyGaps) {
            if (resizingFillGap && !LayoutInterval.canResize(commonGap)) {
                this.layoutModel.setIntervalSize(commonGap, -1, commonGap.getPreferredSize(), Short.MAX_VALUE);
            }
            this.insertGapIntoSequence(commonGap, seq, index, dimension);
            return null;
        }
        if (list.size() == 1) {
            List subList = list.get(0);
            int n = subList.size();
            for (int i = n - 1; i > 0; --i) {
                LayoutInterval li = (LayoutInterval)subList.get(i);
                if (resizingFillGap && li.isEmptySpace() && !LayoutInterval.canResize(li) && (i == 1 && position == 1 || i == n - 1 && position == 0)) {
                    this.layoutModel.setIntervalSize(li, -1, li.getPreferredSize(), Short.MAX_VALUE);
                }
                if (li.isEmptySpace() && (i == 1 && position == 0 || i == n - 1 && position == 1)) {
                    this.insertGapIntoSequence(li, seq, index, dimension);
                    continue;
                }
                this.layoutModel.addInterval(li, seq, index);
            }
            return null;
        }
        LayoutInterval group = new LayoutInterval(103);
        for (List subList : list) {
            LayoutInterval interval;
            int alignment;
            if (subList.size() == 2) {
                alignment = (Integer)subList.get(0);
                interval = (LayoutInterval)subList.get(1);
                if (alignment == 0 || alignment == 1) {
                    this.layoutModel.setIntervalAlignment(interval, alignment);
                }
            } else {
                interval = new LayoutInterval(102);
                alignment = (Integer)subList.get(0);
                if (alignment == 0 || alignment == 1) {
                    interval.setAlignment(alignment);
                }
                int n = subList.size();
                for (int i = 1; i < n; ++i) {
                    LayoutInterval li = (LayoutInterval)subList.get(i);
                    if (resizingFillGap && li.isEmptySpace() && !LayoutInterval.canResize(li) && (i == 1 && position == 1 || i == n - 1 && position == 0)) {
                        this.layoutModel.setIntervalSize(li, -1, li.getPreferredSize(), Short.MAX_VALUE);
                    }
                    this.layoutModel.addInterval(li, interval, -1);
                }
            }
            this.layoutModel.addInterval(interval, group, -1);
        }
        this.layoutModel.addInterval(group, seq, index);
        return group;
    }

    int addContent(LayoutInterval interval, LayoutInterval target, int index) {
        return this.addContent(interval, target, index, -1);
    }

    int addContent(LayoutInterval interval, LayoutInterval target, int index, int dimension) {
        int count = target.getSubIntervalCount();
        while (interval.isGroup() && interval.getSubIntervalCount() == 1) {
            interval = this.layoutModel.removeInterval(interval, 0);
        }
        if (interval.isSequential() && target.isSequential()) {
            if (index < 0) {
                index = target.getSubIntervalCount();
            }
            int startIndex = index;
            while (interval.getSubIntervalCount() > 0) {
                LayoutInterval li = this.layoutModel.removeInterval(interval, 0);
                this.layoutModel.addInterval(li, target, index++);
            }
            if (dimension == 0 || dimension == 1) {
                --index;
                if (--startIndex >= 0 && this.mergeConsecutiveGaps(target, startIndex, dimension)) {
                    --index;
                }
                this.mergeConsecutiveGaps(target, index, dimension);
            }
        } else if (interval.isParallel() && target.isParallel()) {
            this.layoutModel.addInterval(interval, target, index);
            this.dissolveRedundantGroup(interval);
        } else {
            if (target.isSequential() && interval.getRawAlignment() != -1) {
                this.layoutModel.setIntervalAlignment(interval, -1);
            }
            this.layoutModel.addInterval(interval, target, index);
        }
        return target.getSubIntervalCount() - count;
    }

    void resizeInterval(LayoutInterval interval, int size) {
        int min;
        assert (size >= 0 || size == -1);
        int n = min = interval.getMinimumSize() == interval.getPreferredSize() && interval.getMaximumSize() < Short.MAX_VALUE ? size : interval.getMinimumSize();
        int max = interval.getMaximumSize() == interval.getPreferredSize() ? (size == -1 ? -2 : size) : interval.getMaximumSize();
        this.layoutModel.setIntervalSize(interval, min, size, max);
    }

    void setIntervalResizing(LayoutInterval interval, boolean resizing) {
        this.layoutModel.setIntervalSize(interval, resizing ? -1 : -2, interval.getPreferredSize(), resizing ? Short.MAX_VALUE : -2);
    }

    void suppressGroupResizing(LayoutInterval group) {
        if (group.getParent() != null) {
            this.layoutModel.setIntervalSize(group, group.getMinimumSize(), group.getPreferredSize(), -2);
        }
    }

    void enableGroupResizing(LayoutInterval group) {
        this.layoutModel.setIntervalSize(group, group.getMinimumSize(), group.getPreferredSize(), -1);
    }

    void eliminateResizing(LayoutInterval interval, int dimension, Collection<LayoutInterval> eliminated) {
        block4: {
            block3: {
                if (!interval.isSingle()) break block3;
                if (!LayoutInterval.wantResize(interval)) break block4;
                int pref = Integer.MIN_VALUE;
                if (interval.hasAttribute(512)) {
                    pref = LayoutInterval.getCurrentSize(interval, dimension);
                }
                if (pref == Integer.MIN_VALUE) {
                    pref = interval.getPreferredSize();
                }
                this.layoutModel.setIntervalSize(interval, -2, pref, -2);
                if (eliminated == null) break block4;
                eliminated.add(interval);
                break block4;
            }
            Iterator<LayoutInterval> it = interval.getSubIntervals();
            while (it.hasNext()) {
                this.eliminateResizing(it.next(), dimension, eliminated);
            }
        }
    }

    Collection<LayoutInterval> eliminateRedundantSuppressedResizing(LayoutInterval group, int dimension) {
        if (!group.isParallel()) {
            group = group.getParent();
        }
        if (group.getParent() != null && !LayoutInterval.canResize(group)) {
            int groupSize = group.getCurrentSpace().size(dimension);
            if (groupSize <= 0) {
                return Collections.EMPTY_LIST;
            }
            LayoutInterval oneResizing = null;
            boolean span = false;
            Iterator<LayoutInterval> it = group.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval li = it.next();
                if (LayoutInterval.wantResize(li)) {
                    if (oneResizing == null) {
                        oneResizing = li;
                        continue;
                    }
                    return Collections.EMPTY_LIST;
                }
                if (span || li.isEmptySpace() || li.getCurrentSpace().size(dimension) != groupSize) continue;
                span = true;
            }
            if (oneResizing != null && !span) {
                LinkedList<LayoutInterval> l = new LinkedList<LayoutInterval>();
                if (!oneResizing.isGroup() || !this.suppressResizingInSubgroup(oneResizing, l)) {
                    this.eliminateResizing(oneResizing, dimension, l);
                }
                this.enableGroupResizing(group);
                return l;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private boolean suppressResizingInSubgroup(LayoutInterval group, Collection<LayoutInterval> eliminated) {
        LayoutInterval oneResizing = null;
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            boolean res = LayoutInterval.canResize(li) ? (li.isGroup() ? !this.suppressResizingInSubgroup(li, eliminated) : true) : false;
            if (!res) continue;
            if (oneResizing == null) {
                oneResizing = li;
                continue;
            }
            if (group.isParallel()) {
                this.suppressGroupResizing(group);
                eliminated.add(group);
                return true;
            }
            return false;
        }
        return oneResizing == null;
    }

    boolean completeGroupResizing(LayoutInterval group, int dimension) {
        if (!(group.isParallel() && LayoutInterval.canResize(group) && LayoutInterval.contentWantResize(group))) {
            return false;
        }
        boolean gapAdded = false;
        LinkedList<LayoutInterval> list = null;
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            if (li.isEmptySpace() || LayoutInterval.wantResize(li) || li.getAlignment() != 0 && li.getAlignment() != 1) continue;
            if (list == null) {
                list = new LinkedList<LayoutInterval>();
            }
            list.add(li);
        }
        if (list != null) {
            for (LayoutInterval li : list) {
                LayoutInterval gap = new LayoutInterval(101);
                gap.setMinimumSize(0);
                gap.setPreferredSize(0);
                gap.setMaximumSize(Short.MAX_VALUE);
                gap.setAttribute(1024);
                this.insertGap(gap, li, li.getCurrentSpace().positions[dimension][li.getAlignment() ^ 1], dimension, li.getAlignment() ^ 1);
                if (gap.getParent() == null) continue;
                gapAdded = true;
            }
        }
        return gapAdded;
    }

    void enableFlexibleSizeDefinition(LayoutInterval interval, boolean subcontainers) {
        if (interval.isGroup()) {
            Iterator<LayoutInterval> it = interval.getSubIntervals();
            while (it.hasNext()) {
                this.enableFlexibleSizeDefinition(it.next(), subcontainers);
            }
        } else {
            this.layoutModel.changeIntervalAttribute(interval, 1024, true);
            if (interval.isComponent() && subcontainers && interval.getComponent().isLayoutContainer()) {
                LayoutComponent comp = interval.getComponent();
                int dimension = comp.getLayoutInterval(0) == interval ? 0 : 1;
                this.enableFlexibleSizeDefinition(comp.getDefaultLayoutRoot(dimension), true);
            }
        }
    }

    void setParallelSameSize(LayoutInterval group, LayoutInterval aligned, int dimension) {
        assert (group.isParallel());
        LayoutInterval alignedComp = LayoutOperations.getOneNonEmpty(aligned);
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            int min;
            LayoutInterval li = it.next();
            if (li == aligned) continue;
            if (li.isParallel()) {
                if (li.getGroupAlignment() != 0 && li.getGroupAlignment() != 1) continue;
                this.setParallelSameSize(li, alignedComp, dimension);
                continue;
            }
            LayoutInterval sub = LayoutOperations.getOneNonEmpty(li);
            if (sub == null || !LayoutRegion.sameSpace(alignedComp.getCurrentSpace(), sub.getCurrentSpace(), dimension) || LayoutInterval.wantResize(li)) continue;
            if (sub.isParallel()) {
                if (sub.getGroupAlignment() != 0 && sub.getGroupAlignment() != 1) continue;
                this.setParallelSameSize(sub, alignedComp, dimension);
                continue;
            }
            if (this.isPressurizedComponent(sub)) continue;
            if (!LayoutInterval.isAlignedAtBorder(li, aligned.getAlignment())) {
                this.layoutModel.setIntervalAlignment(li, aligned.getAlignment());
            }
            this.layoutModel.setIntervalSize(sub, (min = sub.getMinimumSize()) != -2 ? min : -1, sub.getPreferredSize(), Short.MAX_VALUE);
        }
    }

    private static LayoutInterval getOneNonEmpty(LayoutInterval interval) {
        if (!interval.isSequential()) {
            return interval;
        }
        LayoutInterval nonEmpty = null;
        Iterator<LayoutInterval> it = interval.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            if (li.isEmptySpace()) continue;
            if (nonEmpty == null) {
                nonEmpty = li;
                continue;
            }
            return null;
        }
        return nonEmpty;
    }

    private boolean isPressurizedComponent(LayoutInterval interval) {
        LayoutComponent comp;
        Dimension minSize;
        int pref = interval.getPreferredSize();
        if (interval.isComponent() && !LayoutInterval.canResize(interval) && pref != -1 && (minSize = this.visualMapper.getComponentMinimumSize((comp = interval.getComponent()).getId())) != null) {
            int min;
            int n = min = comp.getLayoutInterval(0) == interval ? minSize.width : minSize.height;
            if (pref < min) {
                return true;
            }
        }
        return false;
    }

    void mergeParallelGroups(LayoutInterval group) {
        for (int i = group.getSubIntervalCount() - 1; i >= 0; --i) {
            LayoutInterval sub = group.getSubInterval(i);
            if (!sub.isGroup()) continue;
            this.mergeParallelGroups(sub);
            this.dissolveRedundantGroup(sub);
        }
    }

    boolean dissolveRedundantGroup(LayoutInterval group) {
        LayoutInterval parent = group.getParent();
        if (parent == null) {
            return false;
        }
        boolean justOne = group.getSubIntervalCount() == 1;
        boolean dissolve = false;
        if (justOne) {
            dissolve = true;
        } else if (group.isSequential() && parent.isSequential()) {
            dissolve = true;
        } else if (group.isParallel() && parent.isParallel()) {
            int gA = group.getGroupAlignment();
            int pA = parent.getGroupAlignment();
            if (parent.getSubIntervalCount() == 1 && (gA == pA || gA != 3 && gA != 2)) {
                dissolve = true;
            } else {
                boolean compatible;
                int align = group.getAlignment();
                boolean sameAlign = true;
                boolean subResizing = false;
                Iterator<LayoutInterval> it = group.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval li = it.next();
                    if (!subResizing && LayoutInterval.wantResize(li)) {
                        subResizing = true;
                    }
                    if (li.getAlignment() == align) continue;
                    sameAlign = false;
                }
                if (subResizing && (sameAlign || gA != 3)) {
                    int dim;
                    compatible = false;
                    boolean resizingAlreadyContained = LayoutInterval.canResize(group) ? true : (!LayoutInterval.canResize(parent) ? (dim = LayoutUtils.determineDimension(parent)) < 0 || LayoutInterval.getCurrentSize(parent, dim) == LayoutInterval.getCurrentSize(group, dim) : false);
                    if (resizingAlreadyContained) {
                        LayoutInterval neighbor;
                        it = parent.getSubIntervals();
                        while (it.hasNext()) {
                            LayoutInterval li = it.next();
                            if (li == group || !LayoutInterval.wantResize(li)) continue;
                            compatible = true;
                            break;
                        }
                        if (!compatible && (align == 0 || align == 1) && (neighbor = LayoutInterval.getNeighbor(parent, group.getAlignment() ^ 1, false, true, true)) != null && neighbor.isEmptySpace() && neighbor.getPreferredSize() == -1) {
                            compatible = true;
                        }
                    }
                } else {
                    compatible = sameAlign;
                }
                dissolve = compatible;
            }
        }
        if (dissolve) {
            int index;
            if (parent.isParallel()) {
                int alignmentInParent = group.getAlignment();
                index = this.layoutModel.removeInterval(group);
                while (group.getSubIntervalCount() > 0) {
                    LayoutInterval li = group.getSubInterval(0);
                    int align = li.getAlignment();
                    this.layoutModel.removeInterval(li);
                    if (justOne) {
                        if (align != -1 && align != alignmentInParent || align == -1 && alignmentInParent != parent.getGroupAlignment()) {
                            this.layoutModel.setIntervalAlignment(li, group.getRawAlignment());
                        }
                        if ((!LayoutInterval.canResize(group) || align == 3) && LayoutInterval.wantResize(li)) {
                            if (li.isGroup()) {
                                this.suppressGroupResizing(li);
                            } else {
                                this.layoutModel.setIntervalSize(li, -2, li.getPreferredSize(), -2);
                            }
                        }
                    } else if (group.isParallel() && li.getRawAlignment() == -1 && group.getGroupAlignment() != parent.getGroupAlignment()) {
                        this.layoutModel.setIntervalAlignment(li, align);
                    }
                    this.layoutModel.addInterval(li, parent, index++);
                }
            } else {
                int dim = LayoutUtils.determineDimension(group);
                index = this.layoutModel.removeInterval(group);
                this.addContent(group, parent, index, dim);
            }
            if (parent.getSubIntervalCount() == 1) {
                this.dissolveRedundantGroup(parent.getSubInterval(0));
            }
            return true;
        }
        return false;
    }

    void moveInsideSequential(LayoutInterval parent, int dimension) {
        block18: {
            LayoutInterval outGroup;
            assert (parent.isSequential());
            if (!parent.isSequential()) {
                return;
            }
            int alignment = 0;
            block0: do {
                int addIdx;
                int idx;
                LayoutInterval inGroup;
                LayoutInterval extend;
                if ((extend = this.findIntervalToExtend(parent, dimension, alignment)) == null) {
                    if (alignment == 0) {
                        alignment = 1;
                        extend = this.findIntervalToExtend(parent, dimension, alignment);
                    }
                    if (extend == null) break block18;
                }
                outGroup = inGroup = extend.getParent();
                while (outGroup.getParent() != parent) {
                    outGroup = outGroup.getParent();
                }
                int index = parent.indexOf(outGroup);
                int d = alignment == 0 ? -1 : 1;
                boolean commonEndingGap = true;
                int n = parent.getSubIntervalCount();
                for (int i = index - d; i >= 0 && i < n; i -= d) {
                    LayoutInterval par;
                    LayoutInterval li = parent.getSubInterval(i);
                    if (li.isEmptySpace() && (i - d < 0 || i - d >= n) || !LayoutInterval.wantResize(li)) continue;
                    LayoutInterval endGap = parent.getSubInterval(alignment == 0 ? n - 1 : 0);
                    if (endGap != null && endGap.getPreferredSize() == -1) break;
                    commonEndingGap = false;
                    LayoutInterval closing = extend;
                    int borderPos = parent.getCurrentSpace().positions[dimension][alignment ^ 1];
                    do {
                        if (!(par = closing.getParent()).isParallel()) continue;
                        this.separateGroupContent(closing, borderPos, dimension, alignment ^ 1);
                    } while ((closing = par) != outGroup);
                    break;
                }
                int extendPos = extend.getCurrentSpace().positions[dimension][alignment ^ 1];
                if (!extend.isSequential()) {
                    LayoutInterval seq = new LayoutInterval(102);
                    seq.setAlignment(extend.getAlignment());
                    this.layoutModel.addInterval(seq, inGroup, this.layoutModel.removeInterval(extend));
                    this.layoutModel.setIntervalAlignment(extend, -1);
                    this.layoutModel.addInterval(extend, seq, 0);
                    extend = seq;
                }
                LayoutInterval connectingGap = null;
                if (alignment == 0) {
                    idx = index + 1;
                    addIdx = extend.getSubIntervalCount();
                } else {
                    idx = index - 1;
                    addIdx = 0;
                }
                while (idx >= 0 && idx < parent.getSubIntervalCount()) {
                    LayoutInterval li = parent.getSubInterval(idx);
                    if (li.isEmptySpace()) {
                        if (connectingGap == null) {
                            int neighborPos;
                            int distance;
                            if (extendPos != outGroup.getCurrentSpace().positions[dimension][alignment ^ 1] && (distance = d * (extendPos - (neighborPos = parent.getSubInterval((int)(idx - d)).getCurrentSpace().positions[dimension][alignment]))) > 0) {
                                this.resizeInterval(li, distance);
                            }
                            connectingGap = li;
                        } else if ((idx == 0 || idx == parent.getSubIntervalCount() - 1) && commonEndingGap) continue block0;
                    }
                    this.layoutModel.removeInterval(li);
                    this.layoutModel.addInterval(li, extend, addIdx);
                    if (alignment == 0) {
                        ++addIdx;
                        continue;
                    }
                    --idx;
                }
            } while (parent.getSubIntervalCount() != 1);
            assert (outGroup == parent.getSubInterval(0));
            this.layoutModel.removeInterval(outGroup);
            LayoutInterval superParent = parent.getParent();
            this.addContent(outGroup, superParent, this.layoutModel.removeInterval(parent));
        }
    }

    private LayoutInterval findIntervalToExtend(LayoutInterval parent, int dimension, int alignment) {
        int d = alignment == 0 ? -1 : 1;
        int count = parent.getSubIntervalCount();
        boolean atBorder = true;
        boolean gap = false;
        for (int idx = alignment == 0 ? count - 1 : 0; idx >= 0 && idx < parent.getSubIntervalCount(); idx += d) {
            LayoutInterval sub = parent.getSubInterval(idx);
            if (sub.isEmptySpace()) {
                gap = true;
                continue;
            }
            if (!atBorder && gap && sub.isParallel() && !LayoutInterval.isClosedGroup(sub, alignment ^ 1)) {
                int endIndex;
                int startIndex;
                if (alignment == 0) {
                    startIndex = idx + 1;
                    endIndex = parent.getSubIntervalCount() - 1;
                } else {
                    startIndex = 0;
                    endIndex = idx - 1;
                }
                LayoutInterval extend = this.prepareGroupExtension(sub, parent, startIndex, endIndex, dimension, alignment ^ 1);
                if (extend != null) {
                    return extend;
                }
            }
            gap = false;
            atBorder = false;
        }
        return null;
    }

    private LayoutInterval prepareGroupExtension(LayoutInterval group, LayoutInterval parent, int startIndex, int endIndex, int dimension, int alignment) {
        boolean allOverlapping = true;
        LayoutInterval singleOverlap = null;
        LinkedList<LayoutInterval> overlapList = null;
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            if (li.isEmptySpace()) continue;
            if (LayoutUtils.contentOverlap(li, parent, startIndex, endIndex, dimension ^ 1)) {
                if (singleOverlap == null) {
                    singleOverlap = li;
                    continue;
                }
                if (overlapList == null) {
                    overlapList = new LinkedList<LayoutInterval>();
                    overlapList.add(singleOverlap);
                }
                overlapList.add(li);
                continue;
            }
            allOverlapping = false;
        }
        if (allOverlapping || singleOverlap == null) {
            return null;
        }
        if (overlapList != null) {
            LayoutInterval subGroup = new LayoutInterval(103);
            subGroup.setGroupAlignment(alignment ^ 1);
            subGroup.setAlignment(alignment ^ 1);
            int index = -1;
            do {
                LayoutInterval li = (LayoutInterval)overlapList.remove(0);
                int idx = this.layoutModel.removeInterval(li);
                if (index < 0) {
                    index = idx;
                }
                this.layoutModel.addInterval(li, subGroup, -1);
                subGroup.getCurrentSpace().expand(li.getCurrentSpace());
            } while (overlapList.size() > 0);
            this.layoutModel.addInterval(subGroup, group, index);
            singleOverlap = subGroup;
        } else {
            LayoutInterval subOverlap;
            LayoutInterval subParallel;
            if (singleOverlap.isSequential()) {
                subParallel = singleOverlap.getSubInterval(alignment == 0 ? 0 : singleOverlap.getSubIntervalCount() - 1);
                if (!subParallel.isParallel()) {
                    subParallel = null;
                }
            } else {
                subParallel = singleOverlap.isParallel() ? singleOverlap : null;
            }
            if (subParallel != null && !LayoutInterval.isClosedGroup(subParallel, alignment) && (subOverlap = this.prepareGroupExtension(subParallel, parent, startIndex, endIndex, dimension, alignment)) != null) {
                singleOverlap = subOverlap;
            }
        }
        return singleOverlap;
    }

    private void separateGroupContent(LayoutInterval separate, int outPos, int dimension, int alignment) {
        LayoutInterval remainderGap;
        LayoutInterval group = separate.getParent();
        assert (group.isParallel());
        LayoutInterval remainder = null;
        LayoutInterval remainderGroup = null;
        LayoutRegion remainderSpace = null;
        int i = 0;
        while (i < group.getSubIntervalCount()) {
            LayoutInterval li = group.getSubInterval(i);
            if (li != separate) {
                assert (li.getAlignment() == (alignment ^ 1));
                this.layoutModel.removeInterval(li);
                if (remainder == null) {
                    remainder = li;
                } else {
                    if (remainderGroup == null) {
                        remainderGroup = new LayoutInterval(103);
                        remainderGroup.setAlignment(alignment ^ 1);
                        remainderGroup.setGroupAlignment(alignment ^ 1);
                        this.layoutModel.addInterval(remainder, remainderGroup, 0);
                        remainder = remainderGroup;
                    }
                    this.layoutModel.addInterval(li, remainderGroup, -1);
                }
                if (li.isEmptySpace()) continue;
                if (remainderSpace == null) {
                    remainderSpace = new LayoutRegion();
                }
                remainderSpace.expand(li.getCurrentSpace());
                continue;
            }
            ++i;
        }
        remainder.setCurrentSpace(remainderSpace);
        int remainderPos = remainderSpace.positions[dimension][alignment];
        if (LayoutRegion.isValidCoordinate(outPos)) {
            int gapSize = alignment == 0 ? remainderPos - outPos : outPos - remainderPos;
            remainderGap = new LayoutInterval(101);
            remainderGap.setSizes(-1, gapSize, Short.MAX_VALUE);
        } else {
            remainderGap = LayoutInterval.getDirectNeighbor(group, alignment, false);
            if (remainderGap != null && remainderGap.isEmptySpace()) {
                this.layoutModel.removeInterval(remainderGap);
                LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(group, alignment, true);
                outPos = neighbor != null ? neighbor.getCurrentSpace().positions[dimension][alignment ^ 1] : group.getParent().getCurrentSpace().positions[dimension][alignment];
                int gapSize = alignment == 0 ? remainderPos - outPos : outPos - remainderPos;
                this.resizeInterval(remainderGap, gapSize);
            } else {
                remainderGap = null;
            }
        }
        if (remainderGap != null) {
            LayoutInterval seq;
            if (remainder.isSequential()) {
                seq = remainder;
            } else {
                seq = new LayoutInterval(102);
                this.layoutModel.setIntervalAlignment(remainder, -1);
                this.layoutModel.addInterval(remainder, seq, 0);
            }
            this.layoutModel.addInterval(remainderGap, seq, alignment == 0 ? 0 : -1);
            this.layoutModel.addInterval(seq, group, -1);
            group.getCurrentSpace().positions[dimension][alignment] = outPos;
        } else {
            this.layoutModel.addInterval(remainder, group, -1);
        }
    }

    void parallelizeWithParentSequence(LayoutInterval interval, int endIndex, int dimension) {
        LayoutInterval parent = interval.getParent();
        assert (parent.isParallel());
        LayoutInterval parParent = parent;
        while (!parParent.getParent().isSequential()) {
            parParent = parParent.getParent();
        }
        LayoutInterval parentSeq = parParent.getParent();
        int startIndex = parentSeq.indexOf(parParent);
        if (endIndex < 0) {
            endIndex = parentSeq.getSubIntervalCount() - 1;
        } else if (startIndex > endIndex) {
            int temp = startIndex;
            startIndex = endIndex;
            endIndex = temp;
        }
        this.layoutModel.removeInterval(interval);
        if (interval.getAlignment() == -1) {
            this.layoutModel.setIntervalAlignment(interval, parent.getGroupAlignment());
        }
        this.addParallelWithSequence(interval, parentSeq, startIndex, endIndex, dimension);
        if (parent.getSubIntervalCount() == 1) {
            this.addContent(this.layoutModel.removeInterval(parent, 0), parent.getParent(), this.layoutModel.removeInterval(parent), dimension);
        } else if (parent.getSubIntervalCount() == 0) {
            this.layoutModel.removeInterval(parent);
        }
    }

    void addParallelWithSequence(LayoutInterval interval, LayoutInterval seq, int startIndex, int endIndex, int dimension) {
        LayoutInterval group;
        if (startIndex > 0 || endIndex < seq.getSubIntervalCount() - 1) {
            group = new LayoutInterval(103);
            if (interval.getAlignment() != -1) {
                group.setGroupAlignment(interval.getAlignment());
            }
            int startPos = LayoutUtils.getVisualPosition(seq.getSubInterval(startIndex), dimension, 0);
            int endPos = LayoutUtils.getVisualPosition(seq.getSubInterval(endIndex), dimension, 1);
            group.getCurrentSpace().set(dimension, startPos, endPos);
            if (startIndex != endIndex) {
                LayoutInterval subSeq = new LayoutInterval(102);
                subSeq.setAlignment(interval.getAlignment());
                for (int n = endIndex - startIndex + 1; n > 0; --n) {
                    this.layoutModel.addInterval(this.layoutModel.removeInterval(seq, startIndex), subSeq, -1);
                }
                this.layoutModel.addInterval(subSeq, group, 0);
            } else {
                this.layoutModel.addInterval(this.layoutModel.removeInterval(seq, startIndex), group, 0);
            }
            this.layoutModel.addInterval(group, seq, startIndex);
            group.getCurrentSpace().expand(interval.getCurrentSpace(), dimension);
        } else {
            group = seq.getParent();
        }
        this.layoutModel.addInterval(interval, group, -1);
    }

    int optimizeGaps(LayoutInterval group, int dimension) {
        int idx;
        boolean originalRootGroup;
        LayoutInterval trailingGap;
        LayoutInterval leadingGap;
        int groupInnerPosTrailing;
        int groupInnerPosLeading;
        int[] groupOuterPos;
        boolean mayNeedSecondPass;
        boolean subGroupTrailing;
        boolean subGroupLeading;
        IntervalSet processTrailing;
        IntervalSet processLeading;
        block139: {
            int gapSize;
            LinkedList<LayoutInterval> reduceToZeroGapsTrailing;
            int commonGapTrailingSize;
            LayoutConstants.PaddingType trailingPadding;
            block140: {
                int size;
                LayoutInterval zeroGapTrailing;
                block141: {
                    boolean validTrailingGapRemoved;
                    boolean resizingGapTrailing;
                    boolean effectiveExplicitGapTrailing;
                    boolean defaultTrailingPadding;
                    boolean anyAlignedTrailing;
                    block136: {
                        LinkedList<LayoutInterval> reduceToZeroGapsLeading;
                        int commonGapLeadingSize;
                        LayoutConstants.PaddingType leadingPadding;
                        block137: {
                            int size2;
                            LayoutInterval zeroGapLeading;
                            block138: {
                                int i;
                                for (int i2 = 0; i2 < group.getSubIntervalCount(); ++i2) {
                                    LayoutInterval li = group.getSubInterval(i2);
                                    if (!li.isEmptySpace() || group.getSubIntervalCount() <= 1) continue;
                                    this.layoutModel.removeInterval(group, i2);
                                    --i2;
                                }
                                if (group.getSubIntervalCount() <= 1) {
                                    return -1;
                                }
                                boolean anyAlignedLeading = false;
                                anyAlignedTrailing = false;
                                boolean contentResizing = false;
                                processLeading = null;
                                processTrailing = null;
                                subGroupLeading = false;
                                subGroupTrailing = false;
                                IntervalSet[] alignedGaps = new IntervalSet[]{new IntervalSet(), new IntervalSet()};
                                IntervalSet[] alignedNoGaps = new IntervalSet[]{new IntervalSet(), new IntervalSet()};
                                IntervalSet[] unalignedFixedGaps = new IntervalSet[]{new IntervalSet(), new IntervalSet()};
                                IntervalSet[] unalignedResGaps = new IntervalSet[]{new IntervalSet(), new IntervalSet()};
                                IntervalSet[] unalignedNoGaps = new IntervalSet[]{new IntervalSet(), new IntervalSet()};
                                for (int i3 = 0; i3 < group.getSubIntervalCount(); ++i3) {
                                    LayoutInterval li = group.getSubInterval(i3);
                                    boolean leadAlign = false;
                                    boolean trailAlign = false;
                                    LayoutInterval leadingGap2 = null;
                                    LayoutInterval trailingGap2 = null;
                                    boolean leadGapRes = false;
                                    boolean trailGapRes = false;
                                    boolean contentRes = false;
                                    boolean noResizing = false;
                                    if (li.isSequential()) {
                                        for (int j = 0; j < li.getSubIntervalCount(); ++j) {
                                            LayoutInterval sub = li.getSubInterval(j);
                                            if (j == 0 && sub.isEmptySpace()) {
                                                leadingGap2 = sub;
                                                leadGapRes = LayoutInterval.wantResize(sub);
                                                continue;
                                            }
                                            if (j + 1 == li.getSubIntervalCount() && sub.isEmptySpace()) {
                                                trailingGap2 = sub;
                                                trailGapRes = LayoutInterval.wantResize(sub);
                                                continue;
                                            }
                                            if (contentRes || !LayoutInterval.wantResize(sub)) continue;
                                            contentRes = true;
                                        }
                                        if (!contentRes) {
                                            if (leadGapRes || trailGapRes) {
                                                leadAlign = trailGapRes && !leadGapRes;
                                                trailAlign = leadGapRes && !trailGapRes;
                                            } else {
                                                noResizing = true;
                                            }
                                        }
                                    } else if (LayoutInterval.wantResize(li)) {
                                        contentRes = true;
                                    } else {
                                        noResizing = true;
                                    }
                                    if (contentRes) {
                                        trailAlign = true;
                                        leadAlign = true;
                                    } else if (noResizing) {
                                        int alignment = li.getAlignment();
                                        leadAlign = alignment == 0;
                                        boolean bl = trailAlign = alignment == 1;
                                    }
                                    if (leadingGap2 != null) {
                                        if (leadAlign) {
                                            alignedGaps[0].add(li, !noResizing);
                                        } else if (leadGapRes) {
                                            unalignedResGaps[0].add(li, true);
                                        } else {
                                            unalignedFixedGaps[0].add(li, false);
                                        }
                                    } else if (!LayoutUtils.hasSideGaps(li, 0, true)) {
                                        if (leadAlign) {
                                            alignedNoGaps[0].add(li, !noResizing);
                                        } else {
                                            unalignedNoGaps[0].add(li, false);
                                        }
                                    }
                                    if (trailingGap2 != null) {
                                        if (trailAlign) {
                                            alignedGaps[1].add(li, !noResizing);
                                            continue;
                                        }
                                        if (trailGapRes) {
                                            unalignedResGaps[1].add(li, true);
                                            continue;
                                        }
                                        unalignedFixedGaps[1].add(li, false);
                                        continue;
                                    }
                                    if (LayoutUtils.hasSideGaps(li, 1, true)) continue;
                                    if (trailAlign) {
                                        alignedNoGaps[1].add(li, !noResizing);
                                        continue;
                                    }
                                    unalignedNoGaps[1].add(li, false);
                                }
                                IntervalSet[] alignedVariants = LayoutOperations.countAlignedVariants(alignedGaps, unalignedFixedGaps, unalignedResGaps);
                                IntervalSet[] unalignedVariants = LayoutOperations.countUnalignedVariants(unalignedFixedGaps, unalignedResGaps, unalignedNoGaps, dimension);
                                IntervalSet[] leadingVariants = new IntervalSet[]{alignedVariants[0], unalignedVariants[0]};
                                IntervalSet[] trailingVariants = new IntervalSet[]{alignedVariants[1], unalignedVariants[1]};
                                IntervalSet bestLeading = null;
                                IntervalSet bestTrailing = null;
                                for (i = 0; i < leadingVariants.length; ++i) {
                                    IntervalSet iSet = leadingVariants[i];
                                    if (bestLeading != null && iSet.count() <= bestLeading.count()) continue;
                                    bestLeading = iSet;
                                }
                                for (i = 0; i < trailingVariants.length; ++i) {
                                    IntervalSet iSet = trailingVariants[i];
                                    if (bestTrailing != null && iSet.count() <= bestTrailing.count()) continue;
                                    bestTrailing = iSet;
                                }
                                if (bestLeading.count() < group.getSubIntervalCount() && bestTrailing.count() < group.getSubIntervalCount()) {
                                    IntervalSet bestCombine = null;
                                    for (int i4 = 0; i4 < leadingVariants.length; ++i4) {
                                        IntervalSet lSet = leadingVariants[i4];
                                        for (int j = 0; j < trailingVariants.length; ++j) {
                                            IntervalSet tSet = trailingVariants[j];
                                            IntervalSet comSet = new IntervalSet();
                                            for (int ii = 0; ii < group.getSubIntervalCount(); ++ii) {
                                                LayoutInterval li = group.getSubInterval(ii);
                                                if (!lSet.contains(li) || !tSet.contains(li)) continue;
                                                comSet.add(li, LayoutInterval.wantResize(li));
                                            }
                                            if (bestCombine != null && comSet.count() <= bestCombine.count()) continue;
                                            bestCombine = comSet;
                                        }
                                    }
                                    if (bestCombine != null) {
                                        IntervalSet bestSingle;
                                        IntervalSet intervalSet = bestSingle = bestLeading.count() > bestTrailing.count() ? bestLeading : bestTrailing;
                                        if (bestSingle.count() - bestCombine.count() >= bestCombine.count()) {
                                            if (bestSingle == bestLeading) {
                                                bestTrailing.clear();
                                            } else {
                                                bestLeading.clear();
                                            }
                                        } else {
                                            bestLeading = bestCombine;
                                            bestTrailing = bestCombine;
                                        }
                                    }
                                }
                                if ((processLeading = bestLeading).count() < 2) {
                                    processLeading.clear();
                                }
                                if ((processTrailing = bestTrailing).count() < 2) {
                                    processTrailing.clear();
                                }
                                subGroupLeading = processLeading.count() < group.getSubIntervalCount();
                                boolean bl = subGroupTrailing = processTrailing.count() < group.getSubIntervalCount();
                                if (processLeading.count() > 0 || processTrailing.count() > 0) {
                                    for (int i5 = 0; i5 < group.getSubIntervalCount(); ++i5) {
                                        LayoutInterval li = group.getSubInterval(i5);
                                        boolean isL = processLeading.contains(li);
                                        boolean isT = processTrailing.contains(li);
                                        if (!isL && !isT) continue;
                                        boolean leadAlign = false;
                                        boolean trailAlign = false;
                                        boolean contentRes = false;
                                        boolean noResizing = false;
                                        if (li.isSequential()) {
                                            boolean leadGapRes = false;
                                            boolean trailGapRes = false;
                                            for (int j = 0; j < li.getSubIntervalCount(); ++j) {
                                                LayoutInterval sub = li.getSubInterval(j);
                                                if (j == 0 && isL && sub.isEmptySpace()) {
                                                    leadGapRes = LayoutInterval.wantResize(sub);
                                                    continue;
                                                }
                                                if (j + 1 == li.getSubIntervalCount() && isT && sub.isEmptySpace()) {
                                                    trailGapRes = LayoutInterval.wantResize(sub);
                                                    continue;
                                                }
                                                if (contentRes || !LayoutInterval.wantResize(sub)) continue;
                                                contentRes = true;
                                            }
                                            if (!contentRes) {
                                                if (leadGapRes || trailGapRes) {
                                                    leadAlign = trailGapRes && !leadGapRes;
                                                    trailAlign = leadGapRes && !trailGapRes;
                                                } else {
                                                    noResizing = true;
                                                }
                                            }
                                        } else if (LayoutInterval.wantResize(li)) {
                                            contentRes = true;
                                        } else {
                                            noResizing = true;
                                        }
                                        if (contentRes) {
                                            trailAlign = true;
                                            leadAlign = true;
                                        } else if (noResizing) {
                                            int alignment = li.getAlignment();
                                            leadAlign = alignment == 0;
                                            boolean bl2 = trailAlign = alignment == 1;
                                        }
                                        if (leadAlign && isL) {
                                            anyAlignedLeading = true;
                                        }
                                        if (trailAlign && isT) {
                                            anyAlignedTrailing = true;
                                        }
                                        if (!contentRes) continue;
                                        contentResizing = true;
                                    }
                                } else {
                                    contentResizing = LayoutInterval.wantResize(group);
                                }
                                boolean defaultLeadingPadding = false;
                                defaultTrailingPadding = false;
                                leadingPadding = null;
                                trailingPadding = null;
                                boolean effectiveExplicitGapLeading = false;
                                effectiveExplicitGapTrailing = false;
                                boolean resizingGapLeading = false;
                                resizingGapTrailing = false;
                                zeroGapLeading = null;
                                zeroGapTrailing = null;
                                boolean validLeadingGapRemoved = false;
                                validTrailingGapRemoved = false;
                                commonGapLeadingSize = Integer.MIN_VALUE;
                                commonGapTrailingSize = Integer.MIN_VALUE;
                                mayNeedSecondPass = false;
                                reduceToZeroGapsLeading = new LinkedList<LayoutInterval>();
                                reduceToZeroGapsTrailing = new LinkedList<LayoutInterval>();
                                for (int i6 = 0; i6 < group.getSubIntervalCount(); ++i6) {
                                    LayoutInterval li = group.getSubInterval(i6);
                                    if (!li.isSequential() || li.getSubIntervalCount() == 0) continue;
                                    LayoutInterval gap = li.getSubInterval(0);
                                    if (gap.isEmptySpace()) {
                                        boolean process = processLeading.contains(li);
                                        if (!this.isEndingGapUsable(li, dimension, 0, process, contentResizing)) {
                                            this.layoutModel.removeInterval(gap);
                                            gap = null;
                                        }
                                        if (gap != null && process) {
                                            if (this.isEndingGapEffective(li, dimension, 0)) {
                                                if (gap.getPreferredSize() == -1) {
                                                    defaultLeadingPadding = true;
                                                    leadingPadding = gap.getPaddingType();
                                                } else {
                                                    effectiveExplicitGapLeading = true;
                                                }
                                                if (commonGapLeadingSize == Integer.MIN_VALUE) {
                                                    int n = commonGapLeadingSize = gap.getMinimumSize() != -2 ? gap.getMinimumSize() : gap.getPreferredSize();
                                                }
                                            }
                                            if (gap.getMaximumSize() >= Short.MAX_VALUE) {
                                                if (anyAlignedLeading) {
                                                    reduceToZeroGapsLeading.add(gap);
                                                    gap = null;
                                                } else {
                                                    if (li.getAlignment() == 0) {
                                                        this.layoutModel.setIntervalAlignment(li, 1);
                                                    }
                                                    resizingGapLeading = true;
                                                    if (gap.getPreferredSize() == 0) {
                                                        zeroGapLeading = gap;
                                                    }
                                                }
                                            }
                                            if (gap != null) {
                                                this.layoutModel.removeInterval(gap);
                                                validLeadingGapRemoved = true;
                                            }
                                        }
                                    }
                                    if ((gap = li.getSubInterval(li.getSubIntervalCount() - 1)).isEmptySpace()) {
                                        boolean process = processTrailing.contains(li);
                                        if (!this.isEndingGapUsable(li, dimension, 1, process, contentResizing)) {
                                            this.layoutModel.removeInterval(gap);
                                            gap = null;
                                        }
                                        if (gap != null && process) {
                                            if (this.isEndingGapEffective(li, dimension, 1)) {
                                                if (gap.getPreferredSize() == -1) {
                                                    defaultTrailingPadding = true;
                                                    trailingPadding = gap.getPaddingType();
                                                } else {
                                                    effectiveExplicitGapTrailing = true;
                                                }
                                                if (commonGapTrailingSize == Integer.MIN_VALUE) {
                                                    int n = commonGapTrailingSize = gap.getMinimumSize() != -2 ? gap.getMinimumSize() : gap.getPreferredSize();
                                                }
                                            }
                                            if (gap.getMaximumSize() >= Short.MAX_VALUE) {
                                                if (anyAlignedTrailing) {
                                                    reduceToZeroGapsTrailing.add(gap);
                                                    gap = null;
                                                } else {
                                                    if (li.getAlignment() == 1) {
                                                        this.layoutModel.setIntervalAlignment(li, 0);
                                                    }
                                                    resizingGapTrailing = true;
                                                    if (gap.getPreferredSize() == 0) {
                                                        zeroGapTrailing = gap;
                                                    }
                                                }
                                            }
                                            if (gap != null) {
                                                this.layoutModel.removeInterval(gap);
                                                validTrailingGapRemoved = true;
                                            }
                                        }
                                    }
                                    if (li.getSubIntervalCount() != 1) continue;
                                    this.layoutModel.removeInterval(group, i6);
                                    LayoutInterval sub = this.layoutModel.removeInterval(li, 0);
                                    this.layoutModel.setIntervalAlignment(sub, li.getRawAlignment());
                                    this.layoutModel.addInterval(sub, group, i6);
                                    if (processLeading.contains(li)) {
                                        processLeading.intervals.remove(li);
                                        processLeading.intervals.add(sub);
                                    }
                                    if (processTrailing.contains(li)) {
                                        processTrailing.intervals.remove(li);
                                        processTrailing.intervals.add(sub);
                                    }
                                    if (!sub.isParallel()) continue;
                                    mayNeedSecondPass = true;
                                }
                                if (!validLeadingGapRemoved && !validTrailingGapRemoved) {
                                    return -1;
                                }
                                if ((resizingGapLeading || resizingGapTrailing) && (!LayoutInterval.canResize(group) || contentResizing)) {
                                    if (!subGroupLeading) {
                                        resizingGapLeading = false;
                                    }
                                    if (!subGroupTrailing) {
                                        resizingGapTrailing = false;
                                    }
                                    if (!contentResizing) {
                                        this.enableGroupResizing(group);
                                    }
                                }
                                groupOuterPos = group.getCurrentSpace().positions[dimension];
                                assert (groupOuterPos[0] > Short.MIN_VALUE && groupOuterPos[1] > Short.MIN_VALUE);
                                groupInnerPosLeading = processLeading.count() > 0 ? LayoutUtils.getPositionWithoutGap(processLeading.intervals, dimension, 0) : groupOuterPos[0];
                                groupInnerPosTrailing = processTrailing.count() > 0 ? LayoutUtils.getPositionWithoutGap(processTrailing.intervals, dimension, 1) : groupOuterPos[1];
                                leadingGap = null;
                                trailingGap = null;
                                if (!validLeadingGapRemoved) break block136;
                                if (anyAlignedLeading) break block137;
                                size2 = groupInnerPosLeading - groupOuterPos[0];
                                if (size2 <= 0 && !defaultLeadingPadding) break block138;
                                leadingGap = new LayoutInterval(101);
                                if (defaultLeadingPadding) {
                                    leadingGap.setPaddingType(leadingPadding);
                                } else if (effectiveExplicitGapLeading) {
                                    leadingGap.setPreferredSize(size2);
                                    if (resizingGapLeading) {
                                        if (size2 < 0 || commonGapLeadingSize < 0 || commonGapLeadingSize <= size2) {
                                            leadingGap.setMinimumSize(commonGapLeadingSize);
                                        }
                                    } else if (size2 != -1) {
                                        leadingGap.setMinimumSize(-2);
                                        leadingGap.setMaximumSize(-2);
                                    }
                                }
                                if (resizingGapLeading) {
                                    leadingGap.setMaximumSize(Short.MAX_VALUE);
                                }
                                leadingGap.setAttribute(1024);
                                break block136;
                            }
                            if (size2 != 0) break block136;
                            leadingGap = zeroGapLeading;
                            break block136;
                        }
                        leadingGap = new LayoutInterval(101);
                        leadingGap.setSize(commonGapLeadingSize);
                        if (commonGapLeadingSize == -1) {
                            leadingGap.setPaddingType(leadingPadding);
                        }
                        if (!reduceToZeroGapsLeading.isEmpty()) {
                            int sizeDiff = groupInnerPosLeading - groupOuterPos[0];
                            for (LayoutInterval gap : reduceToZeroGapsLeading) {
                                gapSize = gap.getPreferredSize() - sizeDiff;
                                if (gapSize < 0) {
                                    gapSize = 0;
                                }
                                this.layoutModel.setIntervalSize(gap, 0, gapSize, Short.MAX_VALUE);
                            }
                        }
                    }
                    if (!validTrailingGapRemoved) break block139;
                    if (anyAlignedTrailing) break block140;
                    size = groupOuterPos[1] - groupInnerPosTrailing;
                    if (size <= 0 && !defaultTrailingPadding) break block141;
                    trailingGap = new LayoutInterval(101);
                    if (defaultTrailingPadding) {
                        trailingGap.setPaddingType(trailingPadding);
                    } else if (effectiveExplicitGapTrailing) {
                        trailingGap.setPreferredSize(size);
                        if (resizingGapTrailing) {
                            if (size < 0 || commonGapTrailingSize < 0 || commonGapTrailingSize <= size) {
                                trailingGap.setMinimumSize(commonGapTrailingSize);
                            }
                        } else if (size != -1) {
                            trailingGap.setMinimumSize(-2);
                            trailingGap.setMaximumSize(-2);
                        }
                    }
                    if (resizingGapTrailing) {
                        trailingGap.setMaximumSize(Short.MAX_VALUE);
                    }
                    trailingGap.setAttribute(1024);
                    break block139;
                }
                if (size != 0) break block139;
                trailingGap = zeroGapTrailing;
                break block139;
            }
            trailingGap = new LayoutInterval(101);
            trailingGap.setSize(commonGapTrailingSize);
            if (commonGapTrailingSize == -1) {
                trailingGap.setPaddingType(trailingPadding);
            }
            if (!reduceToZeroGapsTrailing.isEmpty()) {
                int sizeDiff = groupOuterPos[1] - groupInnerPosTrailing;
                for (LayoutInterval gap : reduceToZeroGapsTrailing) {
                    gapSize = gap.getPreferredSize() - sizeDiff;
                    if (gapSize < 0) {
                        gapSize = 0;
                    }
                    this.layoutModel.setIntervalSize(gap, 0, gapSize, Short.MAX_VALUE);
                }
            }
        }
        if (leadingGap != null && subGroupLeading || trailingGap != null && subGroupTrailing) {
            LayoutInterval subGroup = new LayoutInterval(103);
            subGroup.setGroupAlignment(group.getGroupAlignment());
            int commonAlignment = -1;
            int i = 0;
            while (i < group.getSubIntervalCount()) {
                LayoutInterval li = group.getSubInterval(i);
                if (subGroupLeading && processLeading.contains(li) || subGroupTrailing && processTrailing.contains(li)) {
                    int align = li.getAlignment();
                    if (commonAlignment == -1) {
                        commonAlignment = align;
                    } else if (align != commonAlignment) {
                        commonAlignment = Integer.MAX_VALUE;
                    }
                    this.layoutModel.removeInterval(group, i);
                    this.layoutModel.addInterval(li, subGroup, -1);
                    continue;
                }
                ++i;
            }
            LayoutInterval seq = new LayoutInterval(102);
            if (subGroupLeading && leadingGap != null) {
                this.layoutModel.addInterval(leadingGap, seq, -1);
                leadingGap = null;
            }
            seq.add(subGroup, -1);
            if (subGroupTrailing && trailingGap != null) {
                this.layoutModel.addInterval(trailingGap, seq, -1);
                trailingGap = null;
            }
            this.layoutModel.addInterval(seq, group, -1);
            if (commonAlignment != Integer.MAX_VALUE && seq.getAlignment() != commonAlignment) {
                seq.setAlignment(commonAlignment);
            }
            int[] pos = subGroup.getCurrentSpace().positions[dimension];
            pos[0] = groupInnerPosLeading;
            pos[1] = groupInnerPosTrailing;
            pos[2] = (groupInnerPosLeading + groupInnerPosTrailing) / 2;
        }
        boolean someGapOutsideGroup = leadingGap != null || trailingGap != null;
        boolean bl = originalRootGroup = group.getParent() == null;
        if (someGapOutsideGroup && !originalRootGroup) {
            if (leadingGap != null) {
                groupOuterPos[0] = groupInnerPosLeading;
            }
            if (trailingGap != null) {
                groupOuterPos[1] = groupInnerPosTrailing;
            }
            groupOuterPos[2] = (groupOuterPos[0] + groupOuterPos[1]) / 2;
        }
        if (leadingGap != null) {
            group = this.insertGap(leadingGap, group, groupInnerPosLeading, dimension, 0);
        }
        if (trailingGap != null) {
            group = this.insertGap(trailingGap, group, groupInnerPosTrailing, dimension, 1);
        }
        if (someGapOutsideGroup && originalRootGroup && group.getParent() != null) {
            group.getCurrentSpace().set(dimension, groupInnerPosLeading, groupInnerPosTrailing);
        }
        int n = idx = someGapOutsideGroup && group.getParent() != null ? group.getParent().indexOf(group) : -1;
        if (mayNeedSecondPass) {
            int count = group.getSubIntervalCount();
            this.mergeParallelGroups(group);
            if (group.getSubIntervalCount() > count) {
                idx = this.optimizeGaps(group, dimension);
            }
        }
        return idx;
    }

    private static IntervalSet[] countAlignedVariants(IntervalSet[] alignedGaps, IntervalSet[] unalignedFixedGaps, IntervalSet[] unalignedResGaps) {
        LayoutInterval gap;
        int gapSize;
        int a;
        IntervalSet[] sets = new IntervalSet[2];
        int[] alignedGapSizes = new int[2];
        for (a = 0; a <= 1; ++a) {
            gapSize = Integer.MIN_VALUE;
            for (LayoutInterval layoutInterval : alignedGaps[a].intervals()) {
                gap = layoutInterval.getSubInterval(a == 0 ? 0 : layoutInterval.getSubIntervalCount() - 1);
                if (gapSize == Integer.MIN_VALUE) {
                    gapSize = gap.getPreferredSize();
                    continue;
                }
                if (gap.getPreferredSize() == gapSize) continue;
                gapSize = Integer.MIN_VALUE;
                break;
            }
            IntervalSet iSet = new IntervalSet();
            if (gapSize != Integer.MIN_VALUE) {
                iSet.add(alignedGaps[a]);
                for (LayoutInterval li2 : unalignedFixedGaps[a].intervals()) {
                    LayoutInterval gap2 = li2.getSubInterval(a == 0 ? 0 : li2.getSubIntervalCount() - 1);
                    if (gap2.getPreferredSize() != gapSize) continue;
                    iSet.add(li2, false);
                }
            }
            alignedGapSizes[a] = gapSize;
            sets[a] = iSet;
        }
        for (a = 0; a <= 1; ++a) {
            gapSize = alignedGapSizes[a];
            if (gapSize == Integer.MIN_VALUE || !sets[a].resizing) continue;
            for (LayoutInterval layoutInterval : unalignedResGaps[a].intervals()) {
                gap = layoutInterval.getSubInterval(a == 0 ? 0 : layoutInterval.getSubIntervalCount() - 1);
                int minSize = gap.getMinimumSize();
                if (minSize == -2) {
                    minSize = gap.getPreferredSize();
                }
                if (minSize != gapSize) continue;
                boolean add = true;
                LayoutInterval otherGap = layoutInterval.getSubInterval(a == 0 ? layoutInterval.getSubIntervalCount() - 1 : 0);
                if (otherGap.isEmptySpace()) {
                    if (sets[a ^ 1].count() == 0 || sets[a ^ 1].count() == 1 && sets[a ^ 1].intervals.contains(layoutInterval)) {
                        add = false;
                    } else {
                        int otherMinSize = otherGap.getMinimumSize();
                        if (otherMinSize == -2) {
                            otherMinSize = otherGap.getPreferredSize();
                        }
                        if (otherMinSize != alignedGapSizes[a ^ 1]) {
                            add = false;
                        }
                    }
                }
                if (!add) continue;
                sets[a].add(layoutInterval, true);
            }
        }
        return sets;
    }

    private static IntervalSet[] countUnalignedVariants(IntervalSet[] unalignedFixedGaps, IntervalSet[] unalignedResGaps, IntervalSet[] unalignedNoGaps, int dimension) {
        IntervalSet[] sets = new IntervalSet[2];
        for (int a = 0; a <= 1; ++a) {
            LayoutInterval gap;
            IntervalSet zeroGaps = new IntervalSet();
            IntervalSet nonZeroGaps = new IntervalSet();
            for (LayoutInterval li : unalignedFixedGaps[a].intervals()) {
                gap = li.getSubInterval(a == 0 ? 0 : li.getSubIntervalCount() - 1);
                if (gap.getMinimumSize() == 0) {
                    zeroGaps.add(li, false);
                    continue;
                }
                nonZeroGaps.add(li, false);
            }
            for (LayoutInterval li : unalignedResGaps[a].intervals()) {
                gap = li.getSubInterval(a == 0 ? 0 : li.getSubIntervalCount() - 1);
                if (gap.getMinimumSize() == 0) {
                    zeroGaps.add(li, true);
                    continue;
                }
                nonZeroGaps.add(li, true);
            }
            IntervalSet iSet = new IntervalSet();
            iSet.add(nonZeroGaps.count() >= zeroGaps.count() ? nonZeroGaps : zeroGaps);
            if (unalignedNoGaps[a].count() > 0 && iSet.count() > 0) {
                boolean anyDefaultGap = false;
                for (LayoutInterval li : iSet.intervals()) {
                    LayoutInterval gap2 = li.getSubInterval(a == 0 ? 0 : li.getSubIntervalCount() - 1);
                    if (gap2.getPreferredSize() != -1 || !LayoutInterval.isPlacedAtBorder(li, dimension, a)) continue;
                    anyDefaultGap = true;
                    break;
                }
                if (!anyDefaultGap) {
                    iSet.add(unalignedNoGaps[a]);
                } else {
                    for (LayoutInterval li : unalignedNoGaps[a].intervals()) {
                        if (LayoutInterval.isPlacedAtBorder(li, dimension, a)) continue;
                        iSet.add(li, false);
                    }
                }
            }
            sets[a] = iSet;
        }
        return sets;
    }

    private boolean isEndingGapEffective(LayoutInterval seq, int dimension, int alignment) {
        int pos2;
        assert (seq.isSequential() && (alignment == 0 || alignment == 1));
        int idx = alignment == 0 ? 0 : seq.getSubIntervalCount() - 1;
        LayoutInterval gap = seq.getSubInterval(idx);
        assert (gap.isEmptySpace());
        int prefDistance = gap.getPreferredSize();
        if (LayoutInterval.canResize(gap) && prefDistance == -1 && gap.hasAttribute(512)) {
            return false;
        }
        if (LayoutInterval.isAlignedAtBorder(seq, alignment)) {
            return true;
        }
        int d = alignment == 0 ? 1 : -1;
        LayoutInterval neighbor = seq.getSubInterval(idx + d);
        if (prefDistance == -1) {
            prefDistance = LayoutUtils.getSizeOfDefaultGap(gap, this.visualMapper);
        }
        int pos1 = neighbor.getCurrentSpace().positions[dimension][alignment];
        LayoutInterval outerNeighbor = LayoutInterval.getNeighbor(gap, alignment, false, true, false);
        if (outerNeighbor != null) {
            if (outerNeighbor.isEmptySpace()) {
                if (seq.getParent() == null) {
                    return false;
                }
                pos2 = seq.getParent().getCurrentSpace().positions[dimension][alignment];
            } else {
                pos2 = outerNeighbor.getCurrentSpace().positions[dimension][alignment ^ 1];
            }
        } else {
            pos2 = LayoutInterval.getRoot((LayoutInterval)seq).getCurrentSpace().positions[dimension][alignment];
        }
        int currentDistance = (pos1 - pos2) * d;
        return currentDistance <= prefDistance;
    }

    private boolean isEndingGapUsable(LayoutInterval seq, int dimension, int alignment, boolean toBeProcessed, boolean groupResizing) {
        assert (seq.isSequential() && (alignment == 0 || alignment == 1));
        int idx = alignment == 0 ? 0 : seq.getSubIntervalCount() - 1;
        LayoutInterval gap = seq.getSubInterval(idx);
        if (gap.getPreferredSize() == -1) {
            LayoutInterval neighbor = LayoutInterval.getNeighbor(gap, alignment, false, true, false);
            if (neighbor != null) {
                if (!LayoutUtils.isDefaultGapValidForNeighbor(neighbor, alignment ^ 1)) {
                    return false;
                }
                if (!toBeProcessed) {
                    if (LayoutInterval.isAlignedAtBorder(seq, alignment)) {
                        LayoutInterval par = seq.getParent();
                        while (par.getParent() != null && par.getParent().isParallel()) {
                            par = par.getParent();
                        }
                        if (par != seq.getParent() && !LayoutInterval.isAlignedAtBorder(seq, par, alignment) && !LayoutInterval.isPlacedAtBorder(seq, par, dimension, alignment)) {
                            return false;
                        }
                    } else if (!LayoutInterval.canResize(gap) && groupResizing) {
                        this.setIntervalResizing(gap, true);
                    }
                }
            }
        } else if (gap.getPreferredSize() == 0) {
            if (!LayoutInterval.canResize(gap)) {
                return false;
            }
            for (int i = 0; i < seq.getSubIntervalCount(); ++i) {
                LayoutInterval sub = seq.getSubInterval(i);
                if (sub == gap || sub.isEmptySpace() || !LayoutInterval.wantResize(sub)) continue;
                return false;
            }
        }
        return true;
    }

    void optimizeGaps2(LayoutInterval group, int dimension) {
        LayoutInterval tGap;
        LayoutInterval lGroup = null;
        LayoutInterval tGroup = null;
        LayoutInterval lGap = LayoutInterval.getNeighbor(group, 0, false, true, false);
        if (lGap != null && lGap.isEmptySpace()) {
            lGroup = LayoutInterval.getDirectNeighbor(lGap, 1, true);
        }
        if ((tGap = LayoutInterval.getNeighbor(group, 1, false, true, false)) != null && tGap.isEmptySpace()) {
            tGroup = LayoutInterval.getDirectNeighbor(tGap, 0, true);
        }
        if (lGroup != null && lGroup == tGroup) {
            this.eliminateEndingGaps(lGroup, new LayoutInterval[]{lGap, tGap}, dimension);
        } else if (lGroup != null && (tGroup == null || tGroup.isParentOf(lGroup))) {
            this.eliminateEndingGaps(lGroup, new LayoutInterval[]{lGap, null}, dimension);
            if (tGroup != null) {
                lGap = LayoutInterval.getDirectNeighbor(tGroup, 0, false);
                if (lGap != null && !lGap.isEmptySpace()) {
                    lGap = null;
                }
                this.eliminateEndingGaps(tGroup, new LayoutInterval[]{lGap, tGap}, dimension);
            }
        } else if (tGroup != null) {
            assert (lGroup == null || lGroup.isParentOf(tGroup));
            this.eliminateEndingGaps(tGroup, new LayoutInterval[]{null, tGap}, dimension);
            if (lGroup != null) {
                tGap = LayoutInterval.getDirectNeighbor(lGroup, 1, false);
                if (tGap != null && !tGap.isEmptySpace()) {
                    tGap = null;
                }
                this.eliminateEndingGaps(lGroup, new LayoutInterval[]{lGap, tGap}, dimension);
            }
        }
    }

    void eliminateEndingGaps(LayoutInterval group, LayoutInterval[] outGaps, int dimension) {
        int idx;
        LayoutInterval outGap;
        int e;
        IntervalSet[] alignedGap = new IntervalSet[2];
        IntervalSet[] alignedNoGap = new IntervalSet[2];
        IntervalSet[] unalignedGap = new IntervalSet[2];
        int[] inPos = new int[2];
        int[] outPos = new int[2];
        for (int e2 = 0; e2 <= 1; ++e2) {
            alignedGap[e2] = new IntervalSet();
            alignedNoGap[e2] = new IntervalSet();
            unalignedGap[e2] = new IntervalSet();
            if (outGaps[e2] == null) continue;
            Iterator<LayoutInterval> it = group.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval li = it.next();
                this.determineEndings(li, dimension, e2, alignedGap[e2], alignedNoGap[e2], unalignedGap[e2]);
            }
            inPos[e2] = group.getCurrentSpace().positions[dimension][e2];
            outPos[e2] = LayoutUtils.getVisualPosition(outGaps[e2], dimension, e2);
        }
        boolean independentEdges = unalignedGap[0].count() > 0 && unalignedGap[1].count() > 0 && unalignedGap[0].count() + unalignedGap[1].count() == group.getSubIntervalCount();
        boolean[] edgeNotDefined = new boolean[2];
        boolean[] allGaps = new boolean[2];
        boolean[] allGapsToReduce = new boolean[2];
        for (int e3 = 0; e3 <= 1; ++e3) {
            if (outGaps[e3] == null) continue;
            edgeNotDefined[e3] = alignedNoGap[e3].count() == 0;
            allGaps[e3] = alignedGap[e3].count() + unalignedGap[e3].count() == group.getSubIntervalCount();
            allGapsToReduce[e3] = unalignedGap[e3].count() == group.getSubIntervalCount() || allGaps[e3] && !LayoutInterval.canResize(group);
        }
        boolean[] processEdge = new boolean[2];
        block3: for (int e4 = 0; e4 <= 1; ++e4) {
            if (outGaps[e4] == null) continue;
            if (!(!LayoutInterval.wantResize(outGaps[e4]) || LayoutInterval.canResize(group) || edgeNotDefined[e4] && allGaps[e4])) {
                processEdge[e4] = false;
                continue;
            }
            if (edgeNotDefined[e4]) {
                processEdge[e4] = alignedGap[e4].count() > 0 || unalignedGap[e4].count() > 0;
                continue;
            }
            if (unalignedGap[e4].count() <= 0 || !edgeNotDefined[e4 ^ 1] && unalignedGap[e4 ^ 1].count() != 0 && !independentEdges || LayoutInterval.wantResize(outGaps[e4]) && LayoutInterval.wantResize(group)) continue;
            for (LayoutInterval li : unalignedGap[e4].intervals) {
                LayoutInterval gap = li.getSubInterval(e4 == 0 ? 0 : li.getSubIntervalCount() - 1);
                if (gap.getMinimumSize() == 0 && gap.getMaximumSize() == Short.MAX_VALUE) continue;
                processEdge[e4] = true;
                continue block3;
            }
        }
        if (!processEdge[0] && !processEdge[1]) {
            return;
        }
        Collection[] processIntervals = new Collection[2];
        LayoutInterval[] newGroups = new LayoutInterval[2];
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            LayoutInterval li = group.getSubInterval(i);
            for (int e5 = 0; e5 <= 1; ++e5) {
                if (!processEdge[e5] || !alignedGap[e5].contains(li) && !unalignedGap[e5].contains(li)) continue;
                LayoutInterval newGroup = newGroups[e5];
                if (newGroup == null) {
                    if (!independentEdges && newGroups[e5 ^ 1] != group) {
                        newGroup = newGroups[e5 ^ 1];
                    }
                    if (newGroup == null) {
                        newGroup = allGaps[e5] ? group : new LayoutInterval(103);
                    }
                    newGroups[e5] = newGroup;
                }
                if (newGroup == group || processIntervals[e5 ^ 1] != null && processIntervals[e5 ^ 1].contains(li)) continue;
                if (processIntervals[e5] == null) {
                    processIntervals[e5] = new ArrayList(group.getSubIntervalCount());
                }
                processIntervals[e5].add(li);
            }
        }
        if (!independentEdges && processIntervals[0] != null && processIntervals[1] != null && processIntervals[0].size() + processIntervals[1].size() == group.getSubIntervalCount()) {
            newGroups[0] = newGroups[1] = group;
        } else {
            for (int e6 = 0; e6 <= 1; ++e6) {
                if (processIntervals[e6] == null) continue;
                for (LayoutInterval li : processIntervals[e6]) {
                    assert (li.getParent() == group);
                    this.layoutModel.removeInterval(li);
                    this.layoutModel.addInterval(li, newGroups[e6], -1);
                }
            }
        }
        LayoutInterval parentSeq = group.getParent();
        if (independentEdges && !allGaps[0] && !allGaps[1] && processEdge[0] && processEdge[1]) {
            assert (group.getSubIntervalCount() == 0);
            LayoutInterval superGroup = new LayoutInterval(103);
            superGroup.getCurrentSpace().set(dimension, outPos[0], outPos[1]);
            for (e = 0; e <= 1; ++e) {
                LayoutInterval sideGroup = newGroups[e];
                outGap = outGaps[e ^ 1];
                assert (sideGroup != null && sideGroup != group && outGap.getParent() == parentSeq);
                LayoutInterval seq = new LayoutInterval(102);
                this.layoutModel.removeInterval(outGap);
                if (superGroup.getParent() == null) {
                    idx = this.layoutModel.removeInterval(group);
                    this.layoutModel.addInterval(superGroup, parentSeq, idx);
                }
                if (e == 1) {
                    this.layoutModel.addInterval(outGap, seq, 0);
                    sideGroup.getCurrentSpace().set(dimension, inPos[0], outPos[1]);
                }
                this.layoutModel.addInterval(sideGroup, seq, -1);
                if (e == 0) {
                    this.layoutModel.addInterval(outGap, seq, -1);
                    sideGroup.getCurrentSpace().set(dimension, outPos[0], inPos[1]);
                }
                this.layoutModel.addInterval(seq, superGroup, -1);
            }
            for (e = 0; e <= 1; ++e) {
                if (newGroups[e].getSubIntervalCount() != 1) continue;
                this.dissolveRedundantGroup(newGroups[e]);
            }
        } else {
            LayoutInterval subSeq = null;
            for (e = 0; e <= 1; ++e) {
                LayoutInterval superGroup = newGroups[e];
                outGap = outGaps[e];
                if (superGroup == null) continue;
                if (superGroup != group) {
                    boolean groupAlreadyAdded;
                    assert (outGap.getParent() == parentSeq);
                    if (subSeq == null) {
                        subSeq = new LayoutInterval(102);
                        groupAlreadyAdded = false;
                    } else {
                        groupAlreadyAdded = true;
                    }
                    this.layoutModel.removeInterval(outGap);
                    if (e == 0) {
                        this.layoutModel.addInterval(outGap, subSeq, 0);
                    }
                    if (!groupAlreadyAdded) {
                        idx = this.layoutModel.removeInterval(group);
                        int subAlign = -1;
                        if (group.getSubIntervalCount() > 1) {
                            this.layoutModel.addInterval(group, subSeq, -1);
                        } else {
                            assert (group.getSubIntervalCount() == 1);
                            LayoutInterval li = group.getSubInterval(0);
                            subAlign = li.getAlignment();
                            this.layoutModel.removeInterval(li);
                            if (li.isSequential()) {
                                this.addContent(subSeq, li, 0);
                                subSeq = li;
                            } else {
                                this.addContent(li, subSeq, -1);
                            }
                        }
                        this.layoutModel.addInterval(subSeq, superGroup, -1);
                        if (subAlign != -1 && subSeq.getAlignment() != subAlign) {
                            subSeq.setAlignment(subAlign);
                        }
                        this.layoutModel.addInterval(superGroup, parentSeq, idx);
                        superGroup.getCurrentSpace().set(dimension, newGroups[0] != null ? outPos[0] : inPos[0], newGroups[1] != null ? outPos[1] : inPos[1]);
                    }
                    if (e != 1) continue;
                    this.layoutModel.addInterval(outGap, subSeq, -1);
                    continue;
                }
                if (allGapsToReduce[e]) {
                    group.getCurrentSpace().positions[dimension][e] = LayoutUtils.getOutermostComponent((LayoutInterval)group, (int)dimension, (int)e).getCurrentSpace().positions[dimension][e];
                    continue;
                }
                this.layoutModel.removeInterval(outGap);
                group.getCurrentSpace().positions[dimension][e] = outPos[e];
            }
        }
        if (parentSeq.getSubIntervalCount() == 1) {
            LayoutInterval superParent = parentSeq.getParent();
            this.dissolveRedundantGroup(parentSeq);
            for (e = 0; e <= 1; ++e) {
                if (newGroups[e] == null || newGroups[e].getParent() != null) continue;
                newGroups[e] = superParent;
            }
        }
        for (int e7 = 0; e7 <= 1; ++e7) {
            if (newGroups[e7] == null) continue;
            if (newGroups[e7] != group || !allGapsToReduce[e7]) {
                LayoutInterval gapCopy = LayoutInterval.cloneInterval(outGaps[e7], null);
                Iterator<LayoutInterval> it = newGroups[e7].getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval li = it.next();
                    if (!independentEdges && !alignedGap[e7].contains(li) && !unalignedGap[e7].contains(li)) continue;
                    this.extendWithGap(li, gapCopy, dimension, e7);
                }
                continue;
            }
            int reduceSize = (inPos[e7] - group.getCurrentSpace().positions[dimension][e7]) * (e7 == 0 ? -1 : 1);
            if (reduceSize < 0) continue;
            boolean gapsResizing = false;
            for (LayoutInterval gap : LayoutUtils.getSideSubIntervals(group, e7, false, true, true, false)) {
                boolean resizing;
                boolean bl = resizing = LayoutInterval.canResize(gap) && LayoutInterval.canResize(group);
                if (gap.getPreferredSize() == -1 || resizing || !LayoutInterval.isAlignedAtBorder(gap, LayoutInterval.getFirstParent(gap, 103), e7)) {
                    this.layoutModel.removeInterval(gap);
                } else {
                    int currentGapSize;
                    LayoutInterval neighbor = LayoutInterval.getNeighbor(gap, e7 ^ 1, true, false, true);
                    if (neighbor != null && (currentGapSize = (inPos[e7] - neighbor.getCurrentSpace().positions[dimension][e7]) * (e7 == 0 ? -1 : 1)) > 0) {
                        if (currentGapSize > reduceSize) {
                            this.resizeInterval(gap, currentGapSize - reduceSize);
                        } else {
                            this.layoutModel.removeInterval(gap);
                        }
                    }
                }
                if (!resizing) continue;
                gapsResizing = true;
            }
            if (gapsResizing && !LayoutInterval.canResize(outGaps[e7])) {
                this.setIntervalResizing(outGaps[e7], true);
            }
            int adjustedOutGapSize = (outPos[e7] - inPos[e7]) * (e7 == 0 ? -1 : 1) + reduceSize;
            this.resizeInterval(outGaps[e7], adjustedOutGapSize);
        }
    }

    private void determineEndings(LayoutInterval interval, int dimension, int alignment, IntervalSet alignedGap, IntervalSet alignedNoGap, IntervalSet unalignedGap) {
        boolean alignedFound = false;
        boolean gapFound = false;
        boolean onEdgeWithoutGapFound = false;
        LinkedList<LayoutInterval> list = new LinkedList<LayoutInterval>();
        list.add(interval);
        while (!list.isEmpty()) {
            int borderPos;
            LayoutInterval sub;
            int i;
            LayoutInterval li = (LayoutInterval)list.remove(0);
            if (li.isSequential()) {
                for (i = 0; i < li.getSubIntervalCount(); ++i) {
                    boolean edge;
                    sub = li.getSubInterval(i);
                    boolean bl = edge = alignment == 0 && i == 0 || alignment == 1 && i == li.getSubIntervalCount() - 1;
                    if (edge) {
                        if (!(!LayoutInterval.isAlignedAtBorder(sub, interval.getParent(), alignment) || sub.isEmptySpace() && LayoutInterval.wantResize(sub))) {
                            alignedFound = true;
                        }
                        if (sub.isEmptySpace()) {
                            gapFound = true;
                        } else {
                            list.add(sub);
                        }
                    }
                    if (edge && sub.isEmptySpace() || alignedFound || !LayoutInterval.wantResizeInParent(sub, interval)) continue;
                    alignedFound = true;
                }
                continue;
            }
            if (li == interval && li.getAlignment() == alignment) {
                alignedFound = true;
            }
            if (li.isParallel()) {
                for (i = 0; i < li.getSubIntervalCount(); ++i) {
                    sub = li.getSubInterval(i);
                    list.add(sub);
                }
                continue;
            }
            if (!alignedFound && LayoutInterval.wantResizeInParent(li, li == interval ? interval.getParent() : interval)) {
                alignedFound = true;
            }
            if (li.isEmptySpace() || li.getCurrentSpace().positions[dimension][alignment] != (borderPos = LayoutInterval.getFirstParent((LayoutInterval)li, (int)103).getCurrentSpace().positions[dimension][alignment])) continue;
            onEdgeWithoutGapFound = true;
        }
        if (alignedFound) {
            if (gapFound && !onEdgeWithoutGapFound) {
                alignedGap.add(interval, LayoutInterval.wantResize(interval));
            } else {
                alignedNoGap.add(interval, LayoutInterval.wantResize(interval));
            }
        } else if (gapFound && !onEdgeWithoutGapFound) {
            unalignedGap.add(interval, LayoutInterval.wantResize(interval));
        }
    }

    private void extendWithGap(LayoutInterval interval, LayoutInterval gap, int dimension, int alignment) {
        LinkedList<LayoutInterval> list = new LinkedList<LayoutInterval>();
        list.add(interval);
        while (!list.isEmpty()) {
            LayoutInterval sub;
            int i;
            LayoutInterval li = (LayoutInterval)list.remove(0);
            if (li.isSequential()) {
                i = alignment == 0 ? 0 : li.getSubIntervalCount() - 1;
                sub = li.getSubInterval(i);
                if (sub.isEmptySpace()) {
                    int d = alignment == 0 ? 1 : -1;
                    int gapSize = (li.getSubInterval((int)(i + d)).getCurrentSpace().positions[dimension][alignment] - interval.getParent().getCurrentSpace().positions[dimension][alignment]) * d;
                    this.eatGap(sub, gap, gapSize);
                    continue;
                }
                list.add(sub);
                continue;
            }
            if (!li.isParallel()) continue;
            for (i = 0; i < li.getSubIntervalCount(); ++i) {
                sub = li.getSubInterval(i);
                list.add(sub);
            }
        }
    }

    boolean cutStartingGap(LayoutInterval group, int size, int dimension, int alignment) {
        LayoutInterval li;
        assert (group.isGroup() && size > 0 && (alignment == 0 || alignment == 1));
        LayoutInterval seq = null;
        if (group.isSequential()) {
            seq = group;
        } else if (group.getSubIntervalCount() == 1 && (li = group.getSubInterval(0)).isSequential() && LayoutInterval.isAlignedAtBorder(li, alignment)) {
            seq = li;
        }
        if (seq != null && seq.getSubIntervalCount() > 1) {
            LayoutInterval gap = seq.getSubInterval(alignment == 0 ? 0 : seq.getSubIntervalCount() - 1);
            LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(gap, alignment ^ 1, true);
            if (gap != null && gap.isEmptySpace() && neighbor != null) {
                int currentSize = gap.getPreferredSize();
                if (currentSize == -1) {
                    currentSize = LayoutRegion.distance(group.getCurrentSpace(), neighbor.getCurrentSpace(), dimension, alignment, alignment) * (alignment == 1 ? -1 : 1);
                }
                if (currentSize >= size) {
                    if (currentSize > size) {
                        this.resizeInterval(gap, currentSize - size);
                    } else {
                        this.layoutModel.removeInterval(gap);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    LayoutInterval insertGap(LayoutInterval gap, LayoutInterval interval, int pos, int dimension, int alignment) {
        LayoutInterval seq;
        LayoutInterval parent;
        assert (alignment == 0 || alignment == 1);
        assert (gap.isEmptySpace());
        boolean parentPos = false;
        if (interval.isSequential() && (interval = interval.getSubInterval(alignment == 0 ? 0 : interval.getSubIntervalCount() - 1)).isEmptySpace()) {
            interval = LayoutInterval.getDirectNeighbor(interval, alignment ^ 1, true);
            parentPos = true;
        }
        if ((parent = interval.getParent()) == null) {
            assert (interval.isParallel());
            parent = interval;
            if (parent.getSubIntervalCount() > 1) {
                seq = new LayoutInterval(102);
                seq.getCurrentSpace().set(dimension, alignment == 0 || LayoutInterval.canResize(gap) ? pos : interval.getCurrentSpace().positions[dimension][0], alignment == 0 || LayoutInterval.canResize(gap) ? interval.getCurrentSpace().positions[dimension][1] : pos);
                this.layoutModel.addInterval(seq, parent, -1);
                interval = new LayoutInterval(103);
                interval.getCurrentSpace().set(dimension, parent.getCurrentSpace());
                this.layoutModel.addInterval(interval, seq, 0);
                while (parent.getSubIntervalCount() > 1) {
                    this.layoutModel.addInterval(this.layoutModel.removeInterval(parent, 0), interval, -1);
                }
                parent = seq;
            } else {
                interval = parent.getSubInterval(0);
                if (interval.isSequential()) {
                    parent = interval;
                    int subIdx = alignment == 0 ? 0 : parent.getSubIntervalCount() - 1;
                    if ((interval = parent.getSubInterval(subIdx)).isEmptySpace()) {
                        LayoutInterval neighbor = (subIdx += alignment == 0 ? 1 : -1) >= 0 && subIdx < parent.getSubIntervalCount() ? parent.getSubInterval(subIdx) : null;
                        int[] outerSpace = parent.getParent().getCurrentSpace().positions[dimension];
                        int otherPos = neighbor != null ? neighbor.getCurrentSpace().positions[dimension][alignment] : outerSpace[alignment ^ 1];
                        int mergedSize = (outerSpace[alignment] - otherPos) * (alignment == 0 ? -1 : 1);
                        this.eatGap(interval, gap, mergedSize);
                        return neighbor != null ? neighbor : interval;
                    }
                } else {
                    seq = new LayoutInterval(102);
                    seq.getCurrentSpace().set(dimension, alignment == 0 ? pos : interval.getCurrentSpace().positions[dimension][0], alignment == 0 ? interval.getCurrentSpace().positions[dimension][1] : pos);
                    this.layoutModel.addInterval(seq, parent, -1);
                    this.layoutModel.removeInterval(interval);
                    this.layoutModel.addInterval(interval, seq, -1);
                    parent = seq;
                }
            }
        }
        if (parent.isSequential()) {
            LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false);
            if (neighbor != null && neighbor.isEmptySpace()) {
                LayoutInterval next = LayoutInterval.getDirectNeighbor(neighbor, alignment, false);
                int mergedSize = next != null ? pos - next.getCurrentSpace().positions[dimension][alignment ^ 1] : (!parentPos ? pos - parent.getCurrentSpace().positions[dimension][alignment] : interval.getCurrentSpace().positions[dimension][alignment] - pos);
                if (alignment == 1) {
                    mergedSize = -mergedSize;
                }
                this.eatGap(neighbor, gap, mergedSize);
            } else {
                int idx = parent.indexOf(interval) + (alignment == 0 ? 0 : 1);
                this.layoutModel.addInterval(gap, parent, idx);
            }
        } else {
            seq = new LayoutInterval(102);
            int idx = this.layoutModel.removeInterval(interval);
            seq.setAlignment(interval.getAlignment());
            seq.getCurrentSpace().set(dimension, alignment == 0 ? pos : interval.getCurrentSpace().positions[dimension][0], alignment == 0 ? interval.getCurrentSpace().positions[dimension][1] : pos);
            this.layoutModel.addInterval(seq, parent, idx);
            this.layoutModel.setIntervalAlignment(interval, -1);
            this.layoutModel.addInterval(interval, seq, 0);
            this.layoutModel.addInterval(gap, seq, alignment == 0 ? 0 : 1);
        }
        return interval;
    }

    int insertGapIntoSequence(LayoutInterval gap, LayoutInterval seq, int index, int dimension) {
        assert (gap.isEmptySpace());
        LayoutInterval otherGap = null;
        int alignment = -1;
        if (index >= 0 && index < seq.getSubIntervalCount() && (otherGap = seq.getSubInterval(index)).isEmptySpace()) {
            alignment = 1;
        }
        if (alignment == -1 && index > 0 && (otherGap = seq.getSubInterval(index - 1)).isEmptySpace()) {
            alignment = 0;
        }
        if (alignment == -1) {
            this.layoutModel.addInterval(gap, seq, index);
            return index;
        }
        LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(otherGap, alignment, true);
        int pos1 = neighbor != null ? neighbor.getCurrentSpace().positions[dimension][alignment ^ 1] : seq.getCurrentSpace().positions[dimension][alignment];
        neighbor = LayoutInterval.getDirectNeighbor(otherGap, alignment ^ 1, true);
        int pos2 = neighbor != null ? neighbor.getCurrentSpace().positions[dimension][alignment] : seq.getCurrentSpace().positions[dimension][alignment ^ 1];
        this.eatGap(otherGap, gap, Math.abs(pos2 - pos1));
        return alignment == 0 ? index - 1 : index;
    }

    boolean mergeConsecutiveGaps(LayoutInterval seq, int index, int dimension) {
        LayoutInterval next;
        assert (seq.isSequential());
        if (index < 0 || index >= seq.getSubIntervalCount()) {
            return false;
        }
        LayoutInterval current = seq.getSubInterval(index);
        LayoutInterval layoutInterval = next = index + 1 < seq.getSubIntervalCount() ? seq.getSubInterval(index + 1) : null;
        if (next != null && current.isEmptySpace() && next.isEmptySpace()) {
            LayoutRegion tr;
            int ta;
            LayoutRegion lr;
            int la;
            if (index > 0) {
                la = 1;
                lr = seq.getSubInterval(index - 1).getCurrentSpace();
            } else {
                la = 0;
                lr = seq.getCurrentSpace();
            }
            if (index + 2 < seq.getSubIntervalCount()) {
                ta = 0;
                tr = seq.getSubInterval(index + 2).getCurrentSpace();
            } else {
                ta = 1;
                tr = seq.getCurrentSpace();
            }
            this.eatGap(current, next, LayoutRegion.distance(lr, tr, dimension, la, ta));
            return true;
        }
        return false;
    }

    void eatGap(LayoutInterval main, LayoutInterval eaten, int currentMergedSize) {
        int pref;
        int min2;
        int pref1 = main.getPreferredSize();
        int pref2 = eaten.getPreferredSize();
        int min1 = main.getMinimumSize();
        if (min1 == -2) {
            min1 = pref1;
        }
        if ((min2 = eaten.getMinimumSize()) == -2) {
            min2 = pref2;
        }
        int min = !LayoutInterval.canResize(main) && !LayoutInterval.canResize(eaten) ? -2 : (min1 == -1 || min2 == -1 ? -1 : (min1 == 0 ? min1 : min1 + min2));
        if (pref1 == 0) {
            pref = pref2;
        } else if (pref2 == 0) {
            pref = pref1;
        } else if (pref1 == -1 || pref2 == -1) {
            pref = currentMergedSize;
            if (pref == -1) {
                if (pref1 > 0) {
                    pref = pref1;
                } else if (pref2 > 0) {
                    pref = pref2;
                }
            }
        } else {
            pref = currentMergedSize < 0 || LayoutInterval.getDirectNeighbor(main, 0, false) == null || LayoutInterval.getDirectNeighbor(eaten, 1, false) == null || LayoutInterval.getDirectNeighbor(main, 1, false) == null || LayoutInterval.getDirectNeighbor(eaten, 0, false) == null ? pref1 + pref2 : currentMergedSize;
        }
        int max = main.getMaximumSize() >= Short.MAX_VALUE || eaten.getMaximumSize() >= Short.MAX_VALUE ? Short.MAX_VALUE : -2;
        this.layoutModel.setIntervalSize(main, min, pref, max);
        if (eaten.getParent() != null) {
            this.layoutModel.removeInterval(eaten);
        }
    }

    boolean fixSurplusOrMissingGaps(LayoutInterval group, int dimension) {
        assert (group.isGroup());
        boolean updated = false;
        if (group.isSequential()) {
            LayoutInterval prev = null;
            for (int i = 0; i < group.getSubIntervalCount(); ++i) {
                LayoutInterval interval = group.getSubInterval(i);
                if (interval.isEmptySpace()) {
                    if (prev != null && prev.isEmptySpace()) {
                        this.eatGap(prev, interval, -1);
                        interval = group.getSubInterval(--i);
                        updated = true;
                    } else if (i > 0 && i + 1 < group.getSubIntervalCount() && interval.getPreferredSize() == -1 && !LayoutInterval.canResize(interval)) {
                        boolean removeInvalid;
                        if (!LayoutUtils.isDefaultGapValidForNeighbor(group.getSubInterval(i - 1), 1)) {
                            removeInvalid = true;
                        } else {
                            LayoutInterval neighbor = group.getSubInterval(i + 1);
                            boolean bl = removeInvalid = !neighbor.isEmptySpace() && !LayoutUtils.isDefaultGapValidForNeighbor(neighbor, 0);
                        }
                        if (removeInvalid) {
                            this.layoutModel.removeInterval(group, i);
                            interval = group.getSubInterval(--i);
                            updated = true;
                        }
                    }
                    if (interval.getPreferredSize() == 0 && interval.getMinimumSize() == -1) {
                        this.layoutModel.setIntervalSize(interval, -1, -1, interval.getMaximumSize());
                    }
                } else if (prev != null && prev.isComponent() && interval.isComponent()) {
                    LayoutInterval dummyGap = new LayoutInterval(101);
                    dummyGap.setSize(0);
                    this.layoutModel.addInterval(dummyGap, group, i);
                    ++i;
                    updated = true;
                }
                prev = interval;
            }
        }
        Iterator<LayoutInterval> iter = group.getSubIntervals();
        while (iter.hasNext()) {
            LayoutInterval subInterval = iter.next();
            if (!subInterval.isGroup()) continue;
            updated |= this.fixSurplusOrMissingGaps(subInterval, dimension);
        }
        return updated;
    }

    void suppressResizingOfSurroundingGaps(LayoutInterval interval) {
        LayoutInterval parent = interval.getParent();
        while (parent != null) {
            if (parent.isSequential()) {
                Iterator<LayoutInterval> it = parent.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval sub = it.next();
                    if (sub == interval || !sub.isEmptySpace() || !LayoutInterval.canResize(sub)) continue;
                    int pref = sub.getPreferredSize();
                    int min = sub.getMinimumSize() != pref ? -2 : pref;
                    int max = -2;
                    this.layoutModel.setIntervalSize(sub, min, pref, max);
                }
            } else if (!LayoutInterval.canResize(parent)) break;
            interval = parent;
            parent = interval.getParent();
        }
    }

    void accommodateGap(LayoutInterval gap, int dimension) {
        assert (gap.isEmptySpace());
        LayoutInterval parent = gap.getParent();
        if (parent.isSequential()) {
            int size;
            int pos2;
            int pos1;
            LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(gap, 0, true);
            if (neighbor != null) {
                pos1 = neighbor.getCurrentSpace().positions[dimension][1];
            } else {
                pos1 = parent.getCurrentSpace().positions[dimension][0];
                if (!LayoutRegion.isValidCoordinate(pos1) && parent.getParent() != null) {
                    pos1 = parent.getParent().getCurrentSpace().positions[dimension][0];
                }
            }
            neighbor = LayoutInterval.getDirectNeighbor(gap, 1, true);
            if (neighbor != null) {
                pos2 = neighbor.getCurrentSpace().positions[dimension][0];
            } else {
                pos2 = parent.getCurrentSpace().positions[dimension][1];
                if (!LayoutRegion.isValidCoordinate(pos1) && parent.getParent() != null) {
                    pos1 = parent.getParent().getCurrentSpace().positions[dimension][1];
                }
            }
            if (LayoutRegion.isValidCoordinate(pos1) && LayoutRegion.isValidCoordinate(pos2) && (size = pos2 - pos1) > 0 && (gap.getPreferredSize() != -1 || LayoutUtils.getSizeOfDefaultGap(gap, this.visualMapper) != size)) {
                this.resizeInterval(gap, size);
            }
        }
    }

    boolean eliminateUnwantedZeroGap(LayoutInterval gap) {
        if (gap != null && gap.isEmptySpace() && gap.getPreferredSize() == 0 && !LayoutInterval.canResize(gap) && gap.getParent() != null) {
            boolean eliminate = false;
            if (gap.getParent().isParallel()) {
                eliminate = true;
            } else {
                for (int e = 0; e <= 1; ++e) {
                    LayoutInterval neighbor = LayoutInterval.getNeighbor(gap, e, false, true, true);
                    if (neighbor == null || LayoutUtils.hasSideComponents(neighbor, e ^ 1, true, true)) continue;
                    eliminate = true;
                    break;
                }
            }
            if (eliminate) {
                this.layoutModel.removeInterval(gap);
                return true;
            }
        }
        return false;
    }

    LayoutInterval maintainSize(LayoutInterval group, boolean wasResizing, int dimension, boolean optimize) {
        return this.maintainSize(group, wasResizing, dimension, null, 0, optimize);
    }

    LayoutInterval maintainSize(LayoutInterval group, boolean wasResizing, int dimension, LayoutInterval excluded, int excludedSize, boolean optimize) {
        int min;
        assert (group.isParallel());
        int groupSize = group.getCurrentSpace().size(dimension);
        int[] groupPos = group.getCurrentSpace().positions[dimension];
        boolean allSameAlignment = true;
        int alignment = -1;
        int leadCompPos = Integer.MAX_VALUE;
        int trailCompPos = Integer.MIN_VALUE;
        int maxSubSize = Integer.MIN_VALUE;
        LayoutInterval biggest = null;
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            if (LayoutInterval.wantResize(li)) {
                return null;
            }
            int align = li.getAlignment();
            int l = Integer.MIN_VALUE;
            int t = Integer.MIN_VALUE;
            if (li != excluded) {
                int size = li.getCurrentSpace().size(dimension);
                if (size > groupSize) {
                    size = groupSize;
                }
                if (size > maxSubSize) {
                    maxSubSize = size;
                    biggest = li;
                }
            } else {
                if (excludedSize > maxSubSize) {
                    maxSubSize = excludedSize;
                }
                if (align == 0) {
                    l = groupPos[0];
                    t = groupPos[0] + excludedSize;
                } else if (align == 1) {
                    l = groupPos[1] - excludedSize;
                    t = groupPos[1];
                }
            }
            if (l == Integer.MIN_VALUE) {
                l = LayoutUtils.getOutermostComponent((LayoutInterval)li, (int)dimension, (int)0).getCurrentSpace().positions[dimension][0];
            }
            if (t == Integer.MIN_VALUE) {
                t = LayoutUtils.getOutermostComponent((LayoutInterval)li, (int)dimension, (int)1).getCurrentSpace().positions[dimension][1];
            }
            if (l < leadCompPos) {
                leadCompPos = l;
            }
            if (t > trailCompPos) {
                trailCompPos = t;
            }
            if (!allSameAlignment) continue;
            if (alignment == -1) {
                alignment = align;
                continue;
            }
            if (alignment == align) continue;
            allSameAlignment = false;
        }
        if (maxSubSize == groupSize) {
            if (!wasResizing) {
                return null;
            }
            LayoutInterval seqRoot = LayoutInterval.getRoot(group, 102);
            if (seqRoot != null && LayoutInterval.wantResize(seqRoot)) {
                return null;
            }
        }
        LayoutInterval parent = group.getParent();
        if (allSameAlignment && parent != null) {
            if (alignment != 0 && alignment != 1) {
                int n = alignment = groupPos[1] - trailCompPos >= leadCompPos - groupPos[0] ? 0 : 1;
            }
            if (alignment == 0) {
                groupPos[1] = trailCompPos;
            } else {
                groupPos[0] = leadCompPos;
            }
            groupPos[2] = (groupPos[0] + groupPos[0]) / 2;
            if (!LayoutInterval.canResize(group)) {
                wasResizing = false;
                this.enableGroupResizing(group);
            }
            if (parent.isParallel() && group.getAlignment() == alignment) {
                group = this.maintainSize(parent, wasResizing, dimension, group, maxSubSize, optimize);
            } else {
                int max;
                boolean border;
                if (parent.isParallel()) {
                    border = true;
                } else {
                    int idx = parent.indexOf(group);
                    boolean bl = border = alignment == 0 && idx == parent.getSubIntervalCount() - 1 || alignment == 1 && idx == 0;
                }
                if (wasResizing) {
                    min = -1;
                    max = Short.MAX_VALUE;
                } else {
                    max = -2;
                    min = -2;
                }
                LayoutInterval gap = new LayoutInterval(101);
                gap.setSizes(min, groupSize - maxSubSize, max);
                this.insertGap(gap, group, alignment == 0 ? trailCompPos : leadCompPos, dimension, alignment ^ 1);
                if (parent.isSequential()) {
                    parent = parent.getParent();
                }
                if (border && optimize) {
                    this.optimizeGaps(parent, dimension);
                    this.optimizeGaps2(parent, dimension);
                }
            }
        } else {
            int pref;
            LayoutInterval ext;
            if (excluded != null) {
                ext = excluded;
                pref = groupSize - excludedSize;
            } else {
                ext = biggest;
                pref = groupSize - maxSubSize;
            }
            alignment = ext.getAlignment();
            if (alignment == 0 || alignment == 1) {
                int max;
                if (wasResizing) {
                    LayoutInterval outGap = LayoutInterval.getNeighbor(ext, alignment ^ 1, false, true, false);
                    min = outGap != null && outGap.isEmptySpace() ? 0 : -1;
                    max = Short.MAX_VALUE;
                } else {
                    max = -2;
                    min = -2;
                }
                LayoutInterval extGap = null;
                if (ext.isSequential()) {
                    extGap = ext.getSubInterval(alignment == 0 ? ext.getSubIntervalCount() - 1 : 0);
                    if (extGap.isEmptySpace()) {
                        if (min == 0 && extGap.getMinimumSize() != 0) {
                            min = -1;
                        } else if (min == -1 && extGap.getMinimumSize() == 0 && max == Short.MAX_VALUE) {
                            min = 0;
                        }
                        this.layoutModel.setIntervalSize(extGap, min, pref, max);
                    } else {
                        extGap = null;
                    }
                }
                if (extGap == null) {
                    extGap = new LayoutInterval(101);
                    extGap.setSizes(min, pref, max);
                    this.insertGap(extGap, ext, alignment == 0 ? groupPos[0] + maxSubSize : groupPos[1] - maxSubSize, dimension, alignment ^ 1);
                }
                if (optimize) {
                    this.optimizeGaps(group, dimension);
                }
            }
        }
        return group;
    }

    private static class IntervalSet {
        Set<LayoutInterval> intervals;
        boolean resizing;

        private IntervalSet() {
        }

        void add(LayoutInterval li, boolean res) {
            if (this.intervals == null) {
                this.intervals = new HashSet<LayoutInterval>();
            }
            this.intervals.add(li);
            if (res) {
                this.resizing = true;
            }
        }

        void add(IntervalSet is) {
            if (is.count() > 0) {
                if (this.intervals == null) {
                    this.intervals = new HashSet<LayoutInterval>();
                }
                this.intervals.addAll(is.intervals);
                if (is.resizing) {
                    this.resizing = true;
                }
            }
        }

        int count() {
            return this.intervals != null ? this.intervals.size() : 0;
        }

        Collection<LayoutInterval> intervals() {
            if (this.intervals != null) {
                return this.intervals;
            }
            return Collections.emptyList();
        }

        boolean contains(LayoutInterval interval) {
            return this.intervals != null ? this.intervals.contains(interval) : false;
        }

        void clear() {
            this.intervals = null;
            this.resizing = false;
        }
    }
}

