/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.vars;

import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.js.vars.DebuggerSupport;
import org.netbeans.modules.debugger.jpda.js.vars.JSExpression;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.Evaluator;

public class JSEvaluator
implements Evaluator<JSExpression> {
    private final JPDADebugger debugger;

    public JSEvaluator(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Evaluator.Result evaluate(Evaluator.Expression<JSExpression> expression, Evaluator.Context context) throws InvalidExpressionException {
        ObjectVariable contextVariable = context.getContextVariable();
        if (contextVariable != null && "toString()".equals(expression.getExpression())) {
            return new Evaluator.Result(DebuggerSupport.getVarStringValueAsVar(this.debugger, contextVariable));
        }
        JSExpression expr = (JSExpression)expression.getPreprocessedObject();
        if (expr == null) {
            expr = JSExpression.parse(expression.getExpression());
            expression.setPreprocessedObject((Object)expr);
        }
        Variable ret = this.evaluateIn(expr, context.getCallStackFrame(), contextVariable);
        return new Evaluator.Result(ret);
    }

    private Variable evaluateIn(JSExpression expr, CallStackFrame callStackFrame, ObjectVariable contextVar) throws InvalidExpressionException {
        return DebuggerSupport.evaluate(this.debugger, callStackFrame, expr.getExpression(), contextVar);
    }
}

