/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.config.WildflyDatasource;
import org.netbeans.modules.javaee.wildfly.config.ds.gen.DatasourceType;
import org.netbeans.modules.javaee.wildfly.config.ds.gen.Datasources;
import org.netbeans.modules.javaee.wildfly.config.ds.gen.DsSecurityType;
import org.netbeans.modules.javaee.wildfly.config.ds.gen.PoolType;
import org.netbeans.modules.javaee.wildfly.config.xml.ConfigurationParser;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class WildflyDatasourceManager
implements DatasourceManager {
    private static final Logger LOGGER = Logger.getLogger(WildflyDatasourceManager.class.getName());
    private static final String DSdotXML = "-ds.xml";
    private static final String JBossDSdotXML = "jboss-ds.xml";
    private final FileObject deployDir;
    private final FileObject configFile;
    private final WildflyDeploymentManager dm;

    public WildflyDatasourceManager(WildflyDeploymentManager dm) {
        File config;
        this.dm = dm;
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)dm.getUrl());
        String deployDirPath = ip.getProperty("deploy-dir");
        this.deployDir = FileUtil.toFileObject((File)new File(deployDirPath));
        String configFilePath = ip.getProperty("config_file");
        if (configFilePath != null) {
            config = new File(configFilePath);
            if (!config.exists()) {
                throw new IllegalArgumentException("No configuration file found: " + configFilePath);
            }
        } else {
            throw new IllegalArgumentException("No configuration file configured: " + dm);
        }
        this.configFile = FileUtil.toFileObject((File)config);
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        return ConfigurationParser.INSTANCE.listDatasources(this.configFile);
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
        Set<Datasource> deployedDS = this.getDatasources();
        Map<String, Datasource> ddsMap = this.transform(deployedDS);
        HashMap<String, WildflyDatasource> newDS = new HashMap<String, WildflyDatasource>();
        LinkedList<Datasource> conflictDS = new LinkedList<Datasource>();
        for (Datasource o : datasources) {
            if (!(o instanceof WildflyDatasource)) continue;
            WildflyDatasource ds = (WildflyDatasource)o;
            String jndiName = WildflyDatasource.getRawName(ds.getJndiName());
            if (ddsMap.containsKey(jndiName)) {
                if (ddsMap.get(jndiName).equals(ds)) continue;
                conflictDS.add(ddsMap.get(jndiName));
                continue;
            }
            if (jndiName == null) continue;
            newDS.put(jndiName, ds);
        }
        if (conflictDS.size() > 0) {
            throw new DatasourceAlreadyExistsException(conflictDS);
        }
        FileObject dsXmlFo = this.deployDir.getFileObject(JBossDSdotXML);
        File dsXMLFile = dsXmlFo != null ? FileUtil.toFile((FileObject)dsXmlFo) : null;
        Datasources deployedDSGraph = null;
        try {
            deployedDSGraph = dsXMLFile != null ? Datasources.createGraph(dsXMLFile) : new Datasources();
        }
        catch (IOException ioe) {
            Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(this.getClass(), (String)"ERR_CannotReadDSdotXml"));
            Logger.getLogger("global").log(Level.INFO, null, ioe);
            return;
        }
        DatasourceType[] ltxds = deployedDSGraph.getDatasource();
        for (int i = 0; i < ltxds.length; ++i) {
            String jndiName = ltxds[i].getJndiName();
            if (!newDS.containsKey(jndiName)) continue;
            deployedDSGraph.removeDatasource(ltxds[i]);
        }
        for (WildflyDatasource ds : newDS.values()) {
            DatasourceType lds = new DatasourceType();
            lds.setJndiName(WildflyDatasource.getRawName(ds.getJndiName()));
            lds.setConnectionUrl(ds.getUrl());
            lds.setDriverClass(ds.getDriverClassName());
            DsSecurityType security = new DsSecurityType();
            security.setUserName(ds.getUsername());
            security.setPassword(ds.getPassword());
            lds.setSecurity(security);
            PoolType pool = new PoolType();
            pool.setMinPoolSize(Long.parseLong(ds.getMinPoolSize()));
            pool.setMaxPoolSize(Long.parseLong(ds.getMaxPoolSize()));
            lds.setPool(pool);
            String poolName = ds.getJndiName();
            int index = ds.getJndiName().lastIndexOf(47);
            if (index > 0) {
                poolName = ds.getJndiName().substring(index);
            }
            lds.setPoolName(poolName);
            deployedDSGraph.addDatasource(lds);
        }
        if (newDS.size() > 0) {
            if (dsXMLFile == null) {
                try {
                    dsXmlFo = this.deployDir.createData(JBossDSdotXML);
                }
                catch (IOException ioe) {
                    Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(this.getClass(), (String)"ERR_CannotCreateDSdotXml"));
                    Logger.getLogger("global").log(Level.INFO, null, ioe);
                    return;
                }
                dsXMLFile = FileUtil.toFile((FileObject)dsXmlFo);
            }
            this.writeFile(dsXMLFile, deployedDSGraph);
        }
    }

    private Map<String, Datasource> transform(Set<Datasource> datasources) {
        HashMap<String, Datasource> map = new HashMap<String, Datasource>();
        for (WildflyDatasource wildflyDatasource : datasources) {
            if (wildflyDatasource.getJndiName() == null) continue;
            map.put(wildflyDatasource.getJndiName(), wildflyDatasource);
        }
        return map;
    }

    private void writeFile(final File file, final BaseBean bean) throws ConfigurationException {
        try {
            FileSystem fs = this.deployDir.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        String name = file.getName();
                        FileObject configFO = WildflyDatasourceManager.this.deployDir.getFileObject(name);
                        if (configFO == null) {
                            configFO = WildflyDatasourceManager.this.deployDir.createData(name);
                        }
                        lock = configFO.lock();
                        os = new BufferedOutputStream(configFO.getOutputStream(lock), 4096);
                        if (bean != null) {
                            bean.write(os);
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }
}

