/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerDepthInfoKHR;
import org.lwjgl.openxr.XrCompositionLayerSpaceWarpInfoFB;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerProjectionView
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int POSE;
    public static final int FOV;
    public static final int SUBIMAGE;

    public XrCompositionLayerProjectionView(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerProjectionView.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerProjectionView.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerProjectionView.nnext(this.address());
    }

    public XrPosef pose() {
        return XrCompositionLayerProjectionView.npose(this.address());
    }

    public XrFovf fov() {
        return XrCompositionLayerProjectionView.nfov(this.address());
    }

    public XrSwapchainSubImage subImage() {
        return XrCompositionLayerProjectionView.nsubImage(this.address());
    }

    public XrCompositionLayerProjectionView type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerProjectionView.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView type$Default() {
        return this.type(48);
    }

    public XrCompositionLayerProjectionView next(@NativeType(value="void const *") long value) {
        XrCompositionLayerProjectionView.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView next(XrCompositionLayerDepthInfoKHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerProjectionView next(XrCompositionLayerSpaceWarpInfoFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerProjectionView pose(XrPosef value) {
        XrCompositionLayerProjectionView.npose(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrCompositionLayerProjectionView fov(XrFovf value) {
        XrCompositionLayerProjectionView.nfov(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView fov(Consumer<XrFovf> consumer) {
        consumer.accept(this.fov());
        return this;
    }

    public XrCompositionLayerProjectionView subImage(XrSwapchainSubImage value) {
        XrCompositionLayerProjectionView.nsubImage(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView subImage(Consumer<XrSwapchainSubImage> consumer) {
        consumer.accept(this.subImage());
        return this;
    }

    public XrCompositionLayerProjectionView set(int type, long next, XrPosef pose, XrFovf fov, XrSwapchainSubImage subImage) {
        this.type(type);
        this.next(next);
        this.pose(pose);
        this.fov(fov);
        this.subImage(subImage);
        return this;
    }

    public XrCompositionLayerProjectionView set(XrCompositionLayerProjectionView src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerProjectionView malloc() {
        return (XrCompositionLayerProjectionView)XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrCompositionLayerProjectionView calloc() {
        return (XrCompositionLayerProjectionView)XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrCompositionLayerProjectionView create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrCompositionLayerProjectionView)XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrCompositionLayerProjectionView create(long address) {
        return (XrCompositionLayerProjectionView)XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, (long)address);
    }

    @Nullable
    public static XrCompositionLayerProjectionView createSafe(long address) {
        return address == 0L ? null : (XrCompositionLayerProjectionView)XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrCompositionLayerProjectionView.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrCompositionLayerProjectionView.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrCompositionLayerProjectionView.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerProjectionView.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrCompositionLayerProjectionView.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrCompositionLayerProjectionView.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrCompositionLayerProjectionView.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrCompositionLayerProjectionView malloc(MemoryStack stack) {
        return (XrCompositionLayerProjectionView)XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrCompositionLayerProjectionView calloc(MemoryStack stack) {
        return (XrCompositionLayerProjectionView)XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerProjectionView.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerProjectionView.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrFovf nfov(long struct) {
        return XrFovf.create(struct + (long)FOV);
    }

    public static XrSwapchainSubImage nsubImage(long struct) {
        return XrSwapchainSubImage.create(struct + (long)SUBIMAGE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void nfov(long struct, XrFovf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOV), (long)XrFovf.SIZEOF);
    }

    public static void nsubImage(long struct, XrSwapchainSubImage value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SUBIMAGE), (long)XrSwapchainSubImage.SIZEOF);
    }

    public static void validate(long struct) {
        XrSwapchainSubImage.validate(struct + (long)SUBIMAGE);
    }

    static {
        Struct.Layout layout = XrCompositionLayerProjectionView.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerProjectionView.__member((int)4), XrCompositionLayerProjectionView.__member((int)POINTER_SIZE), XrCompositionLayerProjectionView.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrCompositionLayerProjectionView.__member((int)XrFovf.SIZEOF, (int)XrFovf.ALIGNOF), XrCompositionLayerProjectionView.__member((int)XrSwapchainSubImage.SIZEOF, (int)XrSwapchainSubImage.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        POSE = layout.offsetof(2);
        FOV = layout.offsetof(3);
        SUBIMAGE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerProjectionView, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerProjectionView ELEMENT_FACTORY = XrCompositionLayerProjectionView.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCompositionLayerProjectionView getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerProjectionView.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerProjectionView.nnext(this.address());
        }

        public XrPosef pose() {
            return XrCompositionLayerProjectionView.npose(this.address());
        }

        public XrFovf fov() {
            return XrCompositionLayerProjectionView.nfov(this.address());
        }

        public XrSwapchainSubImage subImage() {
            return XrCompositionLayerProjectionView.nsubImage(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerProjectionView.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(48);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerProjectionView.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrCompositionLayerDepthInfoKHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerSpaceWarpInfoFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer pose(XrPosef value) {
            XrCompositionLayerProjectionView.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer fov(XrFovf value) {
            XrCompositionLayerProjectionView.nfov(this.address(), value);
            return this;
        }

        public Buffer fov(Consumer<XrFovf> consumer) {
            consumer.accept(this.fov());
            return this;
        }

        public Buffer subImage(XrSwapchainSubImage value) {
            XrCompositionLayerProjectionView.nsubImage(this.address(), value);
            return this;
        }

        public Buffer subImage(Consumer<XrSwapchainSubImage> consumer) {
            consumer.accept(this.subImage());
            return this;
        }
    }
}

