/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiItemCombineIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.tuples.Functions;
import io.smallrye.mutiny.tuples.Tuple8;
import java.util.concurrent.Flow;

public class MultiItemCombine8<T1, T2, T3, T4, T5, T6, T7, T8>
extends MultiItemCombineIterable {
    public MultiItemCombine8(Iterable<Flow.Publisher<?>> iterable) {
        super(iterable);
    }

    @Override
    @CheckReturnValue
    public MultiItemCombine8<T1, T2, T3, T4, T5, T6, T7, T8> collectFailures() {
        super.collectFailures();
        return this;
    }

    @Override
    @CheckReturnValue
    public MultiItemCombine8<T1, T2, T3, T4, T5, T6, T7, T8> latestItems() {
        super.latestItems();
        return this;
    }

    @CheckReturnValue
    public Multi<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> asTuple() {
        return this.using(Tuple8::of);
    }

    @CheckReturnValue
    public <O> Multi<O> using(Functions.Function8<T1, T2, T3, T4, T5, T6, T7, T8, O> combinator) {
        ParameterValidation.nonNull(combinator, "combinator");
        return super.combine(args -> {
            ParameterValidation.size(args, 8, "args");
            return combinator.apply(args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5), args.get(6), args.get(7));
        });
    }
}

