/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.compatibility;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.keycloak.compatibility.ProviderCompatibleResult;
import org.keycloak.compatibility.ProviderIncompatibleResult;

public interface CompatibilityResult {
    public int exitCode();

    default public Optional<String> errorMessage() {
        return Optional.empty();
    }

    default public Optional<String> endMessage() {
        return Optional.empty();
    }

    default public Optional<Set<String>> incompatibleAttributes() {
        return Optional.empty();
    }

    public static CompatibilityResult providerCompatible(String providerId) {
        return new ProviderCompatibleResult(Objects.requireNonNull(providerId));
    }

    public static CompatibilityResult incompatibleAttribute(String providerId, String attribute, String previousValue, String currentValue) {
        return new ProviderIncompatibleResult(Objects.requireNonNull(providerId), Objects.requireNonNull(attribute), previousValue, currentValue);
    }

    public static enum ExitCode {
        ROLLING(0),
        RECREATE(3);

        final int exitCode;

        private ExitCode(int exitCode) {
            this.exitCode = exitCode;
        }

        public int value() {
            return this.exitCode;
        }
    }
}

