/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyComponentPathImpl;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.relational.ColumnOrderingStrategy;
import org.hibernate.boot.model.relational.ColumnOrderingStrategyLegacy;
import org.hibernate.boot.model.relational.ColumnOrderingStrategyStandard;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.StrategyRegistration;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.boot.registry.selector.internal.AggregatedDialectSelector;
import org.hibernate.boot.registry.selector.internal.DefaultJtaPlatformSelector;
import org.hibernate.boot.registry.selector.internal.LazyServiceResolver;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.DialectSelector;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.internal.SimpleCacheKeysFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.id.enhanced.ImplicitDatabaseObjectNamingStrategy;
import org.hibernate.id.enhanced.LegacyNamingStrategy;
import org.hibernate.id.enhanced.SingleNamingStrategy;
import org.hibernate.id.enhanced.StandardNamingStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.type.format.FormatMapper;
import org.hibernate.type.format.jackson.JacksonJsonFormatMapper;
import org.hibernate.type.format.jackson.JacksonXmlFormatMapper;
import org.hibernate.type.format.jakartajson.JsonBJsonFormatMapper;
import org.hibernate.type.format.jaxb.JaxbXmlFormatMapper;

public final class QuarkusStrategySelectorBuilder {
    public static StrategySelector buildSelector(ClassLoaderService classLoaderService) {
        StrategySelectorImpl strategySelector = new StrategySelectorImpl(classLoaderService);
        strategySelector.registerStrategyLazily(Dialect.class, (LazyServiceResolver)new AggregatedDialectSelector((Iterable)classLoaderService.loadJavaServices(DialectSelector.class)));
        strategySelector.registerStrategyLazily(JtaPlatform.class, (LazyServiceResolver)new DefaultJtaPlatformSelector());
        QuarkusStrategySelectorBuilder.addTransactionCoordinatorBuilders(strategySelector);
        QuarkusStrategySelectorBuilder.addSqmMultiTableInsertStrategies(strategySelector);
        QuarkusStrategySelectorBuilder.addSqmMultiTableMutationStrategies(strategySelector);
        QuarkusStrategySelectorBuilder.addImplicitNamingStrategies(strategySelector);
        QuarkusStrategySelectorBuilder.addColumnOrderingStrategies(strategySelector);
        QuarkusStrategySelectorBuilder.addCacheKeysFactories(strategySelector);
        QuarkusStrategySelectorBuilder.addJsonFormatMappers(strategySelector);
        QuarkusStrategySelectorBuilder.addXmlFormatMappers(strategySelector);
        for (StrategyRegistrationProvider provider : classLoaderService.loadJavaServices(StrategyRegistrationProvider.class)) {
            for (StrategyRegistration discoveredStrategyRegistration : provider.getStrategyRegistrations()) {
                QuarkusStrategySelectorBuilder.applyFromStrategyRegistration(strategySelector, discoveredStrategyRegistration);
            }
        }
        return strategySelector;
    }

    public static StrategySelector buildRuntimeSelector(ClassLoaderService classLoaderService) {
        StrategySelectorImpl strategySelector = new StrategySelectorImpl(classLoaderService);
        QuarkusStrategySelectorBuilder.addImplicitNamingStrategies(strategySelector);
        return strategySelector;
    }

    private static <T> void applyFromStrategyRegistration(StrategySelectorImpl strategySelector, StrategyRegistration<T> strategyRegistration) {
        for (String name : strategyRegistration.getSelectorNames()) {
            strategySelector.registerStrategyImplementor(strategyRegistration.getStrategyRole(), name, strategyRegistration.getStrategyImplementation());
        }
    }

    private static void addTransactionCoordinatorBuilders(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(TransactionCoordinatorBuilder.class, "jdbc", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class);
        strategySelector.registerStrategyImplementor(TransactionCoordinatorBuilder.class, "jta", JtaTransactionCoordinatorBuilderImpl.class);
    }

    private static void addSqmMultiTableInsertStrategies(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(SqmMultiTableInsertStrategy.class, "cte", CteInsertStrategy.class);
        strategySelector.registerStrategyImplementor(SqmMultiTableInsertStrategy.class, "global_temporary", GlobalTemporaryTableInsertStrategy.class);
        strategySelector.registerStrategyImplementor(SqmMultiTableInsertStrategy.class, "local_temporary", LocalTemporaryTableInsertStrategy.class);
        strategySelector.registerStrategyImplementor(SqmMultiTableInsertStrategy.class, "persistent", PersistentTableInsertStrategy.class);
    }

    private static void addSqmMultiTableMutationStrategies(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(SqmMultiTableMutationStrategy.class, "cte", CteMutationStrategy.class);
        strategySelector.registerStrategyImplementor(SqmMultiTableMutationStrategy.class, "global_temporary", GlobalTemporaryTableMutationStrategy.class);
        strategySelector.registerStrategyImplementor(SqmMultiTableMutationStrategy.class, "local_temporary", LocalTemporaryTableMutationStrategy.class);
        strategySelector.registerStrategyImplementor(SqmMultiTableMutationStrategy.class, "persistent", PersistentTableMutationStrategy.class);
    }

    private static void addImplicitNamingStrategies(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "default", ImplicitNamingStrategyJpaCompliantImpl.class);
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "jpa", ImplicitNamingStrategyJpaCompliantImpl.class);
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "component-path", ImplicitNamingStrategyComponentPathImpl.class);
        strategySelector.registerStrategyImplementor(ImplicitDatabaseObjectNamingStrategy.class, "standard", StandardNamingStrategy.class);
        strategySelector.registerStrategyImplementor(ImplicitDatabaseObjectNamingStrategy.class, "single", SingleNamingStrategy.class);
        strategySelector.registerStrategyImplementor(ImplicitDatabaseObjectNamingStrategy.class, "legacy", LegacyNamingStrategy.class);
    }

    private static void addColumnOrderingStrategies(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(ColumnOrderingStrategy.class, "default", ColumnOrderingStrategyStandard.class);
        strategySelector.registerStrategyImplementor(ColumnOrderingStrategy.class, "legacy", ColumnOrderingStrategyLegacy.class);
    }

    private static void addCacheKeysFactories(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(CacheKeysFactory.class, "default", DefaultCacheKeysFactory.class);
        strategySelector.registerStrategyImplementor(CacheKeysFactory.class, "simple", SimpleCacheKeysFactory.class);
    }

    private static void addJsonFormatMappers(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(FormatMapper.class, "jackson", JacksonJsonFormatMapper.class);
        strategySelector.registerStrategyImplementor(FormatMapper.class, "jsonb", JsonBJsonFormatMapper.class);
    }

    private static void addXmlFormatMappers(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(FormatMapper.class, "jackson-xml", JacksonXmlFormatMapper.class);
        strategySelector.registerStrategyImplementor(FormatMapper.class, "jaxb", JaxbXmlFormatMapper.class);
    }
}

