/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterMethodImpl;

public class PropertyAccessBasicImpl
implements PropertyAccess {
    private final PropertyAccessStrategyBasicImpl strategy;
    private final GetterMethodImpl getter;
    private final @Nullable SetterMethodImpl setter;

    public PropertyAccessBasicImpl(PropertyAccessStrategyBasicImpl strategy, Class<?> containerJavaType, String propertyName, boolean setterRequired) {
        this.strategy = strategy;
        Method getterMethod = ReflectHelper.findGetterMethod(containerJavaType, propertyName);
        this.getter = new GetterMethodImpl(containerJavaType, propertyName, getterMethod);
        Method setterMethod = setterRequired ? ReflectHelper.findSetterMethod(containerJavaType, propertyName, getterMethod.getReturnType()) : ReflectHelper.setterMethodOrNull(containerJavaType, propertyName, getterMethod.getReturnType());
        this.setter = setterMethod != null ? new SetterMethodImpl(containerJavaType, propertyName, setterMethod) : null;
    }

    @Override
    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public Getter getGetter() {
        return this.getter;
    }

    @Override
    public @Nullable Setter getSetter() {
        return this.setter;
    }
}

