/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.collection.mutation.AbstractUpdateRowsCoordinator;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class UpdateRowsCoordinatorTablePerSubclass
extends AbstractUpdateRowsCoordinator {
    private final RowMutationOperations rowMutationOperations;
    private final SubclassEntry[] deleteSubclassEntries;
    private final SubclassEntry[] insertSubclassEntries;

    public UpdateRowsCoordinatorTablePerSubclass(OneToManyPersister mutationTarget, RowMutationOperations rowMutationOperations, SessionFactoryImplementor sessionFactory) {
        super(mutationTarget, sessionFactory);
        this.rowMutationOperations = rowMutationOperations;
        this.deleteSubclassEntries = new SubclassEntry[mutationTarget.getElementPersister().getRootEntityDescriptor().getSubclassEntityNames().size()];
        this.insertSubclassEntries = new SubclassEntry[mutationTarget.getElementPersister().getRootEntityDescriptor().getSubclassEntityNames().size()];
    }

    @Override
    protected int doUpdate(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        if (this.rowMutationOperations.hasDeleteRow()) {
            this.deleteRows(key, collection, session);
        }
        if (this.rowMutationOperations.hasInsertRow()) {
            return this.insertRows(key, collection, session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        PluralAttributeMapping attributeMapping = this.getMutationTarget().getTargetPart();
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        Iterator<?> entries = collection.entries(collectionDescriptor);
        if (!entries.hasNext()) {
            return;
        }
        MutationExecutor[] executors = new MutationExecutor[this.deleteSubclassEntries.length];
        try {
            int entryPosition = -1;
            while (entries.hasNext()) {
                MutationExecutor mutationExecutor;
                Object entry = entries.next();
                if (!collection.needsUpdating(entry, ++entryPosition, attributeMapping)) continue;
                Object entryToUpdate = collection.getSnapshotElement(entry, entryPosition);
                EntityEntry entityEntry = session.getPersistenceContextInternal().getEntry(entryToUpdate);
                int subclassId = entityEntry.getPersister().getSubclassId();
                if (executors[subclassId] == null) {
                    SubclassEntry subclassEntry = this.getDeleteSubclassEntry(entityEntry.getPersister());
                    mutationExecutor = executors[subclassId] = this.mutationExecutorService.createExecutor(subclassEntry.batchKeySupplier, subclassEntry.operationGroup, session);
                } else {
                    mutationExecutor = executors[subclassId];
                }
                this.rowMutationOperations.getDeleteRowRestrictions().applyRestrictions(collection, key, entryToUpdate, entryPosition, session, mutationExecutor.getJdbcValueBindings());
                mutationExecutor.execute(entryToUpdate, null, null, null, session);
            }
        }
        finally {
            for (MutationExecutor executor : executors) {
                if (executor == null) continue;
                executor.release();
            }
        }
    }

    private SubclassEntry getDeleteSubclassEntry(EntityPersister elementPersister) {
        int subclassId = elementPersister.getSubclassId();
        SubclassEntry subclassEntry = this.deleteSubclassEntries[subclassId];
        if (subclassEntry != null) {
            return subclassEntry;
        }
        BasicBatchKey basicBatchKey = new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE-DELETE#" + subclassId);
        this.deleteSubclassEntries[subclassId] = new SubclassEntry(() -> basicBatchKey, this.resolveDeleteGroup(elementPersister));
        return this.deleteSubclassEntries[subclassId];
    }

    private MutationOperationGroup resolveDeleteGroup(EntityPersister elementPersister) {
        CollectionTableMapping collectionTableMapping = this.getMutationTarget().getCollectionTableMapping();
        JdbcMutationOperation operation = this.rowMutationOperations.getDeleteRowOperation(new CollectionTableMapping(elementPersister.getMappedTableDetails().getTableName(), collectionTableMapping.getSpaces(), collectionTableMapping.isJoinTable(), collectionTableMapping.isInverse(), collectionTableMapping.getInsertDetails(), collectionTableMapping.getUpdateDetails(), collectionTableMapping.isCascadeDeleteEnabled(), collectionTableMapping.getDeleteDetails(), collectionTableMapping.getDeleteRowDetails()));
        return MutationOperationGroupFactory.singleOperation(MutationType.DELETE, this.getMutationTarget(), operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        PluralAttributeMapping attributeMapping = this.getMutationTarget().getTargetPart();
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        Iterator<?> entries = collection.entries(collectionDescriptor);
        if (!entries.hasNext()) {
            return -1;
        }
        MutationExecutor[] executors = new MutationExecutor[this.insertSubclassEntries.length];
        try {
            int entryPosition = -1;
            while (entries.hasNext()) {
                MutationExecutor mutationExecutor;
                Object entry = entries.next();
                if (!collection.needsUpdating(entry, ++entryPosition, attributeMapping)) continue;
                EntityEntry entityEntry = session.getPersistenceContextInternal().getEntry(entry);
                int subclassId = entityEntry.getPersister().getSubclassId();
                if (executors[subclassId] == null) {
                    SubclassEntry subclassEntry = this.getInsertSubclassEntry(entityEntry.getPersister());
                    mutationExecutor = executors[subclassId] = this.mutationExecutorService.createExecutor(subclassEntry.batchKeySupplier, subclassEntry.operationGroup, session);
                } else {
                    mutationExecutor = executors[subclassId];
                }
                this.rowMutationOperations.getInsertRowValues().applyValues(collection, key, entry, entryPosition, session, mutationExecutor.getJdbcValueBindings());
                mutationExecutor.execute(entry, null, null, null, session);
            }
            int n = entryPosition;
            return n;
        }
        finally {
            for (MutationExecutor executor : executors) {
                if (executor == null) continue;
                executor.release();
            }
        }
    }

    private SubclassEntry getInsertSubclassEntry(EntityPersister elementPersister) {
        int subclassId = elementPersister.getSubclassId();
        SubclassEntry subclassEntry = this.insertSubclassEntries[subclassId];
        if (subclassEntry != null) {
            return subclassEntry;
        }
        BasicBatchKey basicBatchKey = new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE-INSERT#" + subclassId);
        this.insertSubclassEntries[subclassId] = new SubclassEntry(() -> basicBatchKey, this.resolveInsertGroup(elementPersister));
        return this.insertSubclassEntries[subclassId];
    }

    private MutationOperationGroup resolveInsertGroup(EntityPersister elementPersister) {
        CollectionTableMapping collectionTableMapping = this.getMutationTarget().getCollectionTableMapping();
        JdbcMutationOperation operation = this.rowMutationOperations.getInsertRowOperation(new CollectionTableMapping(elementPersister.getMappedTableDetails().getTableName(), collectionTableMapping.getSpaces(), collectionTableMapping.isJoinTable(), collectionTableMapping.isInverse(), collectionTableMapping.getInsertDetails(), collectionTableMapping.getUpdateDetails(), collectionTableMapping.isCascadeDeleteEnabled(), collectionTableMapping.getDeleteDetails(), collectionTableMapping.getDeleteRowDetails()));
        return MutationOperationGroupFactory.singleOperation(MutationType.INSERT, this.getMutationTarget(), operation);
    }

    private static class SubclassEntry {
        private final BatchKeyAccess batchKeySupplier;
        private final MutationOperationGroup operationGroup;

        public SubclassEntry(BatchKeyAccess batchKeySupplier, MutationOperationGroup operationGroup) {
            this.batchKeySupplier = batchKeySupplier;
            this.operationGroup = operationGroup;
        }
    }
}

