/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.ConcurrentModificationException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.collections.AbstractPagedArray;

public class InstanceIdentityStore<V>
extends AbstractPagedArray<Object> {
    private static int toKeyIndex(int instanceId) {
        return (instanceId - 1) * 2;
    }

    public @Nullable V get(int instanceId, Object key) {
        if (instanceId <= 0) {
            return null;
        }
        int keyIndex = InstanceIdentityStore.toKeyIndex(instanceId);
        AbstractPagedArray.Page page = this.getPage(keyIndex);
        if (page != null) {
            int offset = InstanceIdentityStore.toPageOffset(keyIndex);
            Object k = page.get(offset);
            if (k == key) {
                return (V)page.get(offset + 1);
            }
            throw new ConcurrentModificationException("Found a different instance corresponding to instanceId [" + instanceId + "], this might indicate a concurrent access to this persistence context.");
        }
        return null;
    }

    public void put(Object key, int instanceId, V value) {
        if (key == null) {
            throw new NullPointerException("This store does not support null keys");
        }
        if (instanceId <= 0) {
            throw new IllegalArgumentException("Instance ID must be a positive value");
        }
        int keyIndex = InstanceIdentityStore.toKeyIndex(instanceId);
        AbstractPagedArray.Page page = this.getOrCreateEntryPage(keyIndex);
        int pageOffset = InstanceIdentityStore.toPageOffset(keyIndex);
        page.set(pageOffset, key);
        page.set(pageOffset + 1, value);
    }

    public void remove(int instanceId, Object key) {
        if (instanceId <= 0) {
            return;
        }
        int keyIndex = InstanceIdentityStore.toKeyIndex(instanceId);
        AbstractPagedArray.Page page = this.getPage(keyIndex);
        if (page != null) {
            int pageOffset = InstanceIdentityStore.toPageOffset(keyIndex);
            Object k = page.set(pageOffset, null);
            if (k == key) {
                page.set(pageOffset + 1, null);
            } else {
                throw new ConcurrentModificationException("Found a different instance corresponding to instanceId [" + instanceId + "], this might indicate a concurrent access to this persistence context.");
            }
        }
    }
}

