/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.internal;

import java.lang.reflect.Member;
import java.util.EnumSet;
import org.hibernate.PropertyValueException;
import org.hibernate.annotations.TenantId;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.type.descriptor.java.JavaType;

public class TenantIdGeneration
implements BeforeExecutionGenerator {
    private final String entityName;
    private final String propertyName;

    public TenantIdGeneration(TenantId annotation, Member member, GeneratorCreationContext context) {
        this.entityName = context.getPersistentClass() == null ? member.getDeclaringClass().getName() : context.getPersistentClass().getEntityName();
        this.propertyName = context.getProperty().getName();
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return EventTypeSets.INSERT_ONLY;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        SessionFactoryImplementor sessionFactory = session.getSessionFactory();
        Object tenantId = session.getTenantIdentifierValue();
        if (currentValue != null) {
            CurrentTenantIdentifierResolver<Object> resolver = sessionFactory.getCurrentTenantIdentifierResolver();
            if (resolver != null && resolver.isRoot(tenantId)) {
                return currentValue;
            }
            JavaType<Object> tenantIdJavaType = sessionFactory.getTenantIdentifierJavaType();
            if (!tenantIdJavaType.areEqual(currentValue, tenantId)) {
                throw new PropertyValueException("assigned tenant id differs from current tenant id [" + tenantIdJavaType.toString(currentValue) + " != " + tenantIdJavaType.toString(tenantId) + "]", this.entityName, this.propertyName);
            }
        }
        return tenantId;
    }
}

