/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.archive.scan.internal;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.boot.archive.internal.StandardArchiveDescriptorFactory;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.MappingFileDescriptor;
import org.hibernate.boot.archive.scan.spi.PackageDescriptor;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.archive.scan.spi.ScanParameters;
import org.hibernate.boot.archive.scan.spi.ScanResult;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.boot.archive.spi.ArchiveDescriptor;
import org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;
import org.hibernate.boot.archive.spi.ArchiveEntry;
import org.hibernate.boot.archive.spi.InputStreamAccess;

public class DisabledScanner
implements Scanner {
    private final ArchiveDescriptorFactory archiveDescriptorFactory;

    public DisabledScanner() {
        this(StandardArchiveDescriptorFactory.INSTANCE);
    }

    private DisabledScanner(ArchiveDescriptorFactory archiveDescriptorFactory) {
        this.archiveDescriptorFactory = archiveDescriptorFactory;
    }

    @Override
    public ScanResult scan(ScanEnvironment environment, ScanOptions options, ScanParameters parameters) {
        ArchiveDescriptor archiveDescriptor;
        ArchiveEntry entry;
        final HashSet<MappingFileDescriptorImpl> discoveredMappingFiles = new HashSet<MappingFileDescriptorImpl>();
        if (environment.getNonRootUrls() != null) {
            for (URL url : environment.getNonRootUrls()) {
                ArchiveDescriptor archiveDescriptor2 = this.archiveDescriptorFactory.buildArchiveDescriptor(url);
                ArchiveEntry entry2 = archiveDescriptor2.findEntry("META-INF/orm.xml");
                if (entry2 == null) continue;
                discoveredMappingFiles.add(new MappingFileDescriptorImpl(entry2.getNameWithinArchive(), entry2.getStreamAccess()));
            }
        }
        if (environment.getRootUrl() != null && (entry = (archiveDescriptor = this.archiveDescriptorFactory.buildArchiveDescriptor(environment.getRootUrl())).findEntry("META-INF/orm.xml")) != null) {
            discoveredMappingFiles.add(new MappingFileDescriptorImpl(entry.getNameWithinArchive(), entry.getStreamAccess()));
        }
        return new ScanResult(){

            @Override
            public Set<PackageDescriptor> getLocatedPackages() {
                return Collections.emptySet();
            }

            @Override
            public Set<ClassDescriptor> getLocatedClasses() {
                return Collections.emptySet();
            }

            @Override
            public Set<MappingFileDescriptor> getLocatedMappingFiles() {
                return discoveredMappingFiles;
            }
        };
    }

    public static final class MappingFileDescriptorImpl
    implements MappingFileDescriptor {
        private final String name;
        private final InputStreamAccess streamAccess;

        public MappingFileDescriptorImpl(String name, InputStreamAccess streamAccess) {
            this.name = name;
            this.streamAccess = streamAccess;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStreamAccess getStreamAccess() {
            return this.streamAccess;
        }

        public String toString() {
            return "MappingFileDescriptorImpl[name=" + this.name + ", streamAccess=" + String.valueOf(this.streamAccess) + "]";
        }
    }
}

