/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ChangedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import java.util.HashMap;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class ChangedClassesBuildStep {
    private static volatile IndexView oldIndex;

    @BuildStep(onlyIf={IsDevelopment.class})
    ChangedClassesBuildItem changedClassesBuildItem(CombinedIndexBuildItem combinedIndexBuildItem, LiveReloadBuildItem liveReloadBuildItem) {
        ClassInfo clazz;
        DotName name;
        IndexView currentIndex = combinedIndexBuildItem.getIndex();
        if (liveReloadBuildItem.getChangeInformation() == null) {
            oldIndex = currentIndex;
            return null;
        }
        HashMap<DotName, ClassInfo> changedClassesNewVersion = new HashMap<DotName, ClassInfo>();
        HashMap<DotName, ClassInfo> changedClassesOldVersion = new HashMap<DotName, ClassInfo>();
        HashMap<DotName, ClassInfo> deletedClasses = new HashMap<DotName, ClassInfo>();
        HashMap<DotName, ClassInfo> addedClasses = new HashMap<DotName, ClassInfo>();
        for (String added : liveReloadBuildItem.getChangeInformation().getAddedClasses()) {
            name = DotName.createSimple((String)added);
            clazz = currentIndex.getClassByName(name);
            if (clazz == null) {
                return null;
            }
            addedClasses.put(name, clazz);
        }
        for (String deleted : liveReloadBuildItem.getChangeInformation().getDeletedClasses()) {
            name = DotName.createSimple((String)deleted);
            clazz = oldIndex.getClassByName(name);
            if (clazz == null) {
                return null;
            }
            addedClasses.put(name, clazz);
        }
        for (String mod : liveReloadBuildItem.getChangeInformation().getChangedClasses()) {
            name = DotName.createSimple((String)mod);
            clazz = oldIndex.getClassByName(name);
            if (clazz == null) {
                return null;
            }
            changedClassesOldVersion.put(name, clazz);
            clazz = currentIndex.getClassByName(name);
            if (clazz == null) {
                return null;
            }
            changedClassesNewVersion.put(name, clazz);
        }
        oldIndex = currentIndex;
        return new ChangedClassesBuildItem(changedClassesNewVersion, changedClassesOldVersion, deletedClasses, addedClasses);
    }
}

