/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.Annotation;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.TypeParameter;
import io.quarkus.gizmo2.creator.TypeParameterCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.AnnotatableCreatorImpl;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.ElementType;
import java.lang.constant.ClassDesc;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Optional;

public final class TypeParameterCreatorImpl
extends AnnotatableCreatorImpl
implements TypeParameterCreator {
    private final String name;
    private GenericType.OfReference firstBound;
    private List<GenericType.OfReference> otherBounds = List.of();
    private static final MethodHandle ofType;
    private static final MethodHandle ofConstructor;
    private static final MethodHandle ofMethod;

    public TypeParameterCreatorImpl(String name) {
        this.name = name;
    }

    public TypeParameterCreatorImpl(List<Annotation> visible, List<Annotation> invisible, String name) {
        super(visible, invisible);
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void setFirstBound(GenericType.OfClass bound) {
        this.firstBound = (GenericType.OfReference)Assert.checkNotNullParam((String)"bound", (Object)bound);
    }

    @Override
    public void setFirstBound(GenericType.OfTypeVariable bound) {
        if (!this.otherBounds.isEmpty()) {
            throw new IllegalArgumentException("Other bounds may not be present when the first bound is a type variable");
        }
        this.firstBound = (GenericType.OfReference)Assert.checkNotNullParam((String)"bound", (Object)bound);
    }

    @Override
    public void setOtherBounds(List<GenericType.OfClass> bounds) {
        if (this.firstBound instanceof GenericType.OfTypeVariable) {
            throw new IllegalArgumentException("Other bounds may not be present when the first bound is a type variable");
        }
        this.otherBounds = List.copyOf(bounds);
    }

    @Override
    public ElementType annotationTargetType() {
        return ElementType.TYPE_PARAMETER;
    }

    TypeParameter.OfConstructor forConstructor(ConstructorDesc desc) {
        try {
            return ofConstructor.invokeExact(List.copyOf(this.visible.values()), List.copyOf(this.invisible.values()), this.name, Optional.ofNullable(this.firstBound), this.otherBounds, desc);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    TypeParameter.OfMethod forMethod(MethodDesc desc) {
        try {
            return ofMethod.invokeExact(List.copyOf(this.visible.values()), List.copyOf(this.invisible.values()), this.name, Optional.ofNullable(this.firstBound), this.otherBounds, desc);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    TypeParameter.OfType forType(ClassDesc desc) {
        try {
            return ofType.invokeExact(List.copyOf(this.visible.values()), List.copyOf(this.invisible.values()), this.name, Optional.ofNullable(this.firstBound), this.otherBounds, desc);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(TypeParameter.class, MethodHandles.lookup());
            ofType = lookup.findConstructor(TypeParameter.OfType.class, MethodType.methodType(Void.TYPE, List.class, List.class, String.class, Optional.class, List.class, ClassDesc.class));
            ofConstructor = lookup.findConstructor(TypeParameter.OfConstructor.class, MethodType.methodType(Void.TYPE, List.class, List.class, String.class, Optional.class, List.class, ConstructorDesc.class));
            ofMethod = lookup.findConstructor(TypeParameter.OfMethod.class, MethodType.methodType(Void.TYPE, List.class, List.class, String.class, Optional.class, List.class, MethodDesc.class));
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

