/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker.mapper;

import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.docker.mapper.DockerAuthV2AttributeMapper;
import org.keycloak.protocol.docker.mapper.DockerAuthV2ProtocolMapper;
import org.keycloak.representations.docker.DockerAccess;
import org.keycloak.representations.docker.DockerResponseToken;

public class AllowAllDockerProtocolMapper
extends DockerAuthV2ProtocolMapper
implements DockerAuthV2AttributeMapper {
    public static final String PROVIDER_ID = "docker-v2-allow-all-mapper";

    public String getDisplayType() {
        return "Allow All";
    }

    public String getHelpText() {
        return "Allows all grants, returning the full set of requested access attributes as permitted attributes.";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public boolean appliesTo(DockerResponseToken responseToken) {
        return true;
    }

    @Override
    public DockerResponseToken transformDockerResponseToken(DockerResponseToken responseToken, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        responseToken.getAccessItems().clear();
        String requestedScopes = clientSession.getNote("scope");
        if (requestedScopes != null) {
            for (String requestedScope : requestedScopes.split(" ")) {
                DockerAccess requestedAccess = new DockerAccess(requestedScope);
                responseToken.getAccessItems().add(requestedAccess);
            }
        }
        return responseToken;
    }
}

