/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jgroups.certificates;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.jgroups.certificates.JGroupsCertificate;

public final class Utils {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final String JGROUPS_SUBJECT = "jgroups";
    private static final char[] KEY_PASSWORD = "jgroups-password".toCharArray();

    private Utils() {
    }

    public static JGroupsCertificate generateSelfSignedCertificate(Duration validity) {
        Date endDate = Date.from(Instant.now().plus(validity));
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)2048);
        X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)JGROUPS_SUBJECT, (BigInteger)BigInteger.valueOf(System.currentTimeMillis()), (Date)endDate);
        logger.debugf("Created JGroups certificate. Valid until %s", (Object)certificate.getNotAfter());
        JGroupsCertificate entity = new JGroupsCertificate();
        entity.setCertificate(certificate);
        entity.setKeyPair(keyPair);
        entity.setAlias(UUID.randomUUID().toString());
        entity.setGeneratedMillis(System.currentTimeMillis());
        return entity;
    }

    public static X509ExtendedKeyManager createKeyManager(JGroupsCertificate certificate) throws GeneralSecurityException, IOException {
        KeyStore ks = Utils.getKeyStore();
        ks.setKeyEntry(certificate.getAlias(), certificate.getPrivateKey(), KEY_PASSWORD, new Certificate[]{certificate.getCertificate()});
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, KEY_PASSWORD);
        for (KeyManager km : kmf.getKeyManagers()) {
            if (!(km instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)km;
        }
        throw new GeneralSecurityException("Could not obtain an X509ExtendedKeyManager");
    }

    public static X509ExtendedTrustManager createTrustManager(JGroupsCertificate certificate) throws GeneralSecurityException, IOException {
        KeyStore ks = Utils.getKeyStore();
        ks.setCertificateEntry(certificate.getAlias(), certificate.getCertificate());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)tm;
        }
        throw new GeneralSecurityException("Could not obtain an X509TrustManager");
    }

    private static KeyStore getKeyStore() throws KeyStoreException, NoSuchProviderException, CertificateException, IOException, NoSuchAlgorithmException {
        KeystoreUtil.KeystoreFormat keystoreFormat = (KeystoreUtil.KeystoreFormat)CryptoIntegration.getProvider().getSupportedKeyStoreTypes().findFirst().orElseThrow(() -> new RuntimeException("No supported keystore types found"));
        KeyStore ks = CryptoIntegration.getProvider().getKeyStore(keystoreFormat);
        ks.load(null, null);
        return ks;
    }
}

