/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.telemetry.impl;

import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryServiceImpl;

public class TelemetryServiceFactory {
    private static final Log log = LogFactory.getLog(TelemetryService.class, Log.class);
    public static final TelemetryServiceFactory INSTANCE = new TelemetryServiceFactory();
    private final TelemetryService telemetryService = this.telemetryService();

    private TelemetryServiceFactory() {
    }

    public TelemetryService telemetryService(boolean propagationEnabled) {
        if (this.telemetryService == null) {
            return null;
        }
        if (propagationEnabled) {
            log.openTelemetryPropagationEnabled();
            return this.telemetryService;
        }
        log.openTelemetryPropagationDisabled();
        return null;
    }

    private TelemetryService telemetryService() {
        try {
            Class.forName("io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator", false, TelemetryService.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.noOpenTelemetryAPI();
            return null;
        }
        try {
            TelemetryServiceImpl service = new TelemetryServiceImpl();
            return service;
        }
        catch (Throwable e) {
            log.errorCreatingPropagationContext(e);
            return null;
        }
    }
}

