/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import java.text.Bidi;
import java.text.Normalizer;
import rocks.xmpp.precis.PrecisProfile;

final class UsernameProfile
extends PrecisProfile {
    private static final long serialVersionUID = 848281423907881855L;
    private final boolean caseMapped;

    UsernameProfile(boolean caseMapped) {
        super(true);
        this.caseMapped = caseMapped;
    }

    @Override
    public final String prepare(CharSequence input) {
        CharSequence mapped = this.applyWidthMappingRule(input);
        return super.prepare(mapped);
    }

    @Override
    public final String enforce(CharSequence input) {
        String enforced = super.enforce(input);
        if (enforced.isEmpty()) {
            throw new IllegalArgumentException("A username must not be empty.");
        }
        return enforced;
    }

    @Override
    protected final CharSequence applyWidthMappingRule(CharSequence input) {
        return UsernameProfile.widthMap(input);
    }

    @Override
    protected final CharSequence applyAdditionalMappingRule(CharSequence input) {
        return input;
    }

    @Override
    protected final CharSequence applyCaseMappingRule(CharSequence input) {
        return this.caseMapped ? UsernameProfile.caseMap(input) : input;
    }

    @Override
    protected final CharSequence applyNormalizationRule(CharSequence input) {
        return Normalizer.normalize(input, Normalizer.Form.NFC);
    }

    @Override
    protected final CharSequence applyDirectionalityRule(CharSequence input) {
        if (Bidi.requiresBidi(input.toString().toCharArray(), 0, input.length())) {
            UsernameProfile.checkBidiRule(input);
        }
        return input;
    }
}

