import * as grpc from '@grpc/grpc-js';
import { c as Transport, R as RequestOptions, S as SendMessageResult, A as A2AStreamEventData, T as TransportFactory, a as TransportProtocolName } from '../../../core-BAzQJfA2.js';
import { ae as AgentCard, x as MessageSendParams, $ as TaskPushNotificationConfig, a3 as GetTaskPushNotificationConfigParams, a7 as ListTaskPushNotificationConfigParams, a9 as DeleteTaskPushNotificationConfigParams, X as TaskQueryParams, ay as Task, Z as TaskIdParams } from '../../../extensions-DvruCIzw.js';

interface GrpcTransportOptions {
    endpoint: string;
    grpcChannelCredentials?: grpc.ChannelCredentials;
    grpcCallOptions?: Partial<grpc.CallOptions>;
}
declare class GrpcTransport implements Transport {
    private readonly grpcCallOptions?;
    private readonly grpcClient;
    constructor(options: GrpcTransportOptions);
    getExtendedAgentCard(options?: RequestOptions): Promise<AgentCard>;
    sendMessage(params: MessageSendParams, options?: RequestOptions): Promise<SendMessageResult>;
    sendMessageStream(params: MessageSendParams, options?: RequestOptions): AsyncGenerator<A2AStreamEventData, void, undefined>;
    setTaskPushNotificationConfig(params: TaskPushNotificationConfig, options?: RequestOptions): Promise<TaskPushNotificationConfig>;
    getTaskPushNotificationConfig(params: GetTaskPushNotificationConfigParams, options?: RequestOptions): Promise<TaskPushNotificationConfig>;
    listTaskPushNotificationConfig(params: ListTaskPushNotificationConfigParams, options?: RequestOptions): Promise<TaskPushNotificationConfig[]>;
    deleteTaskPushNotificationConfig(params: DeleteTaskPushNotificationConfigParams, options?: RequestOptions): Promise<void>;
    getTask(params: TaskQueryParams, options?: RequestOptions): Promise<Task>;
    cancelTask(params: TaskIdParams, options?: RequestOptions): Promise<Task>;
    resubscribeTask(params: TaskIdParams, options?: RequestOptions): AsyncGenerator<A2AStreamEventData, void, undefined>;
    private _sendGrpcRequest;
    private _sendGrpcStreamingRequest;
    private isServiceError;
    private _buildMetadata;
    private static mapToError;
}
declare class GrpcTransportFactoryOptions {
    grpcChannelCredentials?: grpc.ChannelCredentials;
    grpcCallOptions?: Partial<grpc.CallOptions>;
}
declare class GrpcTransportFactory implements TransportFactory {
    private readonly options?;
    static readonly name: TransportProtocolName;
    constructor(options?: GrpcTransportFactoryOptions);
    get protocolName(): string;
    create(url: string, _agentCard: AgentCard): Promise<Transport>;
}

export { GrpcTransport, GrpcTransportFactory, type GrpcTransportOptions };
