/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.nav.NavChecker;
import com.adobe.epubcheck.ncx.NCXChecker;
import com.adobe.epubcheck.ocf.OCFContainer;
import com.adobe.epubcheck.ocf.OCFFilenameChecker;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.OPFReference;
import com.adobe.epubcheck.opf.PublicationType;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.ValidatorMap;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.w3c.epubcheck.core.AbstractChecker;
import org.w3c.epubcheck.core.Checker;
import org.w3c.epubcheck.core.CheckerFactory;
import org.w3c.epubcheck.core.references.ResourceReferencesChecker;
import org.w3c.epubcheck.core.references.ResourceRegistry;
import org.w3c.epubcheck.util.url.URLUtils;

public class OPFChecker
extends AbstractChecker {
    private static final ValidatorMap validatorMap = ValidatorMap.builder().put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2), XMLValidators.OPF_20_RNG).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_2), XMLValidators.OPF_20_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_RNC).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_DO_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_DICT_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_IDX_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_MANIFEST_SCH).put(ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3), XMLValidators.OPF_30_COLLECTION_PREVIEW_SCH).put((Predicate<? super ValidationContext>)Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.DICT), ValidationContext.ValidationContextPredicates.hasPubType(PublicationType.DICTIONARY)), XMLValidators.OPF_DICT_SCH).put((Predicate<? super ValidationContext>)Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.EDUPUB), ValidationContext.ValidationContextPredicates.hasPubType(PublicationType.EDUPUB)), XMLValidators.OPF_EDUPUB_SCH).put((Predicate<? super ValidationContext>)Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.PREVIEW), ValidationContext.ValidationContextPredicates.hasPubType(PublicationType.PREVIEW)), XMLValidators.OPF_PREVIEW_SCH).build();
    protected final String path;
    protected final EPUBVersion version;
    protected OPFHandler opfHandler = null;

    public OPFChecker(ValidationContext context) {
        super(context);
        this.path = context.path;
        this.version = context.version;
    }

    @Override
    public void check() {
        if (this.context.container.isPresent()) {
            this.checkPackage();
        } else {
            this.checkContent();
        }
    }

    protected boolean checkPackage() {
        Preconditions.checkState((boolean)this.context.container.isPresent());
        OCFContainer container = (OCFContainer)this.context.container.get();
        if (!container.contains(this.context.url)) {
            this.report.message(MessageId.PKG_020, EPUBLocation.of(this.context), this.path);
            return false;
        }
        this.checkContent();
        if (!this.opfHandler.checkUniqueIdentExists()) {
            this.report.message(MessageId.OPF_030, EPUBLocation.of(this.context), this.opfHandler.getIdentId());
        }
        List<OPFItem> items = this.opfHandler.getItems();
        this.report.info(null, FeatureEnum.ITEMS_COUNT, Integer.toString(items.size()));
        ((ResourceRegistry)this.context.resourceRegistry.get()).registerResource(this.context.url, this.context.mimeType);
        for (OPFItem item : items) {
            ((ResourceRegistry)this.context.resourceRegistry.get()).registerResource(item);
            this.report.info(item.getPath(), FeatureEnum.DECLARED_MIMETYPE, item.getMimeType());
        }
        this.checkGuide();
        for (OPFItem item : items) {
            if (item.isRemote()) continue;
            this.checkItemContent(item);
        }
        for (OPFItem item : items) {
            this.checkItemAfterResourceValidation(item);
        }
        new ResourceReferencesChecker(this.context).check();
        return false;
    }

    protected void checkItemAfterResourceValidation(OPFItem item) {
    }

    protected void checkGuide() {
        int refCount = this.opfHandler.getReferenceCount();
        for (int i = 0; i < refCount; ++i) {
            OPFReference ref = this.opfHandler.getReference(i);
            Optional<OPFItem> item = this.opfHandler.getItemByURL(ref.getDocumentURL());
            if (!item.isPresent()) {
                this.report.message(MessageId.OPF_031, EPUBLocation.of(this.context).at(ref.getLineNumber(), ref.getColumnNumber()), this.context.relativize(ref.getURL()));
                continue;
            }
            if (OPFChecker.isBlessedItemType(((OPFItem)item.get()).getMimeType(), this.version) || OPFChecker.isDeprecatedBlessedItemType(((OPFItem)item.get()).getMimeType())) continue;
            this.report.message(MessageId.OPF_032, EPUBLocation.of(this.context).at(ref.getLineNumber(), ref.getColumnNumber()), this.context.relativize(ref.getURL()));
        }
    }

    protected void initHandler() {
        this.opfHandler = new OPFHandler(this.context);
    }

    public OPFHandler getOPFHandler() {
        return this.opfHandler;
    }

    protected boolean checkContent() {
        XMLParser parser = new XMLParser(new ValidationContext.ValidationContextBuilder(this.context).mimetype("opf").build());
        this.initHandler();
        for (XMLValidator validator : validatorMap.getValidators(this.context)) {
            parser.addValidator(validator);
        }
        parser.addContentHandler(this.opfHandler);
        parser.process();
        for (OPFItem item : this.opfHandler.getItems()) {
            if (!(this.context.container.isPresent() || item.isRemote() || item.hasDataURL())) {
                new OCFFilenameChecker(item.getPath(), this.context, item.getLocation()).check();
            }
            if (!item.equals(this.opfHandler.getItemByURL(item.getURL()).orNull())) {
                this.report.message(MessageId.OPF_074, item.getLocation(), item.getPath());
                continue;
            }
            if (item.getURL().equals((Object)this.context.url)) {
                this.report.message(MessageId.OPF_099, item.getLocation(), new Object[0]);
                continue;
            }
            this.checkItem(item, this.opfHandler);
        }
        if (!this.opfHandler.getSpineItems().isEmpty()) {
            boolean linearFound = false;
            int spineIndex = 0;
            for (OPFItem item : this.opfHandler.getSpineItems()) {
                this.checkSpineItem(item, this.opfHandler);
                if (item.isLinear()) {
                    linearFound = true;
                }
                this.report.info(item.getPath(), FeatureEnum.SPINE_INDEX, Integer.toString(spineIndex++));
            }
            if (!linearFound) {
                this.report.message(MessageId.OPF_033, EPUBLocation.of(this.context), new Object[0]);
            }
        }
        if (this.version == EPUBVersion.VERSION_2) {
            HashSet<OPFItem> seen = new HashSet<OPFItem>();
            for (OPFItem item : this.opfHandler.getSpineItems()) {
                if (seen.contains(item)) {
                    this.report.message(MessageId.OPF_034, item.getLocation(), item.getId());
                    continue;
                }
                seen.add(item);
            }
        }
        return true;
    }

    public static boolean isBlessedItemType(String type, EPUBVersion version) {
        if (version == EPUBVersion.VERSION_2) {
            return type.equals("application/xhtml+xml") || type.equals("application/x-dtbook+xml");
        }
        return type.equals("application/xhtml+xml") || type.equals("image/svg+xml");
    }

    public static boolean isDeprecatedBlessedItemType(String type) {
        return type.equals("text/x-oeb1-document") || type.equals("text/html");
    }

    public static boolean isBlessedStyleType(String type) {
        return type.equals("text/css");
    }

    public static boolean isDeprecatedBlessedStyleType(String type) {
        return type.equals("text/x-oeb1-css");
    }

    public static boolean isBlessedImageType(String type, EPUBVersion version) {
        return type.equals("image/gif") || type.equals("image/png") || type.equals("image/jpeg") || type.equals("image/svg+xml") || version == EPUBVersion.VERSION_3 && type.equals("image/webp");
    }

    public static boolean isBlessedFontMimetype20(String mime) {
        return mime != null && (mime.startsWith("font/") || mime.startsWith("application/font") || mime.startsWith("application/x-font") || "application/vnd.ms-opentype".equals(mime));
    }

    public static boolean isScriptType(String type) {
        type = type == null ? null : type.toLowerCase(Locale.ENGLISH);
        return "application/javascript".equals(type) || "text/javascript".equals(type) || "application/ecmascript".equals(type) || "application/x-ecmascript".equals(type) || "application/x-javascript".equals(type) || "text/ecmascript".equals(type) || "text/javascript1.0".equals(type) || "text/javascript1.1".equals(type) || "text/javascript1.2".equals(type) || "text/javascript1.3".equals(type) || "text/javascript1.4".equals(type) || "text/javascript1.5".equals(type) || "text/jscript".equals(type) || "text/livescript".equals(type) || "text/x-ecmascript".equals(type) || "text/x-javascript".equals(type);
    }

    protected void checkItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        if (mimeType.matches("[a-zA-Z0-9!#$&+-^_]+/[a-zA-Z0-9!#$&+-^_]+") && (OPFChecker.isDeprecatedBlessedItemType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType))) {
            if (opfHandler.getOpf20PackageFile() && mimeType.equals("text/html")) {
                this.report.message(MessageId.OPF_035, item.getLocation().context(item.getId()), new Object[0]);
            } else if (opfHandler.getOpf12PackageFile() && mimeType.equals("text/html")) {
                this.report.message(MessageId.OPF_038, item.getLocation().context(item.getId()), mimeType);
            } else if (opfHandler.getOpf20PackageFile()) {
                this.report.message(MessageId.OPF_037, item.getLocation().context(item.getId()), mimeType);
            }
        }
        if (opfHandler.getOpf12PackageFile() && !item.hasFallback()) {
            if (OPFChecker.isBlessedItemType(mimeType, this.version)) {
                this.report.message(MessageId.OPF_038, item.getLocation().context(item.getId()), mimeType);
            } else if (OPFChecker.isBlessedStyleType(mimeType)) {
                this.report.message(MessageId.OPF_039, item.getLocation().context(item.getId()), mimeType);
            }
        }
    }

    protected void checkItemContent(OPFItem item) {
        if (item.hasDataURL()) {
            return;
        }
        if (URLUtils.docURL(item.getURL()).equals((Object)this.context.url)) {
            return;
        }
        ValidationContext itemContext = new ValidationContext.ValidationContextBuilder(this.context).url(item.getURL()).mimetype(item.getMimeType()).properties(item.getProperties()).build();
        try {
            Checker checker = item.isNcx() ? new NCXChecker(itemContext) : (item.isNav() ? new NavChecker(itemContext) : CheckerFactory.newChecker(itemContext));
            checker.check();
        }
        catch (IllegalStateException e) {
            this.report.message(MessageId.CHK_008, EPUBLocation.of(this.context), item.getPath());
        }
    }

    protected void checkSpineItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        if (OPFChecker.isBlessedStyleType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType) || OPFChecker.isBlessedImageType(mimeType, this.version)) {
            this.report.message(MessageId.OPF_042, item.getLocation(), mimeType);
        } else if (!OPFChecker.isBlessedItemType(mimeType, this.version) && !OPFChecker.isDeprecatedBlessedItemType(mimeType)) {
            if (!item.hasFallback()) {
                this.report.message(MessageId.OPF_043, item.getLocation(), mimeType);
            } else if (!item.hasContentDocumentFallback()) {
                this.report.message(MessageId.OPF_044, item.getLocation(), mimeType);
            }
        }
    }
}

