/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CancelableRequest;
import com.microsoft.sqlserver.jdbc.IOBuffer;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DBComms
implements Runnable {
    static final byte TDS_RET_STAT = 121;
    static final byte TDS_PROCID = 124;
    static final byte TDS_COLMETADATA = -127;
    static final byte TDS_TABNAME = -92;
    static final byte TDS_COLINFO = -91;
    static final byte TDS_UNKNOWN_0xA7 = -89;
    static final byte TDS_UNKNOWN_0xA8 = -88;
    static final byte TDS_ORDER = -87;
    static final byte TDS_ERR = -86;
    static final byte TDS_MSG = -85;
    static final byte TDS_RETURN_VALUE = -84;
    static final byte TDS_LOGIN_ACK = -83;
    static final byte TDS_CONTROL = -82;
    static final byte TDS_ROW = -47;
    static final byte TDS_UNKNOWN_0xE2 = -30;
    static final byte TDS_ENV_CHG = -29;
    static final byte TDS_MSG50 = -27;
    static final byte TDS_RESULT = -18;
    static final byte TDS_DONE = -3;
    static final byte TDS_DONEPROC = -2;
    static final byte TDS_DONEINPROC = -1;
    static final byte TDS_SSPI = -19;
    static final int PROCID_SP_CURSOR = 1;
    static final int PROCID_SP_CURSOROPEN = 2;
    static final int PROCID_SP_CURSORPREPARE = 3;
    static final int PROCID_SP_CURSOREXECUTE = 4;
    static final int PROCID_SP_CURSORPREPEXEC = 5;
    static final int PROCID_SP_CURSORUNPREPARE = 6;
    static final int PROCID_SP_CURSORFETCH = 7;
    static final int PROCID_SP_CURSOROPTION = 8;
    static final int PROCID_SP_CURSORCLOSE = 9;
    static final int PROCID_SP_EXECUTESQL = 10;
    static final int PROCID_SP_PREPARE = 11;
    static final int PROCID_SP_EXECUTE = 12;
    static final int PROCID_SP_PREPEXEC = 13;
    static final int PROCID_SP_PREPEXECRPC = 14;
    static final int PROCID_SP_UNPREPARE = 15;
    public static final int LAST_PKT_CALCULATE = 0;
    public static final int LAST_PKT_FALSE = 2;
    public static final int PKT_BUFFER_HEADER_SIZE = 8;
    public static final int PKT_STREAM_HEADER_SIZE = 22;
    public static final byte PKT_QUERY = 1;
    public static final byte PKT_LOGON65 = 2;
    public static final byte PKT_DTC = 14;
    public static final byte PKT_LOGON70 = 16;
    public static final byte PKT_PRELOGIN = 18;
    public static final byte PKT_RPC = 3;
    public static final byte PKT_REPLY = 4;
    public static final byte PKT_CANCEL_REQ = 6;
    public static final byte PKT_SSPI = 17;
    public static final byte PKT_STATUS_NORMAL = 0;
    public static final byte PKT_STATUS_EOM = 1;
    public static final byte PKT_STATUS_ATTENTION_ACK = 2;
    public static final byte PKT_STATUS_IGNORE = 3;
    public static final byte PKT_STATUS_RESET_CONN = 8;
    private TDSVersion tdsVersion;
    private SQLServerConnection con;
    private int packetsSent;
    private int msgsSent;
    private int packetsRecd;
    private int msgsRecd;
    private int tdsPacketSize = 4096;
    private byte[] packetData = new byte[4096];
    private int responseTimeoutSecs;
    private volatile CancelableRequest currentRequest;
    private Socket databaseSocket;
    private InputStream tdsInputStream;
    private OutputStream tdsOutputStream;
    private boolean socketOpen;
    private boolean useGeometricRealloc = false;
    private SQLCollation databaseCollation;
    private static Logger tdsDataLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDS.DATA");
    static final byte B_PRELOGIN_OPTION_VERSION = 0;
    static final byte B_PRELOGIN_OPTION_ENCRYPTION = 1;
    static final byte B_PRELOGIN_OPTION_INSTOPT = 2;
    static final byte B_PRELOGIN_OPTION_THREADID = 3;
    static final byte B_PRELOGIN_OPTION_MARS = 4;
    static final byte B_PRELOGIN_OPTION_TDSVERSION = 5;
    static final byte B_PRELOGIN_OPTION_TERMINATOR = -1;
    static final byte B_PRELOGIN_SSL_OFF = 0;
    static final byte B_PRELOGIN_SSL_ON = 1;
    static final byte B_PRELOGIN_SSL_NOT_SUPPORTED = 2;
    static final byte B_PRELOGIN_SSL_REQUIRED = 3;
    static final byte B_PRELOGIN_MESSAGE_LENGTH = 26;

    final InputStream getTDSInputStream() {
        return this.tdsInputStream;
    }

    final OutputStream getTDSOutputStream() {
        return this.tdsOutputStream;
    }

    void setSendBufferSize(int n) {
        try {
            this.databaseSocket.setSendBufferSize(n);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    void setReceiveBufferSize(int n) {
        try {
            this.databaseSocket.setReceiveBufferSize(n);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    final boolean isLoggingTDSPackets() {
        return tdsDataLogger.isLoggable(Level.FINEST);
    }

    public DBComms(SQLServerConnection sQLServerConnection, String string, int n, int n2) throws SQLServerException, IOException {
        if (0 == n2) {
            this.databaseSocket = new Socket(string, n);
        } else {
            this.databaseSocket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException();
            }
            this.databaseSocket.connect(inetSocketAddress, n2);
        }
        this.tdsInputStream = this.databaseSocket.getInputStream();
        this.tdsOutputStream = this.databaseSocket.getOutputStream();
        this.Prelogin(false);
        this.init(sQLServerConnection);
        this.setReceiveBufferSize(4096);
        this.setSendBufferSize(4096);
        try {
            this.databaseSocket.setTcpNoDelay(true);
            this.databaseSocket.setKeepAlive(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    void Prelogin(boolean bl) throws SQLServerException {
        int n;
        bl = false;
        byte[] byArray = new byte[]{18, 1, 0, 26, 0, 0, 0, 0, 0, 0, 11, 0, 6, 1, 0, 17, 0, 1, -1, 0, 0, 0, 0, 0, 0, bl ? (byte)1 : 2};
        try {
            this.tdsOutputStream.write(byArray);
            this.tdsOutputStream.flush();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_ioErrorSendingTDSPrelogin"), "08006", true);
        }
        int n2 = 0;
        int n3 = 0;
        do {
            n = 0;
            try {
                n = this.tdsInputStream.read(this.packetData, n2, this.packetData.length - n2);
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_ioErrorReceivingTDSPrelogin"), "08006", true);
            }
            if (-1 == n) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_incompleteResponseIsSQL2000"), "08006", true);
            }
            if ((n2 += n) < 8 || false != n3 || n >= (n3 = this.packetData[2] << 8 | this.packetData[3]) && 4 == this.packetData[0] && 1 == this.packetData[1]) continue;
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_incompleteResponseIsSQL2000"), "08006", true);
        } while (n2 < n3);
        n = 0;
        boolean bl2 = false;
        int n4 = 3;
        int n5 = 8;
        while (true) {
            byte by;
            if (n5 + 1 >= n3) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
            }
            if (-1 == (by = this.packetData[n5++])) break;
            if (n5 + 5 >= n3) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
            }
            int n6 = this.packetData[n5++] << 8;
            int n7 = n5++;
            int n8 = this.packetData[n5++] << 8;
            if ((n6 += this.packetData[n7] + 8) > n3 || n6 + (n8 += this.packetData[n5++]) > n3) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
            }
            switch (by) {
                case 0: {
                    if (n != 0) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unexpectedServerVersion"), "08006", true);
                    }
                    if (6 != n8) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_malformedServerVersion"), "08006", true);
                    }
                    if (9 == this.packetData[n6]) {
                        this.tdsVersion = new TDSVersion(114);
                    } else if (8 == this.packetData[n6]) {
                        this.tdsVersion = new TDSVersion(113);
                    } else {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unsupportedServerVersion"), "08006", true);
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    if (bl2) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unexpectedEncryptionOption"), "08006", true);
                    }
                    if (1 != n8) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_malformedEncryptionOption"), "08006", true);
                    }
                    n4 = this.packetData[n6];
                    bl2 = true;
                }
            }
        }
        if (n == 0 || !bl2) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
        }
        if (2 != n4) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_requiresSSL"), "08006", true);
        }
    }

    private void init(SQLServerConnection sQLServerConnection) {
        this.con = sQLServerConnection;
        this.useGeometricRealloc = null != this.con.activeConnectionProperties.getProperty("packetSize");
        this.socketOpen = true;
    }

    public void finalize() {
        this.close();
    }

    public void close() {
        if (!this.socketOpen) {
            return;
        }
        try {
            this.databaseSocket.close();
            this.socketOpen = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    TDSVersion getTDSVersion() {
        return this.tdsVersion;
    }

    public int maxDataSize() {
        return this.tdsPacketSize - 8;
    }

    public void run() {
        try {
            int n = this.responseTimeoutSecs;
            for (int i = 0; i < n; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Thread.currentThread();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            CancelableRequest cancelableRequest = this.currentRequest;
            if (null != cancelableRequest) {
                cancelableRequest.timeout();
            }
        }
        catch (SQLServerException sQLServerException) {
            // empty catch block
        }
    }

    private void readError(String string, int n, int n2) throws SQLServerException {
        if (this.con != null) {
            this.con.notifyPooledConnection(new IOException(string));
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errReadingInput"));
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(this.tdsPacketSize)};
        SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), "08006", true);
    }

    void receive(IOBuffer iOBuffer) throws SQLServerException {
        this.receive(iOBuffer, 0, null);
    }

    void receive(IOBuffer iOBuffer, int n, CancelableRequest cancelableRequest) throws SQLServerException {
        int n2;
        if (this.tdsPacketSize != iOBuffer.getSQLServerConnection().getTDSPacketSize()) {
            n2 = iOBuffer.getSQLServerConnection().getTDSPacketSize();
            this.setReceiveBufferSize(n2);
            this.packetData = new byte[n2];
            this.tdsPacketSize = n2;
        }
        iOBuffer.resetInBuffer();
        n2 = 1;
        int n3 = 0;
        int n4 = 16384;
        Thread thread = null;
        Throwable throwable = null;
        while (n2 != 0) {
            try {
                int n5;
                Object[] objectArray;
                byte by;
                int n6;
                int n7 = 0;
                if (n > 0) {
                    this.currentRequest = cancelableRequest;
                    thread = new Thread(this);
                    thread.setDaemon(true);
                    this.responseTimeoutSecs = n;
                    thread.start();
                }
                while (n7 < 8) {
                    n6 = this.tdsInputStream.read(this.packetData, n7, 8 - n7);
                    if (n6 < 0) {
                        this.readError("Read packet header, Unexpected end of stream, readBytes:" + n6, n3, n7);
                        continue;
                    }
                    n7 += n6;
                }
                if (tdsDataLogger.isLoggable(Level.FINEST)) {
                    this.logTDSPacket(this.packetData, 0, 8, "Received TDS packet header");
                }
                if (thread != null) {
                    thread.interrupt();
                    thread = null;
                }
                if ((by = this.packetData[0]) != 4 && by != 2 && by != 1) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPacketHeader"));
                    objectArray = new Object[]{new Byte(by), new Integer(n3), new Integer(n7)};
                    SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), "08006", true);
                }
                if ((n5 = (this.packetData[3] & 0xFF | (this.packetData[2] & 0xFF) << 8) - 8) < 0) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_negativeDataPacketLength"));
                    Object[] objectArray2 = new Object[]{new Integer(n5), new Integer(n3), new Integer(n7), new Integer(n5)};
                    SQLServerException.makeFromDriverError(this.con, null, objectArray.format(objectArray2), "08006", true);
                }
                n2 = this.packetData[1] != 1 ? 1 : 0;
                int n8 = this.packetData[4] << 8 | this.packetData[5];
                int n9 = iOBuffer.nRecvSize + n5;
                if (null == throwable && n9 > iOBuffer.binDataBuffer.length) {
                    try {
                        if (this.useGeometricRealloc) {
                            int n10;
                            for (n10 = 2 * iOBuffer.binDataBuffer.length; n9 > n10; n10 *= 2) {
                            }
                            iOBuffer.extendByteBuffer(n10 - iOBuffer.binDataBuffer.length);
                        } else {
                            if (n9 > iOBuffer.binDataBuffer.length + n4) {
                                n4 = n9 - iOBuffer.binDataBuffer.length;
                            }
                            iOBuffer.extendByteBuffer(n4);
                            if ((n4 *= 4) > 0x400000) {
                                n4 = 0x400000;
                            }
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throwable = outOfMemoryError;
                        iOBuffer.binDataBuffer = null;
                        iOBuffer.extendByteBuffer(256);
                    }
                }
                n7 = 0;
                while (n7 < n5) {
                    if (null == throwable) {
                        n6 = this.tdsInputStream.read(iOBuffer.binDataBuffer, iOBuffer.nRecvSize, n5 - n7);
                        if (tdsDataLogger.isLoggable(Level.FINEST)) {
                            this.logTDSPacket(iOBuffer.binDataBuffer, iOBuffer.nRecvSize, n6, "SPID " + n8 + ", Received TDS packet " + n3 + " payload: " + n6 + " bytes");
                        }
                    } else {
                        n6 = this.tdsInputStream.read(this.packetData, 0, n5 - n7);
                        if (tdsDataLogger.isLoggable(Level.FINEST)) {
                            this.logTDSPacket(this.packetData, 0, n6, "SPID " + n8 + ", Ignored TDS packet " + n3 + " payload: " + n6 + " bytes");
                        }
                    }
                    if (n6 < 0) {
                        this.readError("Failed to read packet body", n3, n7);
                    }
                    n7 += n6;
                    iOBuffer.nRecvSize += n6;
                }
            }
            catch (IOException iOException) {
                thread = null;
                if (this.con != null) {
                    this.con.notifyPooledConnection(iOException);
                }
                String string = "";
                if (this.con != null) {
                    string = string + "(" + this.con.connectionID + ") ";
                    string = string + this.con.instanceId();
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_receiveException"));
                Object[] objectArray = new Object[]{iOException.getMessage(), string, new Integer(n3), new Integer(iOBuffer.nRecvSize), new Integer(this.tdsPacketSize)};
                SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), "08006", true);
            }
            ++n3;
        }
        ++this.msgsRecd;
        if (null != throwable) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_outOfMemory"));
            Object[] objectArray = new Object[]{throwable.getMessage(), new Integer(iOBuffer.nRecvSize), new Long(Runtime.getRuntime().totalMemory())};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, false);
        }
    }

    void logTDSPacket(byte[] byArray, int n, int n2, String string) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray3 = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray4 = new char[cArray3.length];
        System.arraycopy(cArray3, 0, cArray4, 0, cArray3.length);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 4 * n2 + 4 * (1 + n2 / 16) + 80);
        stringBuffer.append(this.databaseSocket.getLocalAddress().toString() + ":" + this.databaseSocket.getLocalPort() + " Connection ");
        stringBuffer.append(this.con.connectionID);
        stringBuffer.append(", ");
        stringBuffer.append(string);
        stringBuffer.append("\r\n");
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            for (n5 = 0; n5 < 16 && n3 < n2; ++n5, ++n3) {
                n4 = (byArray[n3] + 256) % 256;
                cArray4[3 * n5] = cArray[n4 / 16];
                cArray4[3 * n5 + 1] = cArray[n4 % 16];
                cArray4[50 + n5] = cArray2[n4];
            }
            for (n4 = n5; n4 < 16; ++n4) {
                cArray4[3 * n4] = 32;
                cArray4[3 * n4 + 1] = 32;
            }
            stringBuffer.append(cArray4, 0, 50 + n5);
            if (n3 == n2) break;
            stringBuffer.append("\r\n");
        }
        tdsDataLogger.finest(stringBuffer.toString());
    }

    public boolean socketIsOpen() {
        return this.socketOpen;
    }

    SQLCollation getDatabaseCollation() {
        return this.databaseCollation;
    }

    String getDatabaseCharset() throws SQLServerException {
        if (null == this.databaseCollation) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_charSetNotAvailableForDatabase"), null, 0, true);
        }
        return this.databaseCollation.getCharset();
    }

    void setDatabaseCollation(SQLCollation sQLCollation) {
        this.databaseCollation = sQLCollation;
    }
}

