/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.clonerow;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.clonerow.CloneRowData;
import org.pentaho.di.trans.steps.clonerow.CloneRowMeta;
import org.pentaho.di.trans.steps.clonerow.Messages;

public class CloneRow
extends BaseStep
implements StepInterface {
    private CloneRowMeta meta;
    private CloneRowData data;

    public CloneRow(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CloneRowMeta)smi;
        this.data = (CloneRowData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            if (this.meta.isAddCloneFlag()) {
                String realflagfield = this.environmentSubstitute(this.meta.getCloneFlagField());
                if (Const.isEmpty((String)realflagfield)) {
                    this.logError(Messages.getString("CloneRow.Error.CloneFlagFieldMissing"));
                    throw new KettleException(Messages.getString("CloneRow.Error.CloneFlagFieldMissing"));
                }
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            }
            if (this.meta.isNrCloneInField()) {
                String cloneinfieldname = this.meta.getNrCloneField();
                if (Const.isEmpty((String)cloneinfieldname)) {
                    this.logError(Messages.getString("CloneRow.Error.NrCloneInFieldMissing"));
                    throw new KettleException(Messages.getString("CloneRow.Error.NrCloneInFieldMissing"));
                }
                if (this.data.indexOfNrCloneField < 0) {
                    this.data.indexOfNrCloneField = this.getInputRowMeta().indexOfValue(cloneinfieldname);
                    if (this.data.indexOfNrCloneField < 0) {
                        this.logError(Messages.getString("CloneRow.Log.ErrorFindingField") + "[" + cloneinfieldname + "]");
                        throw new KettleException(Messages.getString("CloneRow.Exception.CouldnotFindField", cloneinfieldname));
                    }
                }
            } else {
                String nrclonesString = this.environmentSubstitute(this.meta.getNrClones());
                this.data.nrclones = Const.toInt((String)nrclonesString, (int)0);
                if (this.log.isDebug()) {
                    this.log.logDebug(this.toString(), Messages.getString("CloneRow.Log.NrClones", "" + this.data.nrclones), new Object[0]);
                }
            }
        }
        if (this.meta.isAddCloneFlag()) {
            Object[] outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)false);
            this.putRow(this.data.outputRowMeta, outputRowData);
        } else {
            this.putRow(this.data.outputRowMeta, r);
        }
        if (this.meta.isNrCloneInField()) {
            this.data.nrclones = this.getInputRowMeta().getInteger(r, this.data.indexOfNrCloneField);
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), Messages.getString("CloneRow.Log.NrClones", "" + this.data.nrclones), new Object[0]);
            }
        }
        int i = 0;
        while ((long)i < this.data.nrclones) {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)this.data.outputRowMeta.size());
            if (this.meta.isAddCloneFlag()) {
                outputRowData = RowDataUtil.addValueData((Object[])outputRowData, (int)this.getInputRowMeta().size(), (Object)true);
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            ++i;
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
            this.logDetailed(Messages.getString("CloneRow.Log.LineNumber", "" + this.getLinesRead()));
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CloneRowMeta)smi;
        this.data = (CloneRowData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

