/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap;

import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OLAPRootObject
extends OLAPObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(OLAPSession.class);
    private final List<OLAPSession> olapSessions = new ArrayList<OLAPSession>();

    public OLAPRootObject() {
        this.setName("OLAP Root Object");
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof OLAPSession) {
            this.olapSessions.add(index, (OLAPSession)child);
            child.setParent((SPObject)this);
            this.fireChildAdded(OLAPSession.class, child, index);
        }
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof OLAPSession) {
            return this.removeOLAPSession((OLAPSession)child);
        }
        return false;
    }

    public boolean removeOLAPSession(OLAPSession removeChild) {
        int pos = this.olapSessions.indexOf((Object)removeChild);
        if (pos != -1) {
            this.removeOLAPSession(pos);
            return true;
        }
        return false;
    }

    public OLAPSession removeOLAPSession(int pos) {
        OLAPSession removedItem = this.olapSessions.remove(pos);
        if (removedItem != null) {
            this.fireChildRemoved(OLAPSession.class, (SPObject)removedItem, pos);
            removedItem.setParent(null);
        }
        return removedItem;
    }

    public boolean allowsChildren() {
        return true;
    }

    @NonProperty
    public List<OLAPSession> getChildren() {
        return Collections.unmodifiableList(this.olapSessions);
    }

    @Override
    public int childPositionOffset(Class<? extends SPObject> childType) {
        if (OLAPSession.class.equals(childType)) {
            return 0;
        }
        throw new IllegalArgumentException("Child type " + childType + " is not a valid child type of " + OLAPRootObject.class);
    }

    @Transient
    @Accessor
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @Transient
    @Accessor
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
    }
}

