/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class PhysicalNameCritic
extends CriticAndSettings {
    private final Pattern legalNamePattern;
    private final int maxNameLength;
    private final String platformName;

    @Constructor
    public PhysicalNameCritic(@ConstructorParameter(propertyName="platformName") String platformName, @ConstructorParameter(propertyName="legalNamePattern") Pattern legalNamePattern, @ConstructorParameter(propertyName="maxNameLength") int maxNameLength) {
        super(platformName, Messages.getString("PhysicalNameCritic.name"));
        this.platformName = platformName;
        this.legalNamePattern = legalNamePattern;
        this.maxNameLength = maxNameLength;
    }

    @Override
    public List<Criticism> criticize(Object subject) {
        if (!(subject instanceof SQLObject)) {
            return Collections.emptyList();
        }
        if (subject instanceof SQLRelationship.ColumnMapping || subject instanceof SQLIndex.Column) {
            return Collections.emptyList();
        }
        final SQLObject so = (SQLObject)subject;
        String physName = so.getPhysicalName();
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        if (physName == null || physName.trim().length() == 0) {
            criticisms.add(new Criticism(so, "No physical name for " + so.getName(), this, new CriticFix("Copy logical name to physical name", CriticFix.FixType.QUICK_FIX){

                @Override
                public void apply() {
                    so.setPhysicalName(so.getName());
                }
            }));
            return criticisms;
        }
        if (physName.length() > this.getMaxNameLength()) {
            criticisms.add(new Criticism(so, "Physical name too long for " + this.getPlatformName(), this, new CriticFix("Truncate name to " + so.getPhysicalName().substring(0, this.getMaxNameLength()), CriticFix.FixType.QUICK_FIX){

                @Override
                public void apply() {
                    if (so.getPhysicalName() != null && so.getPhysicalName().length() > PhysicalNameCritic.this.getMaxNameLength()) {
                        so.setPhysicalName(so.getPhysicalName().substring(0, PhysicalNameCritic.this.getMaxNameLength()));
                    }
                }
            }));
        }
        if (!this.getLegalNamePattern().matcher(physName).matches()) {
            final String newLogicalName = this.correctPhysicalName(so, physName);
            criticisms.add(new Criticism(so, "Physical name not legal for " + so.getPhysicalName(), this, new CriticFix("Replace the physical name with " + newLogicalName, CriticFix.FixType.QUICK_FIX){

                @Override
                public void apply() {
                    so.setPhysicalName(newLogicalName);
                }
            }));
        }
        return criticisms;
    }

    public String correctPhysicalName(Object subject, String existingName) {
        StringBuffer buffer = new StringBuffer(existingName.length());
        for (int i = 0; i < existingName.length(); ++i) {
            if (existingName.charAt(i) == ' ') {
                buffer.append('_');
                continue;
            }
            if (this.getLegalNamePattern().matcher(Character.toString(existingName.charAt(i))).matches()) {
                buffer.append(existingName.charAt(i));
                continue;
            }
            if (i != 0) continue;
            if (subject instanceof SQLTable) {
                buffer.append("Table_" + existingName.charAt(i));
                continue;
            }
            if (subject instanceof SQLColumn) {
                buffer.append("Column_" + existingName.charAt(i));
                continue;
            }
            if (subject instanceof SQLIndex) {
                buffer.append("Index_" + existingName.charAt(i));
                continue;
            }
            buffer.append("X_" + existingName.charAt(i));
        }
        return buffer.toString();
    }

    @Accessor
    public Pattern getLegalNamePattern() {
        return this.legalNamePattern;
    }

    @Accessor
    public int getMaxNameLength() {
        return this.maxNameLength;
    }

    @Accessor
    public String getPlatformName() {
        return this.platformName;
    }
}

