/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.task;

import de.rub.nds.tlsattacker.attacks.util.response.ResponseExtractor;
import de.rub.nds.tlsattacker.attacks.util.response.ResponseFingerprint;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.DefaultWorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.task.TlsTask;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InvalidCurveTask
extends TlsTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int appliedSecret;
    private final State state;
    private ResponseFingerprint fingerprint;
    private Point receivedEcKey;

    public InvalidCurveTask(State state, int reexecutions, int appliedSecret) {
        super(reexecutions);
        this.appliedSecret = appliedSecret;
        this.state = state;
    }

    @Override
    public void reset() {
        this.getState().reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        try {
            DefaultWorkflowExecutor executor = new DefaultWorkflowExecutor(this.getState());
            ((WorkflowExecutor)executor).executeWorkflow();
            if (this.getState().getTlsContext().getServerEcPublicKey() != null) {
                this.receivedEcKey = this.getState().getTlsContext().getServerEcPublicKey();
            }
            if (!this.state.getWorkflowTrace().executedAsPlanned()) {
                boolean bl = false;
                return bl;
            }
            this.fingerprint = ResponseExtractor.getFingerprint(this.getState());
            if (this.fingerprint == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                this.getState().getTlsContext().getTransportHandler().closeConnection();
            }
            catch (IOException ex) {
                LOGGER.debug((Object)ex);
            }
        }
    }

    public Point getReceivedEcKey() {
        return this.receivedEcKey;
    }

    public State getState() {
        return this.state;
    }

    public ResponseFingerprint getFingerprint() {
        return this.fingerprint;
    }

    public int getAppliedSecret() {
        return this.appliedSecret;
    }
}

