/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.keyfilemanager;

import de.rub.nds.x509attacker.filesystem.BinaryFileReader;
import de.rub.nds.x509attacker.keyfilemanager.KeyFileManagerException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class KeyFileManager {
    private static KeyFileManager reference = null;
    private File keyFileDirectory = new File("");
    private final Map<String, byte[]> keyFileMap = new HashMap<String, byte[]>();

    private KeyFileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyFileManager getReference() {
        if (reference != null) return reference;
        Class<KeyFileManager> clazz = KeyFileManager.class;
        synchronized (KeyFileManager.class) {
            if (reference != null) return reference;
            reference = new KeyFileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return reference;
        }
    }

    public void init(String keyFileDirectory) throws KeyFileManagerException {
        if (this.keyFileMap.isEmpty()) {
            this.keyFileDirectory = new File(keyFileDirectory);
            this.readAllKeyFiles();
        }
    }

    private void readAllKeyFiles() throws KeyFileManagerException {
        File[] keyFiles = this.keyFileDirectory.listFiles();
        if (keyFiles != null) {
            for (File keyFile : keyFiles) {
                this.readKeyFile(keyFile);
            }
        }
    }

    private void readKeyFile(File keyFile) throws KeyFileManagerException {
        try {
            BinaryFileReader binaryFileReader = new BinaryFileReader(keyFile.getAbsolutePath());
            byte[] keyFileContent = binaryFileReader.read();
            this.addKeyFile(keyFile.getName(), keyFileContent);
        }
        catch (IOException e) {
            throw new KeyFileManagerException(e);
        }
    }

    private void addKeyFile(String filename, byte[] content) throws KeyFileManagerException {
        String sanitizedFilename = this.sanitizeKeyFileName(filename);
        if (!this.keyFileMap.containsKey(sanitizedFilename)) {
            this.keyFileMap.put(sanitizedFilename, content);
        }
    }

    private String sanitizeKeyFileName(String filename) throws KeyFileManagerException {
        return filename.trim();
    }

    public byte[] getKeyFileContent(String filename) throws KeyFileManagerException {
        String sanitizedFilename = this.sanitizeKeyFileName(filename);
        if (this.keyFileMap.containsKey(sanitizedFilename)) {
            return this.keyFileMap.get(sanitizedFilename);
        }
        throw new KeyFileManagerException("Key file " + filename + " is not available!");
    }
}

