/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.xppdom.Xpp3Dom;
import java.util.LinkedList;

public class XppDomWriter
extends AbstractXmlWriter {
    private LinkedList elementStack = new LinkedList();
    private Xpp3Dom configuration;

    public XppDomWriter() {
        this(new XmlFriendlyReplacer());
    }

    public XppDomWriter(XmlFriendlyReplacer replacer) {
        super(replacer);
    }

    public Xpp3Dom getConfiguration() {
        return this.configuration;
    }

    public void startNode(String name) {
        Xpp3Dom configuration = new Xpp3Dom(this.escapeXmlName(name));
        if (this.configuration == null) {
            this.configuration = configuration;
        } else {
            this.top().addChild(configuration);
        }
        this.elementStack.addLast(configuration);
    }

    public void startNode(String name, Class clazz) {
        this.startNode(name);
    }

    public void setValue(String text) {
        this.top().setValue(text);
    }

    public void addAttribute(String key, String value) {
        this.top().setAttribute(this.escapeXmlName(key), value);
    }

    public void endNode() {
        this.elementStack.removeLast();
    }

    private Xpp3Dom top() {
        return (Xpp3Dom)this.elementStack.getLast();
    }

    public void flush() {
    }

    public void close() {
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }
}

