/*
    MAValueData - NSData that knows what type of data it stores.
 
    Copyright (C) 1995, Adam Fedor.
*/

#ifndef __MAValueData_INCLUDE_
#define __MAValueData_INCLUDE_

#ifndef GNUSTEP
#import <Foundation/Foundation.h>
#else
#include <Foundation/NSData.h>
#include <Foundation/NSGeometry.h>
#endif

@class NSString;
@class NSArray;
@class NSValue;

@protocol ValueData

// Allocating and Initializing
+ dataWithValues:(const void *)values
	count:(unsigned)count
	objCType:(const char *)type;
+ dataWithValuesNoCopy:(void *)values
	count:(unsigned)count
	objCType:(const char *)type;
+ dataWithPoints:(const void *)pointArray
	count:(unsigned)count;
+ dataWithRects:(const void *)rectArray
	count:(unsigned)count;
+ dataWithValueList:(NSArray *)valueList;

- initWithValues:(const void *)values
	count:(unsigned)count
	objCType:(const char *)type;
- initWithValuesNoCopy:(void *)values
	count:(unsigned)count
	objCType:(const char *)type;
- initWithData:(NSData *)data
	objCType:(const char *)type;
- initWithDataNoCopy:(NSData *)data
	objCType:(const char *)type;
- initWithValueList:(NSArray *)valueArray;

// Accessing Data
- (const NSPoint *)pointArray;
- (const NSRect *)rectArray;
- (NSArray *)valueList;
- (NSValue *)valueAtIndex:(unsigned)index;

- (void) getValues:(void *)buffer range: (NSRange)range;

// Querying values
- (unsigned)count;
- (const char *)objCType;

@end

@interface MAValueData : 
	NSData <ValueData, NSCopying, NSMutableCopying, NSCoding>
{
    NSData	*data;
    NSString	*c_type;
}

@end

@interface MAMutableValueData : MAValueData

+ dataWithCount:(unsigned)count
	objCType:(const char *)type;

- initWithCount:(unsigned)count
	objCType:(const char *)type;

- (void *)mutableBytes;

// Adjusting Capacity
- (void)increaseCountBy:(unsigned int)extraCount;
- (void)setCount:(unsigned)count;

// Appending Values
- (void)appendValues:(const void *)values
	count:(unsigned)count;
- (void)appendValueData:(MAValueData *)other;

// Modifying Values
- (void)replaceValuesInRange:(NSRange)aRange
	withValues:(const void *)values;
- (void)setValue:(NSValue *)value atIndex:(unsigned)index;

@end

@interface MAMutableValueData (ValueCasting)

-(void)setObjCType:(const char *)type;

@end

#endif /* __MAValueData_INCLUDE_ */
