# Atari Lynx instrument editor

Atari Lynx instrument editor consists of two tabs: Sample and Macros.

## Sample

for sample settings, see [the Sample instrument editor](sample.md).

the only differences are the lack of an "Use wavetable" option, and the presence of a "Use sample" one.

note that using samples on Lynx is CPU expensive!

## Macros

- **Volume**: volume sequence.
- **Arpeggio**: pitch sequence.
- **Duty/Int**: bit pattern for LFSR taps and integration.
- **Panning (left)**: output level for left channel.
- **Panning (right)**: output level for right channel.
- **Pitch**: fine pitch.
- **Phase Reset**: trigger restart of waveform/LFSR reset.
- **Load LFSR**: load a value to the LFSR.

## audio generation description

Atari Lynx generates sound using a 12-bit linear feedback shift register (LFSR) with configurable tap. nine separate bits can be enabled to be the source of feedback: 0, 1, 2, 3, 4, 5, 7, 10 and 11. to generate _any_ sound at least one bit _must_ be enabled.

### LFSR-based synthesis

a linear-feedback shift register is one method used for random number generation.
it works by shifting a sequence of binary numbers (bits), taking the last bit into the output. then some of the bits are combined with others, doing a XOR (exclusive or) operation and then being pushed back.

think of it as a conveyor carrying glass bottles. each bottle may be empty or carrying water.
the bottle at the end is taken. if there's water, then the output is 1. if it's empty, the output is 0.
depending on the LFSR configuration, many bottles at specific positions ("taps") are looked at. these are combined from left to right, two by two:
- if two bottles are identical, an empty bottle is pushed.
- if one bottle has water but the other is empty, a water bottle is pushed.
the process is repeated indefinitely.

unlike PowerNoise, Lynx's taps are in fixed positions, but it has many of them.

### square wave

the LFSR is shifted at the rate define by sound pitch and generates square wave by setting channel output value to +volume or -volume, depending on the bit shifted in.

### triangle wave

alternatively when "int" bit is set sound wave is generated by adding or subtracting volume from output effectively producing triangle wave.

#### how triangle wave works?

hint: to obtain triangle set bits "int" and "11" in "Duty/Int" sequence and set volume to about 22.
by enabling 11th tap bit the value shifted in is negated after 11 bit is shifted in hence the volume is added for 11 cycles and then subtracted for 11 cycles.
