/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.text;

import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.openhab.core.voice.text.ASTNode;
import org.openhab.core.voice.text.Expression;
import org.openhab.core.voice.text.TokenList;

public final class ExpressionLet
extends Expression {
    private Expression subExpression;
    private String name;
    private Object value;
    private Object tag;

    public ExpressionLet(String name, Expression subExpression) {
        this(name, subExpression, null, null);
    }

    public ExpressionLet(Expression subExpression, Object value) {
        this(null, subExpression, value, null);
    }

    public ExpressionLet(String name, Expression subExpression, Object value, Object tag) {
        if (name != null) {
            this.name = name;
        }
        this.subExpression = subExpression;
        if (value != null) {
            this.value = value;
        }
        if (tag != null) {
            this.tag = tag;
        }
    }

    @Override
    ASTNode parse(ResourceBundle language, TokenList list) {
        ASTNode node = this.subExpression.parse(language, list);
        if (node.isSuccess()) {
            node.setName(this.name);
            if (this.value != null) {
                node.setValue(this.value);
            }
            if (this.tag != null) {
                node.setTag(this.tag);
            }
        }
        return node;
    }

    @Override
    List<Expression> getChildExpressions() {
        return List.of(this.subExpression);
    }

    @Override
    boolean collectFirsts(ResourceBundle language, Set<String> firsts) {
        return this.subExpression.collectFirsts(language, firsts);
    }

    public String toString() {
        return "let(\"" + this.name + "\", " + this.subExpression.toString() + ", \"" + String.valueOf(this.value) + "\", \"" + String.valueOf(this.tag) + "\")";
    }

    public Expression getSubExpression() {
        return this.subExpression;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getTag() {
        return this.tag;
    }
}

