/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Internal;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.AbstractFieldSerialForm;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccessException;

@Internal
public class GetterFieldImpl
implements Getter {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass;
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;
    private final @UnknownKeyFor @NonNull @Initialized Field field;
    private final @Nullable @UnknownKeyFor @Initialized Method getterMethod;

    public GetterFieldImpl(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Field field) {
        this(containerClass, propertyName, field, ReflectHelper.findGetterMethodForFieldAccess(field, propertyName));
    }

    GetterFieldImpl(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Field field, @UnknownKeyFor @NonNull @Initialized Method getterMethod) {
        this.containerClass = containerClass;
        this.propertyName = propertyName;
        this.field = field;
        this.getterMethod = getterMethod;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object get(@UnknownKeyFor @NonNull @Initialized Object owner) {
        try {
            return this.field.get(owner);
        }
        catch (Exception e) {
            throw new PropertyAccessException(String.format(Locale.ROOT, "Error accessing field [%s] by reflection for persistent property [%s#%s] : %s", this.field.toGenericString(), this.containerClass.getName(), this.propertyName, owner), e);
        }
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object getForInsert(@UnknownKeyFor @NonNull @Initialized Object owner, @UnknownKeyFor @NonNull @Initialized Map mergeMap, @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor session) {
        return this.get(owner);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getReturnTypeClass() {
        return this.field.getType();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Type getReturnType() {
        return this.field.getGenericType();
    }

    public @UnknownKeyFor @NonNull @Initialized Field getField() {
        return this.field;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Member getMember() {
        return this.getField();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getMethodName() {
        return this.getterMethod != null ? this.getterMethod.getName() : null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Method getMethod() {
        return this.getterMethod;
    }

    private @UnknownKeyFor @NonNull @Initialized Object writeReplace() throws @UnknownKeyFor @NonNull @Initialized ObjectStreamException {
        return new SerialForm(this.containerClass, this.propertyName, this.field);
    }

    private static class SerialForm
    extends AbstractFieldSerialForm
    implements Serializable {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass;
        private final @UnknownKeyFor @NonNull @Initialized String propertyName;

        private SerialForm(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Field field) {
            super(field);
            this.containerClass = containerClass;
            this.propertyName = propertyName;
        }

        private @UnknownKeyFor @NonNull @Initialized Object readResolve() {
            return new GetterFieldImpl(this.containerClass, this.propertyName, this.resolveField());
        }
    }
}

